/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.crafting.building;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.Locale;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.api.crafting.itf.IFileDecoder;

public class GsonFileDecoder
implements IFileDecoder<JsonElement> {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String PATH_SUFFIX = ".json";
    private static final int PATH_SUFFIX_LENGTH = ".json".length();
    final String directory;
    final String directoryLower;
    private final Gson gson;

    public GsonFileDecoder(String directory) {
        this(directory, GSON);
    }

    public GsonFileDecoder(String directory, Gson gson) {
        this.directory = directory;
        this.directoryLower = directory.toLowerCase(Locale.ROOT);
        this.gson = gson;
    }

    @Override
    public boolean doesPathMatch(ResourceLocation location) {
        String s = location.m_135815_().toLowerCase(Locale.ROOT);
        return s.endsWith(PATH_SUFFIX) && s.startsWith(this.directoryLower);
    }

    @Override
    public ResourceLocation transformPathToId(ResourceLocation location) {
        int i = this.directory.length() + 1;
        String s = location.m_135815_();
        int endIndex = s.length() - PATH_SUFFIX_LENGTH;
        if (i < 0 || i > endIndex || endIndex > s.length()) {
            return null;
        }
        return new ResourceLocation(location.m_135827_(), s.substring(i, endIndex));
    }

    @Override
    public Optional<JsonElement> tryDecode(ResourceLocation path, BufferedReader reader) throws IOException {
        try {
            return Optional.ofNullable((JsonElement)GsonHelper.m_13776_((Gson)this.gson, (Reader)reader, JsonElement.class));
        }
        catch (JsonParseException | IllegalArgumentException err) {
            HammerLib.LOG.error("Couldn't parse data file {} from {}", (Object)this.transformPathToId(path), (Object)path, (Object)err);
            return Optional.empty();
        }
    }

    @Override
    public void write(JsonElement data, BufferedWriter writer) throws IOException {
        writer.write(GSON.toJson(data));
    }
}

