/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.annotations.client;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Field;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.javafmlmod.FMLModContainer;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.annotations.ap.IAPContext;
import org.zeith.hammerlib.annotations.ap.IAnnotationProcessor;
import org.zeith.hammerlib.annotations.ap.RegisterAP;

@Retention(value=RetentionPolicy.CLASS)
@Target(value={ElementType.FIELD})
public @interface Particles {
    public Class<?> value();

    @RegisterAP(value=Particles.class, clientOnly=true)
    public static class AP
    implements IAnnotationProcessor<Particles> {
        @Override
        public void onPostRegistered(IAPContext context, Particles annotation, Field field, Object value) {
            FMLModContainer mc = context.getOwnerMod().orElse(null);
            if (mc != null && value instanceof ParticleType) {
                ParticleType pt = (ParticleType)value;
                mc.getEventBus().addListener(HammerLib.PROXY.addParticleTypeProvider(pt, annotation.value()));
                String id = context.getRegistryName().map(ResourceLocation::toString).orElse("??:??");
                HammerLib.LOG.debug("Applied ParticleProvider for {}[{}] {}.{}", (Object)field.getType().getSimpleName(), (Object)id, (Object)field.getDeclaringClass().getSimpleName(), (Object)field.getName());
            }
        }
    }
}

