/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.annotations;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.java.ReflectionUtil;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={})
public @interface Ref {
    public Class<?> value();

    public String field() default "";

    public static class Resolver {
        public static boolean isFieldSet(Ref ref) {
            return Resolver.isTypeSet(ref) && !ref.field().isBlank();
        }

        public static boolean isTypeSet(Ref ref) {
            return !Void.TYPE.equals(ref.value());
        }

        @Nullable
        public static Object resolveField(Ref ref) {
            return ReflectionUtil.getStaticFinalField(ref.value(), ref.field()).orElse(null);
        }

        @Nullable
        public static <T> T resolveField(Class<T> type, Ref ref) {
            return Cast.cast(Resolver.resolveField(ref), type);
        }

        @NotNull
        public static List<Object> resolveFields(Ref[] ref) {
            if (ref == null || ref.length == 0) {
                return List.of();
            }
            return Arrays.stream(ref).filter(Resolver::isFieldSet).map(Resolver::resolveField).filter(Objects::nonNull).toList();
        }

        @NotNull
        public static <T> List<T> resolveFields(Class<T> type, Ref[] refs) {
            if (refs == null || refs.length == 0) {
                return List.of();
            }
            return Arrays.stream(refs).filter(Resolver::isFieldSet).map(ref -> Resolver.resolveField(type, ref)).filter(Objects::nonNull).toList();
        }
    }
}

