/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.ui.vanilla;

import de.ambertation.wunderlib.configs.ConfigFile;
import de.ambertation.wunderlib.ui.ColorHelper;
import de.ambertation.wunderlib.ui.layout.components.Checkbox;
import de.ambertation.wunderlib.ui.layout.components.Container;
import de.ambertation.wunderlib.ui.layout.components.HorizontalStack;
import de.ambertation.wunderlib.ui.layout.components.LayoutComponent;
import de.ambertation.wunderlib.ui.layout.components.MultiLineText;
import de.ambertation.wunderlib.ui.layout.components.Text;
import de.ambertation.wunderlib.ui.layout.components.VerticalStack;
import de.ambertation.wunderlib.ui.vanilla.LayoutScreen;
import java.util.LinkedList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class ConfigScreen
extends LayoutScreen {
    protected final List<ConfigFile> configFiles;
    protected final List<OnCheckboxChangeEvent> checkboxListeners;

    public ConfigScreen(Component component, List<ConfigFile> configs) {
        this(null, component, configs, 20, 10, 20, 15);
    }

    public ConfigScreen(@Nullable Screen parent, Component component, List<ConfigFile> configs) {
        this(parent, component, configs, 20, 10, 20, 15);
    }

    public ConfigScreen(@Nullable Screen parent, Component component, List<ConfigFile> configs, int topPadding, int bottomPadding, int sidePadding) {
        this(parent, component, configs, topPadding, bottomPadding, sidePadding, 15);
    }

    public ConfigScreen(@Nullable Screen parent, Component component, List<ConfigFile> configs, int topPadding, int bottomPadding, int sidePadding, int titleSpacing) {
        super(parent, component, topPadding, bottomPadding, sidePadding, titleSpacing);
        this.configFiles = configs;
        this.checkboxListeners = new LinkedList<OnCheckboxChangeEvent>();
    }

    @Override
    protected LayoutComponent<?, ?> initContent() {
        VerticalStack content = (VerticalStack)new VerticalStack(ConfigScreen.fill(), ConfigScreen.fit()).centerHorizontal();
        content.addSpacer(4);
        content.add((LayoutComponent)this.fromConfigFiles(this.configFiles));
        VerticalStack verticalScroll = (VerticalStack)new VerticalStack(ConfigScreen.fill(), ConfigScreen.fill()).setDebugName("vertical scroll");
        verticalScroll.addScrollable(content);
        Container main = new Container(ConfigScreen.fill(), ConfigScreen.fill()).addChild(verticalScroll);
        main.setBackgroundColor(0x77000000);
        main.setPadding(4, 0, 0, 0);
        HorizontalStack buttons = (HorizontalStack)new HorizontalStack(ConfigScreen.fill(), ConfigScreen.fixed(20)).setDebugName("buttons");
        buttons.addFiller();
        buttons.addButton(ConfigScreen.fit(), ConfigScreen.fit(), CommonComponents.f_130655_).onPress(bt -> this.closeScreen());
        VerticalStack all = (VerticalStack)new VerticalStack(ConfigScreen.fill(), ConfigScreen.fill()).setDebugName("all");
        all.add((LayoutComponent)main);
        all.addSpacer(3);
        all.add((LayoutComponent)buttons);
        return all;
    }

    protected LayoutComponent<?, ?> fromConfigFiles(List<ConfigFile> files) {
        List groups = ConfigFile.getAllGroups(files);
        VerticalStack content = (VerticalStack)((VerticalStack)new VerticalStack(ConfigScreen.fill(), ConfigScreen.fit()).alignTop()).setDebugName("Config - " + ConfigFile.getAllCategories(files));
        for (ConfigFile.Group group : groups) {
            this.addGroupHeader(content, group);
            content.indent(8).add((LayoutComponent)this.fromConfigGroup(group, files));
            this.addGroupFooter(content, group);
        }
        return content;
    }

    protected void addGroupHeader(VerticalStack content, ConfigFile.Group group) {
        Component text = this.getGroupTitle(group);
        Style s = text.m_7383_().m_131136_(Boolean.valueOf(true));
        content.add((LayoutComponent)new Text(ConfigScreen.fit(), ConfigScreen.fit(), (Component)text.m_6881_().m_6270_(s)).alignLeft());
        content.addSpacer(4);
    }

    protected void addGroupFooter(VerticalStack content, ConfigFile.Group group) {
        content.addSpacer(8);
    }

    protected LayoutComponent<?, ?> finalizeGroupContent(ConfigFile.Group group, VerticalStack content) {
        return content.alignLeft();
    }

    protected LayoutComponent<?, ?> fromConfigGroup(ConfigFile.Group group, List<ConfigFile> configFiles) {
        List sortedValues = ConfigFile.getAllVisibleValues((ConfigFile.Group)group, configFiles);
        VerticalStack content = (VerticalStack)new VerticalStack(ConfigScreen.fill(), ConfigScreen.fit()).setDebugName("Group - " + group.title());
        List<ConfigFile.Value<?, ?>> toplevelValues = this.getDependantValues(null, sortedValues);
        this.fromValues(group, sortedValues, toplevelValues, content);
        return this.finalizeGroupContent(group, content);
    }

    private void fromValues(ConfigFile.Group group, List<ConfigFile.Value<?, ?>> allValues, List<ConfigFile.Value<?, ?>> values, VerticalStack content) {
        for (ConfigFile.Value<?, ?> value : values) {
            LayoutElement element = this.fromConfig(group, value);
            if (element == null) continue;
            content.add((LayoutComponent)element.component);
            content.addSpacer(2);
            List<ConfigFile.Value<?, ?>> dependantValues = this.getDependantValues(value, allValues);
            if (dependantValues.isEmpty()) continue;
            VerticalStack subContent = (VerticalStack)new VerticalStack(ConfigScreen.fill(), ConfigScreen.fit()).setDebugName("Dependencies - " + value.token.path() + "." + value.token.key());
            this.fromValues(group, allValues, dependantValues, subContent);
            HorizontalStack indent = (HorizontalStack)new HorizontalStack(ConfigScreen.fill(), ConfigScreen.fit()).setDebugName("Dependency - " + value.token.path() + "." + value.token.key());
            indent.addSpacer(element.bestIndent);
            indent.add((LayoutComponent)subContent);
            content.add((LayoutComponent)indent);
            content.addSpacer(8);
        }
    }

    protected LayoutElement fromConfig(ConfigFile.Group group, ConfigFile.Value<?, ?> value) {
        if (value instanceof ConfigFile.BooleanValue) {
            ConfigFile.BooleanValue b = (ConfigFile.BooleanValue)value;
            return this.fromConfig(group, b);
        }
        return null;
    }

    protected LayoutElement fromConfig(ConfigFile.Group group, ConfigFile.BooleanValue value) {
        Component desc = this.getValueDescription(value);
        Checkbox checkBox = (Checkbox)new Checkbox(ConfigScreen.fit(), ConfigScreen.fit(), this.getValueTitle(value), (Boolean)value.getRaw(), desc == null).onChange((cb, b) -> {
            value.set(b);
            this.onChange(value, cb, b);
        }).setDebugName("Config - " + value.token.path() + "." + value.token.key());
        if (value.hasDependency()) {
            this.checkboxListeners.add((changedValue, cb, state) -> {
                if (value.getDependency().equals(changedValue)) {
                    checkBox.setEnabled(state);
                }
            });
        }
        if (desc == null) {
            return new LayoutElement(checkBox, 8);
        }
        VerticalStack descCol = (VerticalStack)((VerticalStack)new VerticalStack(ConfigScreen.fill(), ConfigScreen.fit()).alignLeft()).setDebugName("Config Labels- " + value.token.path() + "." + value.token.key());
        descCol.addSpacer(1);
        descCol.addText(ConfigScreen.fit(), ConfigScreen.fit(), this.getValueTitle(value)).alignLeft();
        descCol.addSpacer(2);
        ((MultiLineText)descCol.addMultilineText(ConfigScreen.fill(), ConfigScreen.fit(), MultiLineText.parse(desc)).alignLeft()).setColor(ColorHelper.GRAY);
        descCol.addSpacer(4);
        HorizontalStack row = (HorizontalStack)new HorizontalStack(ConfigScreen.fill(), ConfigScreen.fit()).setDebugName("Config - " + value.token.path() + "." + value.token.key());
        row.add((LayoutComponent)checkBox);
        row.add((LayoutComponent)descCol);
        return new LayoutElement(row, 24);
    }

    protected <T, R extends ConfigFile.Value<T, R>> Component getGroupTitle(ConfigFile.Group group) {
        return Component.m_237115_((String)("title.config.group." + group.modID() + "." + group.title()));
    }

    protected <T, R extends ConfigFile.Value<T, R>> Component getValueDescription(ConfigFile.Value<T, R> option) {
        StringBuilder sb = new StringBuilder("description.config.");
        if (option.getParentFile() != null) {
            sb.append(option.getParentFile().category).append(".");
        }
        sb.append(option.token.path()).append(".").append(option.token.key());
        String key = sb.toString();
        if (!Language.m_128107_().m_6722_(key)) {
            return null;
        }
        return Component.m_237115_((String)key);
    }

    protected <T, R extends ConfigFile.Value<T, R>> Component getValueTitle(ConfigFile.Value<T, R> option) {
        StringBuilder sb = new StringBuilder("title.config.");
        if (option.getParentFile() != null) {
            sb.append(option.getParentFile().category).append(".");
        }
        sb.append(option.token.path()).append(".").append(option.token.key());
        return Component.m_237115_((String)sb.toString());
    }

    protected List<ConfigFile.Value<?, ?>> getDependantValues(ConfigFile.Value<?, ?> source, List<ConfigFile.Value<?, ?>> sortedValues) {
        LinkedList dependantValues = new LinkedList();
        for (ConfigFile.Value<?, ?> value : sortedValues) {
            if (value.getDependency() != source) continue;
            dependantValues.add(value);
        }
        return dependantValues;
    }

    protected void onChange(ConfigFile.Value<?, ?> value, Checkbox cb, boolean newValue) {
        this.checkboxListeners.forEach(l -> l.onChange(value, cb, newValue));
    }

    protected record LayoutElement(LayoutComponent<?, ?> component, int bestIndent) {
    }

    @FunctionalInterface
    public static interface OnCheckboxChangeEvent {
        public void onChange(ConfigFile.Value<?, ?> var1, Checkbox var2, boolean var3);
    }
}

