/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.ui.layout.components;

import de.ambertation.wunderlib.ui.layout.components.AbstractVanillaComponent;
import de.ambertation.wunderlib.ui.layout.components.AbstractVanillaComponentRenderer;
import de.ambertation.wunderlib.ui.layout.components.render.EditBoxRenderer;
import de.ambertation.wunderlib.ui.layout.values.Value;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.network.chat.Component;
import net.minecraft.util.FormattedCharSequence;

@Environment(value=EnvType.CLIENT)
public class Input
extends AbstractVanillaComponent<EditBox, Input> {
    private Consumer<String> responder;
    private BiFunction<String, Integer, FormattedCharSequence> formatter;
    private Predicate<String> filter;
    private String initialValue = "";

    public Input(Value width, Value height, Component component, String initialValue) {
        super(width, height, new EditBoxRenderer(), component);
        this.initialValue = initialValue;
    }

    @Override
    protected EditBox createVanillaComponent() {
        EditBox eb = new EditBox(((AbstractVanillaComponentRenderer)this.renderer).getFont(), 0, 0, this.relativeBounds.width, this.relativeBounds.height, null, this.component);
        if (this.responder != null) {
            eb.m_94151_(this.responder);
        }
        if (this.filter != null) {
            eb.m_94153_(this.filter);
        }
        if (this.formatter != null) {
            eb.m_94149_(this.formatter);
        }
        eb.m_94144_(this.initialValue);
        eb.m_94182_(true);
        eb.m_94186_(true);
        return eb;
    }

    public Input setResponder(Consumer<String> consumer) {
        this.responder = consumer;
        if (this.vanillaComponent != null) {
            ((EditBox)this.vanillaComponent).m_94151_(this.responder);
        }
        return this;
    }

    public Input setFormatter(BiFunction<String, Integer, FormattedCharSequence> formatter) {
        this.formatter = formatter;
        if (this.vanillaComponent != null) {
            ((EditBox)this.vanillaComponent).m_94149_(formatter);
        }
        return this;
    }

    public Input setFilter(Predicate<String> filter) {
        this.filter = filter;
        if (this.vanillaComponent != null) {
            ((EditBox)this.vanillaComponent).m_94153_(filter);
        }
        return this;
    }

    public String getValue() {
        if (this.vanillaComponent != null) {
            return ((EditBox)this.vanillaComponent).m_94155_();
        }
        return "";
    }

    public Input setValue(String value) {
        if (this.vanillaComponent != null) {
            ((EditBox)this.vanillaComponent).m_94144_(value);
        } else {
            this.initialValue = value;
        }
        return this;
    }

    @Override
    protected Component contentComponent() {
        return Component.m_237113_((String)(this.initialValue + ".."));
    }

    @Override
    public void m_93692_(boolean bl) {
        super.m_93692_(bl);
    }

    @Override
    public boolean m_6375_(double x, double y, int button) {
        return super.m_6375_(x, y, button);
    }

    @Override
    public boolean m_93696_() {
        return super.m_93696_();
    }
}

