/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.ui.layout.components;

import de.ambertation.wunderlib.ui.layout.components.LayoutComponent;
import de.ambertation.wunderlib.ui.layout.components.input.RelativeContainerEventHandler;
import de.ambertation.wunderlib.ui.layout.components.render.ComponentRenderer;
import de.ambertation.wunderlib.ui.layout.components.render.RenderHelper;
import de.ambertation.wunderlib.ui.layout.values.Alignment;
import de.ambertation.wunderlib.ui.layout.values.Rectangle;
import de.ambertation.wunderlib.ui.layout.values.Value;
import java.util.LinkedList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public class Container
extends LayoutComponent<ContainerRenderer, Container>
implements RelativeContainerEventHandler {
    private final List<Positional> children = new LinkedList<Positional>();
    boolean dragging = false;
    GuiEventListener focused = null;
    boolean visible = true;
    int paddingLeft;
    int paddingTop;
    int paddingRight;
    int paddingBottom;
    int backgroundColor = 0;
    int outlineColor = 0;

    public Container(Value width, Value height) {
        super(width, height, new ContainerRenderer());
        ((ContainerRenderer)this.renderer).linkedContainer = this;
    }

    public Container addChild(LayoutComponent<?, ?> child) {
        this.children.add(new Positional(0, 0, child));
        return this;
    }

    public Container addChild(int left, int top, LayoutComponent<?, ?> child) {
        this.children.add(new Positional(left, top, child));
        return this;
    }

    public Container setVisible(boolean v) {
        this.visible = v;
        return this;
    }

    public boolean getVisible() {
        return this.visible;
    }

    public Container setBackgroundColor(int color) {
        this.backgroundColor = color;
        return this;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public Container setOutlineColor(int color) {
        this.outlineColor = color;
        return this;
    }

    public int getOutlineColor() {
        return this.outlineColor;
    }

    public Container setPadding(int padding) {
        return this.setPadding(padding, padding, padding, padding);
    }

    public Container setPadding(int left, int top, int right, int bottom) {
        this.paddingLeft = left;
        this.paddingTop = top;
        this.paddingRight = right;
        this.paddingBottom = bottom;
        return this;
    }

    @Override
    public int getContentWidth() {
        return this.children.stream().map(Positional::getMaxX).reduce(0, Math::max) + this.paddingLeft + this.paddingRight;
    }

    @Override
    public int getContentHeight() {
        return this.children.stream().map(Positional::getMaxY).reduce(0, Math::max) + this.paddingTop + this.paddingBottom;
    }

    @Override
    public Rectangle getInputBounds() {
        return this.relativeBounds;
    }

    public List<? extends GuiEventListener> m_6702_() {
        return this.children.stream().map(p -> p.component).toList();
    }

    public boolean m_7282_() {
        return this.dragging;
    }

    public void m_7897_(boolean bl) {
        this.dragging = bl;
    }

    @Nullable
    public GuiEventListener m_7222_() {
        return this.focused;
    }

    public void m_7522_(@Nullable GuiEventListener guiEventListener) {
        this.focused = guiEventListener;
    }

    @Override
    protected int updateContainerWidth(int containerWidth) {
        int myWidth = this.width.calculateOrFill(containerWidth);
        for (Positional child : this.children) {
            child.component.width.calculateOrFill(myWidth - (this.paddingLeft + this.paddingRight));
            child.component.updateContainerWidth(child.component.width.calculatedSize());
        }
        return myWidth;
    }

    @Override
    protected int updateContainerHeight(int containerHeight) {
        int myHeight = this.height.calculateOrFill(containerHeight);
        for (Positional child : this.children) {
            child.component.height.calculateOrFill(myHeight - (this.paddingTop + this.paddingBottom));
            child.component.updateContainerHeight(child.component.height.calculatedSize());
        }
        return myHeight;
    }

    @Override
    protected void renderInBounds(GuiGraphics guiGraphics, int mouseX, int mouseY, float deltaTicks, Rectangle renderBounds, Rectangle clipRect) {
        if (this.visible) {
            super.renderInBounds(guiGraphics, mouseX, mouseY, deltaTicks, renderBounds, clipRect);
            this.setClippingRect(clipRect);
            for (Positional child : this.children) {
                child.component.render(guiGraphics, mouseX, mouseY, deltaTicks, renderBounds, clipRect);
            }
            this.setClippingRect(null);
        }
    }

    @Override
    void setRelativeBounds(int left, int top) {
        super.setRelativeBounds(left, top);
        for (Positional child : this.children) {
            int childLeft = this.relativeBounds.width - (this.paddingLeft + this.paddingRight) - child.component.width.calculatedSize();
            if (child.component.hAlign == Alignment.MIN) {
                childLeft = 0;
            } else if (child.component.hAlign == Alignment.CENTER) {
                childLeft /= 2;
            }
            int childTop = this.relativeBounds.height - (this.paddingTop + this.paddingBottom) - child.component.height.calculatedSize();
            if (child.component.vAlign == Alignment.MIN) {
                childTop = 0;
            } else if (child.component.vAlign == Alignment.CENTER) {
                childTop /= 2;
            }
            child.component.setRelativeBounds(child.left + this.paddingLeft + childLeft, child.top + this.paddingTop + childTop);
        }
    }

    @Override
    public void updateScreenBounds(int worldX, int worldY) {
        super.updateScreenBounds(worldX, worldY);
        for (Positional p : this.children) {
            p.component.updateScreenBounds(p.left + this.screenBounds.left, p.top + this.screenBounds.top);
        }
    }

    public void m_94757_(double d, double e) {
        if (this.visible) {
            RelativeContainerEventHandler.super.m_94757_(d, e);
        }
    }

    @Override
    public boolean m_6375_(double d, double e, int i) {
        if (this.visible) {
            return RelativeContainerEventHandler.super.m_6375_(d, e, i);
        }
        return false;
    }

    @Override
    public boolean m_6348_(double d, double e, int i) {
        if (this.visible) {
            return RelativeContainerEventHandler.super.m_6348_(d, e, i);
        }
        return false;
    }

    @Override
    public boolean m_6050_(double d, double e, double f) {
        if (this.visible) {
            return RelativeContainerEventHandler.super.m_6050_(d, e, f);
        }
        return false;
    }

    @Override
    public boolean m_7979_(double d, double e, int i, double f, double g) {
        if (this.visible) {
            return RelativeContainerEventHandler.super.m_7979_(d, e, i, f, g);
        }
        return false;
    }

    @Override
    public boolean m_5953_(double x, double y) {
        if (this.visible) {
            boolean res = false;
            for (Positional child : this.children) {
                res |= child.component.m_5953_(x, y);
            }
            return res || this.relativeBounds.contains(x, y);
        }
        return false;
    }

    public static Container create(LayoutComponent<?, ?> content) {
        return Container.create(Value.fit(), Value.fit(), content);
    }

    public static Container create(Value width, Value height, LayoutComponent<?, ?> content) {
        Container c = new Container(width, height);
        c.addChild(content);
        return c;
    }

    public static class ContainerRenderer
    implements ComponentRenderer {
        Container linkedContainer;

        @Override
        public void renderInBounds(GuiGraphics guiGraphics, int mouseX, int mouseY, float deltaTicks, Rectangle bounds, Rectangle clipRect) {
            if (this.linkedContainer != null) {
                if ((this.linkedContainer.backgroundColor & 0xFF000000) != 0) {
                    guiGraphics.m_280509_(0, 0, bounds.width, bounds.height, this.linkedContainer.backgroundColor);
                }
                if ((this.linkedContainer.outlineColor & 0xFF000000) != 0) {
                    RenderHelper.outline(guiGraphics, 0, 0, bounds.width, bounds.height, this.linkedContainer.outlineColor);
                }
            }
        }
    }

    record Positional(int left, int top, LayoutComponent<?, ?> component) {
        public int getMaxX() {
            return this.left + this.component().getContentWidth();
        }

        public int getMaxY() {
            return this.top + this.component().getContentHeight();
        }
    }
}

