/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.ui.layout.components;

import de.ambertation.wunderlib.ui.layout.components.Button;
import de.ambertation.wunderlib.ui.layout.components.Checkbox;
import de.ambertation.wunderlib.ui.layout.components.ColorPicker;
import de.ambertation.wunderlib.ui.layout.components.ColorSwatch;
import de.ambertation.wunderlib.ui.layout.components.Container;
import de.ambertation.wunderlib.ui.layout.components.HLine;
import de.ambertation.wunderlib.ui.layout.components.Image;
import de.ambertation.wunderlib.ui.layout.components.Input;
import de.ambertation.wunderlib.ui.layout.components.Item;
import de.ambertation.wunderlib.ui.layout.components.LayoutComponent;
import de.ambertation.wunderlib.ui.layout.components.MultiLineText;
import de.ambertation.wunderlib.ui.layout.components.Range;
import de.ambertation.wunderlib.ui.layout.components.Text;
import de.ambertation.wunderlib.ui.layout.components.VLine;
import de.ambertation.wunderlib.ui.layout.components.VerticalScroll;
import de.ambertation.wunderlib.ui.layout.components.input.RelativeContainerEventHandler;
import de.ambertation.wunderlib.ui.layout.components.render.ComponentRenderer;
import de.ambertation.wunderlib.ui.layout.values.Rectangle;
import de.ambertation.wunderlib.ui.layout.values.Size;
import de.ambertation.wunderlib.ui.layout.values.Value;
import de.ambertation.wunderlib.ui.vanilla.VanillaScrollerRenderer;
import java.util.LinkedList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public abstract class AbstractStack<R extends ComponentRenderer, T extends AbstractStack<R, T>>
extends LayoutComponent<R, T>
implements RelativeContainerEventHandler {
    protected final List<LayoutComponent<?, ?>> components = new LinkedList();
    boolean dragging;
    GuiEventListener focused;

    public AbstractStack(Value width, Value height) {
        this(width, height, null);
    }

    public AbstractStack(Value width, Value height, R renderer) {
        super(width, height, renderer);
    }

    @Override
    public int fillWidth(int parentSize, int fillSize) {
        double totalFillWeight = this.components.stream().map(c -> c.width.fillWeight()).reduce(0.0, Double::sum);
        return this.components.stream().map(c -> c.width.fill(fillSize, totalFillWeight)).reduce(0, Integer::sum);
    }

    @Override
    public int fillHeight(int parentSize, int fillSize) {
        double totalFillHeight = this.components.stream().map(c -> c.height.fillWeight()).reduce(0.0, Double::sum);
        return this.components.stream().map(c -> c.height.fill(fillSize, totalFillHeight)).reduce(0, Integer::sum);
    }

    @Override
    public void updateScreenBounds(int worldX, int worldY) {
        super.updateScreenBounds(worldX, worldY);
        for (LayoutComponent<?, ?> c : this.components) {
            c.updateScreenBounds(this.screenBounds.left, this.screenBounds.top);
        }
    }

    @Override
    protected void renderInBounds(GuiGraphics guiGraphics, int mouseX, int mouseY, float deltaTicks, Rectangle renderBounds, Rectangle clipRect) {
        super.renderInBounds(guiGraphics, mouseX, mouseY, deltaTicks, renderBounds, clipRect);
        for (LayoutComponent<?, ?> c : this.components) {
            c.render(guiGraphics, mouseX, mouseY, deltaTicks, renderBounds, clipRect);
        }
    }

    public List<? extends GuiEventListener> m_6702_() {
        return this.components;
    }

    @Override
    public Rectangle getInputBounds() {
        return this.relativeBounds;
    }

    public boolean m_7282_() {
        return this.dragging;
    }

    public void m_7897_(boolean bl) {
        this.dragging = bl;
    }

    @Nullable
    public GuiEventListener m_7222_() {
        return this.focused;
    }

    public void m_7522_(@Nullable GuiEventListener guiEventListener) {
        this.focused = guiEventListener;
    }

    public boolean isEmpty() {
        return this.components.isEmpty();
    }

    protected abstract T addEmpty(Value var1);

    protected T add(LayoutComponent<?, ?> c) {
        this.components.add(c);
        return (T)this;
    }

    protected T addSpacer(int size) {
        return this.addEmpty(Value.fixed(size));
    }

    protected T addSpacer(float percentage) {
        return this.addEmpty(Value.relative(percentage));
    }

    protected T addFiller() {
        return this.addEmpty(Value.fill());
    }

    protected Image addIcon(ResourceLocation location, Size resourceSize) {
        Image i = new Image(Value.fixed(24), Value.fixed(24), location, resourceSize);
        this.add(i);
        return i;
    }

    protected Image addImage(Value width, Value height, ResourceLocation location, Size resourceSize) {
        Image i = new Image(width, height, location, resourceSize);
        this.add(i);
        return i;
    }

    protected Checkbox addCheckbox(Value width, Value height, Component component, boolean selected) {
        Checkbox c = new Checkbox(width, height, component, selected, true);
        this.add(c);
        return c;
    }

    protected Button addButton(Value width, Value height, Component component) {
        Button b = new Button(width, height, component);
        this.add(b);
        return b;
    }

    protected VerticalScroll<VanillaScrollerRenderer> addScrollable(LayoutComponent<?, ?> content) {
        return this.addScrollable(Value.fill(), Value.fill(), content);
    }

    protected VerticalScroll<VanillaScrollerRenderer> addScrollable(Value width, Value height, LayoutComponent<?, ?> content) {
        VerticalScroll<VanillaScrollerRenderer> s = VerticalScroll.create(width, height, content);
        this.add(s);
        return s;
    }

    protected Text addText(Value width, Value height, Component text) {
        Text t = new Text(width, height, text);
        this.add(t);
        return t;
    }

    protected MultiLineText addMultilineText(Value width, Value height, Component text) {
        MultiLineText t = new MultiLineText(width, height, text);
        this.add(t);
        return t;
    }

    protected Range<Integer> addRange(Value width, Value height, Component titleOrNull, int minValue, int maxValue, int initialValue) {
        Range<Integer> r = new Range<Integer>(width, height, titleOrNull, minValue, maxValue, initialValue);
        this.add(r);
        return r;
    }

    protected Range<Float> addRange(Value width, Value height, Component titleOrNull, float minValue, float maxValue, float initialValue) {
        Range<Float> r = new Range<Float>(width, height, titleOrNull, Float.valueOf(minValue), Float.valueOf(maxValue), Float.valueOf(initialValue));
        this.add(r);
        return r;
    }

    protected Range<Double> addRange(Value width, Value height, Component titleOrNull, double minValue, double maxValue, double initialValue) {
        Range<Double> r = new Range<Double>(width, height, titleOrNull, minValue, maxValue, initialValue);
        this.add(r);
        return r;
    }

    protected Input addInput(Value width, Value height, Component titleOrNull, String initialValue) {
        Input i = new Input(width, height, titleOrNull, initialValue);
        this.add(i);
        return i;
    }

    protected ColorSwatch addColorSwatch(Value width, Value height, int color) {
        ColorSwatch c = new ColorSwatch(width, height, color);
        this.add(c);
        return c;
    }

    protected ColorPicker addColorPicker(Value width, Value height, Component titleOrNull, int color) {
        ColorPicker c = new ColorPicker(width, height, titleOrNull, color);
        this.add(c);
        return c;
    }

    protected HLine addHorizontalSeparator(int height) {
        return this.addHLine(Value.relative(0.6180339887498951), Value.fixed(height));
    }

    protected HLine addHorizontalLine(int height) {
        return this.addHLine(Value.fill(), Value.fixed(height));
    }

    protected HLine addHLine(Value width, Value height) {
        HLine l = new HLine(width, height);
        this.add(l);
        return l;
    }

    protected VLine addVerticalSeparator(int width) {
        return this.addVLine(Value.fixed(width), Value.relative(0.6180339887498951));
    }

    protected VLine addVerticalLine(int width) {
        return this.addVLine(Value.fixed(width), Value.fill());
    }

    protected VLine addVLine(Value width, Value height) {
        VLine l = new VLine(width, height);
        this.add(l);
        return l;
    }

    protected Container addContainered(Value width, Value height, LayoutComponent<?, ?> content) {
        Container c = new Container(width, height);
        c.addChild(content);
        this.add(c);
        return c;
    }

    protected Item addItem(ItemStack stack) {
        Item i = new Item(Value.fit(), Value.fit());
        i.setItem(stack);
        this.add(i);
        return i;
    }
}

