/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.ui;

import net.minecraft.ChatFormatting;
import net.minecraft.util.FastColor;

public class ColorHelper {
    public static final int BLACK = ChatFormatting.BLACK.m_126665_() | 0xFF000000;
    public static final int DARK_BLUE = ChatFormatting.DARK_BLUE.m_126665_() | 0xFF000000;
    public static final int DARK_GREEN = ChatFormatting.DARK_GREEN.m_126665_() | 0xFF000000;
    public static final int DARK_AQUA = ChatFormatting.DARK_AQUA.m_126665_() | 0xFF000000;
    public static final int DARK_RED = ChatFormatting.DARK_RED.m_126665_() | 0xFF000000;
    public static final int DARK_PURPLE = ChatFormatting.DARK_PURPLE.m_126665_() | 0xFF000000;
    public static final int GOLD = ChatFormatting.GOLD.m_126665_() | 0xFF000000;
    public static final int GRAY = ChatFormatting.GRAY.m_126665_() | 0xFF000000;
    public static final int DARK_GRAY = ChatFormatting.DARK_GRAY.m_126665_() | 0xFF000000;
    public static final int BLUE = ChatFormatting.BLUE.m_126665_() | 0xFF000000;
    public static final int GREEN = ChatFormatting.GREEN.m_126665_() | 0xFF000000;
    public static final int AQUA = ChatFormatting.AQUA.m_126665_() | 0xFF000000;
    public static final int RED = ChatFormatting.RED.m_126665_() | 0xFF000000;
    public static final int LIGHT_PURPLE = ChatFormatting.LIGHT_PURPLE.m_126665_() | 0xFF000000;
    public static final int YELLOW = ChatFormatting.YELLOW.m_126665_() | 0xFF000000;
    public static final int WHITE;
    public static final int DEFAULT_TEXT;
    public static final int SCREEN_BACKGROUND = -13355964;
    public static final int CONTAINER_BACKGROUND = 0x77000000;

    public static int color(int r, int g, int b) {
        return FastColor.ARGB32.m_13660_((int)255, (int)r, (int)g, (int)b);
    }

    public static int color(String hex) {
        int r = Integer.parseInt(hex.substring(0, 2), 16);
        int g = Integer.parseInt(hex.substring(2, 4), 16);
        int b = Integer.parseInt(hex.substring(4, 6), 16);
        return ColorHelper.color(r, g, b);
    }

    public static int[] toIntARGB(int color) {
        return new int[]{FastColor.ARGB32.m_13655_((int)color), FastColor.ARGB32.m_13665_((int)color), FastColor.ARGB32.m_13667_((int)color), FastColor.ARGB32.m_13669_((int)color)};
    }

    public static float[] toFloatArray(int color) {
        return new float[]{(float)FastColor.ARGB32.m_13655_((int)color) / 255.0f, (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f, (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f, (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f};
    }

    public static String toRGBHex(int color) {
        return "#" + Integer.toHexString(FastColor.ARGB32.m_13665_((int)color)) + Integer.toHexString(FastColor.ARGB32.m_13667_((int)color)) + Integer.toHexString(FastColor.ARGB32.m_13669_((int)color));
    }

    public static boolean validHexColor(String hexColor) {
        if (hexColor == null || hexColor.isBlank()) {
            return false;
        }
        try {
            ColorHelper.parseHex(hexColor);
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    public static int parseHex(String hexColor) {
        int shift;
        int color;
        int len;
        if (((String)hexColor).startsWith("#")) {
            hexColor = ((String)hexColor).substring(1);
        }
        if (((String)hexColor).startsWith("0x")) {
            hexColor = ((String)hexColor).substring(2);
        }
        if ((len = ((String)hexColor).length()) != 6 && len != 8 && len != 3 && len != 4) {
            return -1;
        }
        if (len == 3) {
            hexColor = "" + ((String)hexColor).charAt(0) + ((String)hexColor).charAt(0) + ((String)hexColor).charAt(1) + ((String)hexColor).charAt(1) + ((String)hexColor).charAt(2) + ((String)hexColor).charAt(2);
            len = 6;
        } else if (len == 4) {
            hexColor = "" + ((String)hexColor).charAt(0) + ((String)hexColor).charAt(0) + ((String)hexColor).charAt(1) + ((String)hexColor).charAt(1) + ((String)hexColor).charAt(2) + ((String)hexColor).charAt(2) + ((String)hexColor).charAt(3) + ((String)hexColor).charAt(3);
            len = 8;
        }
        if (len == 6) {
            color = -16777216;
            shift = 16;
        } else {
            color = 0;
            shift = 24;
        }
        try {
            String[] splited;
            for (String digit : splited = ((String)hexColor).split("(?<=\\G.{2})")) {
                color |= Integer.valueOf(digit, 16) << shift;
                shift -= 8;
            }
        }
        catch (NumberFormatException ex) {
            return -1;
        }
        return color;
    }

    public static int blendColors(float t, int c1, int c2) {
        int r = (int)(t * (float)FastColor.ARGB32.m_13665_((int)c2) + (1.0f - t) * (float)FastColor.ARGB32.m_13665_((int)c1));
        int g = (int)(t * (float)FastColor.ARGB32.m_13667_((int)c2) + (1.0f - t) * (float)FastColor.ARGB32.m_13667_((int)c1));
        int b = (int)(t * (float)FastColor.ARGB32.m_13669_((int)c2) + (1.0f - t) * (float)FastColor.ARGB32.m_13669_((int)c1));
        int a = (int)(t * (float)FastColor.ARGB32.m_13655_((int)c2) + (1.0f - t) * (float)FastColor.ARGB32.m_13655_((int)c1));
        return FastColor.ARGB32.m_13660_((int)a, (int)r, (int)g, (int)b);
    }

    static {
        DEFAULT_TEXT = WHITE = ChatFormatting.WHITE.m_126665_() | 0xFF000000;
    }
}

