/*
 * Decompiled with CFR 0.152.
 */
package de.ambertation.wunderlib.math.sdf;

import de.ambertation.wunderlib.math.Bounds;
import de.ambertation.wunderlib.math.Float3;
import de.ambertation.wunderlib.math.Matrix4;
import de.ambertation.wunderlib.math.Quaternion;
import de.ambertation.wunderlib.math.Transform;
import de.ambertation.wunderlib.math.sdf.SDF;
import de.ambertation.wunderlib.math.sdf.interfaces.Rotatable;
import de.ambertation.wunderlib.math.sdf.interfaces.Transformable;

public abstract class SDFOperation
extends SDF
implements Transformable,
Rotatable {
    protected Transform transform;

    protected SDFOperation(Transform t, SDF sdf) {
        this(t, sdf, 0);
    }

    protected SDFOperation(Transform t, SDF sdf, int additionalInputSlots) {
        super(1 + additionalInputSlots);
        this.setSlotSilent(0, sdf);
        this.transform = t;
    }

    public String toString() {
        return "(" + this.getFirst() + ") [" + this.graphIndex + "]";
    }

    public SDF getFirst() {
        return this.getSlot(0);
    }

    public void setFirst(SDF a) {
        this.setSlot(0, a);
    }

    @Override
    public Transform getLocalTransform() {
        return this.transform;
    }

    @Override
    public Float3[] getCornersInWorldSpace(boolean blockAligned, Transform transform) {
        Float3[] corners = new Float3[Bounds.Interpolate.CORNERS.length];
        for (Bounds.Interpolate corner : Bounds.Interpolate.CORNERS) {
            corners[corner.idx.byteValue()] = this.getCornerInWorldSpace(corner, blockAligned, transform);
        }
        return corners;
    }

    @Override
    public Float3[] getCornersAndCenterInWorldSpace(boolean blockAligned, Transform transform) {
        Float3[] corners = new Float3[Bounds.Interpolate.CORNERS_AND_CENTER.length];
        for (Bounds.Interpolate corner : Bounds.Interpolate.CORNERS_AND_CENTER) {
            corners[corner.idx.byteValue()] = this.getCornerInWorldSpace(corner, blockAligned, transform);
        }
        return corners;
    }

    @Override
    public Float3 getCornerInWorldSpace(Bounds.Interpolate corner, boolean blockAligned, Transform transform) {
        Bounds b = this.getLocalBoundingBox(Matrix4.IDENTITY);
        return this.getParentTransformMatrix().mul(transform.asMatrix()).transform(blockAligned ? b.getBlockAligned(corner) : b.get(corner));
    }

    @Override
    public void setLocalTransform(Transform t) {
        this.transform = t;
    }

    @Override
    public boolean isOperation() {
        return true;
    }

    @Override
    public Transform defaultTransform() {
        return Transform.IDENTITY;
    }

    @Override
    public void rotate(double angle) {
        this.transform = this.transform.rotateBy(Quaternion.ofAxisAngle(Float3.Y_AXIS, angle));
    }
}

