/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.main;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import java.util.function.Function;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.ArgumentTypeRegistry;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentTypeInfo;
import net.minecraft.core.Registry;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.GameRules;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.mixin.GameRulesAccessor;
import net.puffish.skillsmod.network.InPacket;
import net.puffish.skillsmod.network.OutPacket;
import net.puffish.skillsmod.server.event.ServerEventListener;
import net.puffish.skillsmod.server.event.ServerEventReceiver;
import net.puffish.skillsmod.server.network.ServerPacketHandler;
import net.puffish.skillsmod.server.network.ServerPacketSender;
import net.puffish.skillsmod.server.setup.ServerRegistrar;

public class FabricMain
implements ModInitializer {
    public void onInitialize() {
        SkillsMod.setup(FabricLoader.getInstance().getConfigDir(), new ServerRegistrarImpl(), new ServerEventReceiverImpl(), new ServerPacketSenderImpl());
    }

    private static class ServerRegistrarImpl
    implements ServerRegistrar {
        private ServerRegistrarImpl() {
        }

        @Override
        public <V, T extends V> void register(Registry<V> registry, ResourceLocation id, T entry) {
            Registry.m_122965_(registry, (ResourceLocation)id, entry);
        }

        @Override
        public <T extends GameRules.Value<T>> void registerGameRule(GameRules.Key<T> key, GameRules.Type<T> type) {
            GameRulesAccessor.getRuleTypes().put(key, type);
        }

        @Override
        public <A extends ArgumentType<?>, T extends ArgumentTypeInfo.Template<A>> void registerArgumentType(ResourceLocation id, Class<A> clazz, ArgumentTypeInfo<A, T> serializer) {
            ArgumentTypeRegistry.registerArgumentType((ResourceLocation)id, clazz, serializer);
        }

        @Override
        public <T extends InPacket> void registerInPacket(ResourceLocation id, Function<FriendlyByteBuf, T> reader, ServerPacketHandler<T> handler) {
            ServerPlayNetworking.registerGlobalReceiver((ResourceLocation)id, (server, player, handler2, buf, responseSender) -> {
                InPacket packet = (InPacket)reader.apply(buf);
                server.execute(() -> handler.handle(player, packet));
            });
        }

        @Override
        public void registerOutPacket(ResourceLocation id) {
        }
    }

    private static class ServerEventReceiverImpl
    implements ServerEventReceiver {
        private ServerEventReceiverImpl() {
        }

        @Override
        public void registerListener(ServerEventListener eventListener) {
            ServerLifecycleEvents.SERVER_STARTING.register(eventListener::onServerStarting);
            ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((server, resourceManager, success) -> eventListener.onServerReload(server));
            ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> eventListener.onPlayerJoin(handler.f_9743_));
            CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> eventListener.onCommandsRegister((CommandDispatcher<CommandSourceStack>)dispatcher));
        }
    }

    private static class ServerPacketSenderImpl
    implements ServerPacketSender {
        private ServerPacketSenderImpl() {
        }

        @Override
        public void send(ServerPlayer player, OutPacket packet) {
            ServerPlayNetworking.send((ServerPlayer)player, (ResourceLocation)packet.getIdentifier(), (FriendlyByteBuf)packet.getBuf());
        }
    }
}

