/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.main;

import java.util.function.Function;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.client.KeyMapping;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.puffish.skillsmod.client.SkillsClientMod;
import net.puffish.skillsmod.client.event.ClientEventListener;
import net.puffish.skillsmod.client.event.ClientEventReceiver;
import net.puffish.skillsmod.client.keybinding.KeyBindingHandler;
import net.puffish.skillsmod.client.keybinding.KeyBindingReceiver;
import net.puffish.skillsmod.client.network.ClientPacketHandler;
import net.puffish.skillsmod.client.network.ClientPacketSender;
import net.puffish.skillsmod.client.setup.ClientRegistrar;
import net.puffish.skillsmod.network.InPacket;
import net.puffish.skillsmod.network.OutPacket;

public class FabricClientMain
implements ClientModInitializer {
    public void onInitializeClient() {
        SkillsClientMod.setup(new ClientRegistrarImpl(), new ClientEventReceiverImpl(), new KeyBindingReceiverImpl(), new ClientPacketSenderImpl());
    }

    private static class ClientRegistrarImpl
    implements ClientRegistrar {
        private ClientRegistrarImpl() {
        }

        @Override
        public <T extends InPacket> void registerInPacket(ResourceLocation id, Function<FriendlyByteBuf, T> reader, ClientPacketHandler<T> handler) {
            ClientPlayNetworking.registerGlobalReceiver((ResourceLocation)id, (client, handler2, buf, responseSender) -> {
                InPacket packet = (InPacket)reader.apply(buf);
                client.execute(() -> handler.handle(packet));
            });
        }

        @Override
        public void registerOutPacket(ResourceLocation id) {
        }
    }

    private static class ClientEventReceiverImpl
    implements ClientEventReceiver {
        private ClientEventReceiverImpl() {
        }

        @Override
        public void registerListener(ClientEventListener eventListener) {
            ClientPlayConnectionEvents.JOIN.register((handler, sender, client) -> eventListener.onPlayerJoin());
        }
    }

    private static class KeyBindingReceiverImpl
    implements KeyBindingReceiver {
        private KeyBindingReceiverImpl() {
        }

        @Override
        public void registerKeyBinding(KeyMapping keyBinding, KeyBindingHandler handler) {
            ClientTickEvents.END_CLIENT_TICK.register(client -> {
                if (keyBinding.m_90859_()) {
                    handler.handle();
                }
            });
            KeyBindingHelper.registerKeyBinding((KeyMapping)keyBinding);
        }
    }

    private static class ClientPacketSenderImpl
    implements ClientPacketSender {
        private ClientPacketSenderImpl() {
        }

        @Override
        public void send(OutPacket packet) {
            ClientPlayNetworking.send((ResourceLocation)packet.getIdentifier(), (FriendlyByteBuf)packet.getBuf());
        }
    }
}

