/*
 * Decompiled with CFR 0.152.
 */
package net.puffish.skillsmod.impl.calculation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.calculation.Variables;
import net.puffish.skillsmod.api.calculation.operation.Operation;
import net.puffish.skillsmod.api.calculation.prototype.BuiltinPrototypes;
import net.puffish.skillsmod.api.calculation.prototype.PrototypeView;
import net.puffish.skillsmod.api.config.ConfigContext;
import net.puffish.skillsmod.api.json.BuiltinJson;
import net.puffish.skillsmod.api.json.JsonElement;
import net.puffish.skillsmod.api.json.JsonObject;
import net.puffish.skillsmod.api.json.JsonPath;
import net.puffish.skillsmod.api.util.Problem;
import net.puffish.skillsmod.api.util.Result;
import net.puffish.skillsmod.impl.calculation.operation.OperationConfigContextImpl;

public class VariablesImpl<T, R>
implements Variables<T, R> {
    private final Map<String, Function<T, R>> operations;

    private VariablesImpl(Map<String, Function<T, R>> operations) {
        this.operations = operations;
    }

    @Override
    public Stream<String> streamNames() {
        return this.operations.keySet().stream();
    }

    @Override
    public Map<String, R> evaluate(T t) {
        return this.operations.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((Function)entry.getValue()).apply(t)));
    }

    public static <T, R> Variables<T, R> create(Map<String, Function<T, R>> operations) {
        return new VariablesImpl<T, R>(Map.copyOf(operations));
    }

    public static <T, R> Variables<T, R> combine(Collection<Variables<T, R>> variables) {
        return new CombineVariables<T, R>(List.copyOf(variables));
    }

    @SafeVarargs
    public static <T, R> Variables<T, R> combine(Variables<T, R> ... variables) {
        return new CombineVariables<T, R>(Arrays.asList(variables));
    }

    public static <T> Result<VariablesImpl<T, Double>, Problem> parse(JsonElement rootElement, PrototypeView<T> prototypeView, ConfigContext context) {
        return rootElement.getAsObject().andThen(rootObject -> VariablesImpl.parse(rootObject, prototypeView, context));
    }

    public static <T> Result<VariablesImpl<T, Double>, Problem> parse(JsonObject rootObject, PrototypeView<T> prototypeView, ConfigContext context) {
        return rootObject.getAsMap((key, value) -> VariablesImpl.parseVariable(value, prototypeView, context)).mapFailure(problems -> Problem.combine(problems.values())).mapSuccess(VariablesImpl::new);
    }

    public static <T> Result<Function<T, Double>, Problem> parseVariable(JsonElement rootElement, PrototypeView<T> prototypeView, ConfigContext context) {
        return rootElement.getAsObject().andThen(rootObject -> VariablesImpl.parseVariable(rootObject, prototypeView, context));
    }

    public static <T> Result<Function<T, Double>, Problem> parseVariable(JsonObject rootObject, PrototypeView<T> prototypeView, ConfigContext context) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional<PrototypeView<T>> optPrototypeView = VariablesImpl.parseOperation(rootObject, prototypeView, context, "legacy_").getSuccess().or(() -> rootObject.getArray("operations").ifFailure(problems::add).getSuccess().flatMap(array -> {
            Optional<PrototypeView<Object>> view = Optional.of(prototypeView);
            for (JsonElement element : array.stream()::iterator) {
                view = view.flatMap(v -> VariablesImpl.parseOperation(element, v, context).ifFailure(problems::add).getSuccess());
            }
            return view;
        }));
        Optional<Double> optFallback = rootObject.get("fallback").getSuccess().flatMap(fallbackElement -> fallbackElement.getAsDouble().ifFailure(problems::add).getSuccess());
        Boolean required = rootObject.getBoolean("required").getSuccessOrElse(e -> true);
        if (problems.isEmpty()) {
            return VariablesImpl.buildVariable(optPrototypeView.orElseThrow(), optFallback, rootObject.getPath().getObject("operations")).orElse(problem -> {
                if (required.booleanValue() || optFallback.isEmpty()) {
                    return Result.failure(problem);
                }
                context.emitWarning(problem.toString());
                Double fallback = (Double)optFallback.orElseThrow();
                return Result.success(t -> fallback);
            });
        }
        return Result.failure(Problem.combine(problems));
    }

    public static <T> Result<PrototypeView<T>, Problem> parseOperation(JsonElement rootElement, PrototypeView<T> prototypeView, ConfigContext context) {
        return rootElement.getAsObject().andThen(rootObject -> VariablesImpl.parseOperation(rootObject, prototypeView, context, ""));
    }

    public static <T> Result<PrototypeView<T>, Problem> parseOperation(JsonObject rootObject, PrototypeView<T> prototypeView, ConfigContext context, String prefix) {
        ArrayList<Problem> problems = new ArrayList<Problem>();
        Optional optType = rootObject.get("type").andThen(BuiltinJson::parseIdentifier).ifFailure(problems::add).getSuccess();
        Result<JsonElement, Problem> maybeDataElement = rootObject.get("data");
        if (problems.isEmpty()) {
            return VariablesImpl.buildOperation(prototypeView, ((ResourceLocation)optType.orElseThrow()).m_246208_(prefix), rootObject.getPath().getObject("type"), maybeDataElement, context);
        }
        return Result.failure(Problem.combine(problems));
    }

    private static <T> Result<PrototypeView<T>, Problem> buildOperation(PrototypeView<T> prototypeView, ResourceLocation type, JsonPath typePath, Result<JsonElement, Problem> maybeDataElement, ConfigContext context) {
        Optional<Result<PrototypeView<T>, Problem>> factory;
        if (type.m_135827_().equals("minecraft")) {
            type = new ResourceLocation(prototypeView.getId().m_135827_(), type.m_135815_());
        }
        if ((factory = prototypeView.getView(type, new OperationConfigContextImpl(context, maybeDataElement))).isEmpty()) {
            return Result.failure(typePath.createProblem("Expected a valid operation type"));
        }
        return factory.orElseThrow();
    }

    private static <T> Result<Function<T, Double>, Problem> buildVariable(PrototypeView<T> prototypeView, Optional<Double> fallback, JsonPath operationsPath) {
        Optional optOperation = prototypeView.getOperation(BuiltinPrototypes.NUMBER).or(() -> prototypeView.getOperation(BuiltinPrototypes.BOOLEAN).map(o -> t -> ((Optional)o.apply(t)).map(b -> b != false ? 1.0 : 0.0)));
        if (optOperation.isPresent()) {
            return Result.success(t -> ((Optional)((Operation)optOperation.orElseThrow()).apply(t)).orElseGet(() -> {
                if (fallback.isEmpty()) {
                    SkillsMod.getInstance().getLogger().warn(operationsPath.createProblem("Fallback is not specified but operations returned no value").toString());
                }
                return fallback.orElse(Double.NaN);
            }));
        }
        return Result.failure(operationsPath.createProblem("Expected operations to provide a number"));
    }

    private record CombineVariables<T, R>(List<Variables<T, R>> variablesList) implements Variables<T, R>
    {
        @Override
        public Stream<String> streamNames() {
            return this.variablesList.stream().flatMap(Variables::streamNames);
        }

        @Override
        public Map<String, R> evaluate(T t) {
            return this.variablesList.stream().flatMap(variables -> variables.evaluate(t).entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        }
    }
}

