/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Team;
import net.puffish.attributesmod.AttributesMod;
import net.puffish.skillsmod.api.Category;
import net.puffish.skillsmod.api.Skill;
import net.puffish.skillsmod.api.SkillsAPI;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;
import net.sweenus.simplyskills.SimplySkills;
import net.sweenus.simplyskills.abilities.NecromancerAbilities;
import net.sweenus.simplyskills.network.ModPacketHandler;

public class HelperMethods {
    public static boolean checkFriendlyFire(LivingEntity livingEntity, Player player) {
        if (livingEntity == null || player == null) {
            return false;
        }
        if (!HelperMethods.checkEntityBlacklist(livingEntity, player)) {
            return false;
        }
        Team playerTeam = player.m_5647_();
        Team entityTeam = livingEntity.m_5647_();
        if (playerTeam != null && entityTeam != null && livingEntity.m_7307_((Entity)player)) {
            return false;
        }
        if (livingEntity instanceof Player) {
            Player playerEntity = (Player)livingEntity;
            if (playerEntity == player) {
                return false;
            }
            return playerEntity.m_7099_(player);
        }
        if (livingEntity instanceof OwnableEntity) {
            OwnableEntity tameable = (OwnableEntity)livingEntity;
            if (tameable.m_269323_() != null) {
                LivingEntity livingEntity2;
                if (tameable.m_269323_() != player && (livingEntity2 = tameable.m_269323_()) instanceof Player) {
                    Player ownerPlayer = (Player)livingEntity2;
                    return player.m_7099_(ownerPlayer);
                }
                return tameable.m_269323_() != player;
            }
            return true;
        }
        return true;
    }

    public static boolean isBehindTarget(LivingEntity attacker, LivingEntity target) {
        return target.m_213816_() < attacker.m_213816_() + 32.0f && target.m_213816_() > attacker.m_213816_() - 32.0f;
    }

    public static boolean isUnlocked(String skillTreeId, String skillId, LivingEntity livingEntity) {
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            if (skillId == null) {
                return SkillsAPI.getCategory((ResourceLocation)new ResourceLocation(skillTreeId)).map(category -> category.isUnlocked(serverPlayer)).orElse(false);
            }
            return SkillsAPI.getCategory((ResourceLocation)new ResourceLocation(skillTreeId)).flatMap(category -> category.getSkill(skillId)).map(skill -> skill.getState(serverPlayer) == Skill.State.UNLOCKED).orElse(false);
        }
        return false;
    }

    public static boolean hasUnlockedSkill(Category category, String skillId, LivingEntity livingEntity) {
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            return category.getSkill(skillId).map(skill -> skill.getState(serverPlayer) == Skill.State.UNLOCKED).orElse(false);
        }
        return false;
    }

    public static int countUnlockedSkills(String skillTreeId, ServerPlayer serverPlayer) {
        return SkillsAPI.getCategory((ResourceLocation)new ResourceLocation("simplyskills", skillTreeId)).map(category -> (int)category.streamUnlockedSkills(serverPlayer).count()).orElse(0);
    }

    public static boolean checkEntityBlacklist(LivingEntity livingEntity, Player player) {
        if (livingEntity == null || player == null) {
            return false;
        }
        return !(livingEntity instanceof ArmorStand) && !(livingEntity instanceof Villager);
    }

    public static double getAttackDamage(ItemStack stack) {
        return stack.m_41720_().m_7167_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22281_).stream().mapToDouble(AttributeModifier::m_22218_).sum();
    }

    public static AABB createBox(Entity entity, int radius) {
        AABB box = new AABB(entity.m_20185_() + (double)radius, entity.m_20186_() + (double)((float)radius / 3.0f), entity.m_20189_() + (double)radius, entity.m_20185_() - (double)radius, entity.m_20186_() - (double)((float)radius / 3.0f), entity.m_20189_() - (double)radius);
        return box;
    }

    public static AABB createBoxHeight(Entity entity, int radius) {
        AABB box = new AABB(entity.m_20185_() + (double)radius, entity.m_20186_() + (double)radius, entity.m_20189_() + (double)radius, entity.m_20185_() - (double)radius, entity.m_20186_() - (double)radius, entity.m_20189_() - (double)radius);
        return box;
    }

    public static AABB createBoxAtBlock(BlockPos blockpos, int radius) {
        AABB box = new AABB((double)(blockpos.m_123341_() + radius), (double)(blockpos.m_123342_() + radius), (double)(blockpos.m_123343_() + radius), (double)(blockpos.m_123341_() - radius), (double)(blockpos.m_123342_() - radius), (double)(blockpos.m_123343_() - radius));
        return box;
    }

    public static AABB createBoxBetween(BlockPos blockpos, BlockPos blockpos2, int radius) {
        AABB box = new AABB((double)(blockpos.m_123341_() + radius), (double)(blockpos.m_123342_() + radius), (double)(blockpos.m_123343_() + radius), (double)(blockpos2.m_123341_() - radius), (double)(blockpos2.m_123342_() - radius), (double)(blockpos2.m_123343_() - radius));
        return box;
    }

    public static Entity getTargetedEntity(Entity user, int range) {
        AABB searchBox;
        Vec3 userView;
        Vec3 rayCastEnd;
        Vec3 rayCastOrigin = user.m_146892_();
        EntityHitResult hitResult = ProjectileUtil.m_37287_((Entity)user, (Vec3)rayCastOrigin, (Vec3)(rayCastEnd = rayCastOrigin.m_82549_(userView = user.m_20252_(1.0f).m_82541_().m_82490_((double)range))), (AABB)(searchBox = user.m_20191_().m_82377_((double)range, (double)range, (double)range)), target -> !target.m_5833_() && target.m_6087_() && target instanceof LivingEntity, (double)(range * range));
        if (hitResult != null) {
            return hitResult.m_82443_();
        }
        return null;
    }

    public static Vec3 getPositionLookingAt(Player player, int range) {
        HitResult result = player.m_19907_((double)range, 0.0f, false);
        if (result.m_6662_() != HitResult.Type.BLOCK) {
            return null;
        }
        BlockHitResult blockResult = (BlockHitResult)result;
        return blockResult.m_82450_();
    }

    public static BlockPos getBlockLookingAt(Player player, int range) {
        HitResult result = player.m_19907_((double)range, 0.0f, false);
        if (result.m_6662_() == HitResult.Type.BLOCK) {
            BlockHitResult blockResult = (BlockHitResult)result;
            return blockResult.m_82425_();
        }
        return HelperMethods.getFirstAirBlockLookingAt(player, range);
    }

    public static BlockPos getFirstAirBlockLookingAt(Player player, int range) {
        Vec3 start = player.m_146892_();
        Vec3 look = player.m_20252_(1.0f);
        for (int i = range - 4; i < range; ++i) {
            Vec3 step = start.m_82520_(look.f_82479_ * (double)i, look.f_82480_ * (double)i, look.f_82481_ * (double)i);
            BlockPos pos = new BlockPos((int)step.f_82479_, (int)step.f_82480_, (int)step.f_82481_);
            if (!player.m_9236_().m_46859_(pos)) continue;
            return pos;
        }
        return null;
    }

    public static void incrementStatusEffect(LivingEntity livingEntity, MobEffect statusEffect, int duration, int amplifier, int amplifierMax) {
        if (livingEntity.m_21023_(statusEffect)) {
            int currentAmplifier = livingEntity.m_21124_(statusEffect).m_19564_();
            if (currentAmplifier >= amplifierMax) {
                livingEntity.m_7292_(new MobEffectInstance(statusEffect, duration, currentAmplifier, false, false, true));
                return;
            }
            livingEntity.m_7292_(new MobEffectInstance(statusEffect, duration, currentAmplifier + amplifier, false, false, true));
        }
        livingEntity.m_7292_(new MobEffectInstance(statusEffect, duration, amplifier, false, false, true));
    }

    public static void capStatusEffect(LivingEntity livingEntity) {
        int spellforgedCap = 5;
        int mightCap = 30;
        int marksmanshipCap = 30;
        List list = livingEntity.m_21220_().stream().toList();
        if (!list.isEmpty()) {
            for (MobEffectInstance statusEffectInstance : list) {
                MobEffect statusEffect = statusEffectInstance.m_19544_();
                switch (statusEffect.m_19482_().getString()) {
                    case "Spellforged": {
                        if (statusEffectInstance.m_19564_() > spellforgedCap) {
                            HelperMethods.decrementStatusEffects(livingEntity, statusEffect, statusEffectInstance.m_19564_() - spellforgedCap);
                        }
                    }
                    case "Might": {
                        if (statusEffectInstance.m_19564_() > mightCap) {
                            HelperMethods.decrementStatusEffects(livingEntity, statusEffect, statusEffectInstance.m_19564_() - mightCap);
                        }
                    }
                    case "Marksmanship": {
                        if (statusEffectInstance.m_19564_() <= marksmanshipCap) break;
                        HelperMethods.decrementStatusEffects(livingEntity, statusEffect, statusEffectInstance.m_19564_() - marksmanshipCap);
                    }
                }
            }
        }
    }

    public static boolean stringContainsAny(String string, String[] stringList) {
        for (String s : stringList) {
            if (!string.contains(s)) continue;
            return true;
        }
        return false;
    }

    public static void decrementStatusEffect(LivingEntity livingEntity, MobEffect statusEffect) {
        if (livingEntity.m_21023_(statusEffect)) {
            int currentAmplifier = livingEntity.m_21124_(statusEffect).m_19564_();
            int currentDuration = livingEntity.m_21124_(statusEffect).m_19557_();
            if (currentAmplifier < 1) {
                livingEntity.m_21195_(statusEffect);
                return;
            }
            livingEntity.m_21195_(statusEffect);
            livingEntity.m_7292_(new MobEffectInstance(statusEffect, currentDuration, currentAmplifier - 1, false, false, true));
        }
    }

    public static void decrementStatusEffects(LivingEntity livingEntity, MobEffect statusEffect, int stacksRemoved) {
        if (livingEntity.m_21023_(statusEffect)) {
            int currentAmplifier = livingEntity.m_21124_(statusEffect).m_19564_();
            int currentDuration = livingEntity.m_21124_(statusEffect).m_19557_();
            if (currentAmplifier < 1) {
                livingEntity.m_21195_(statusEffect);
                return;
            }
            livingEntity.m_21195_(statusEffect);
            livingEntity.m_7292_(new MobEffectInstance(statusEffect, currentDuration, currentAmplifier - stacksRemoved, false, false, true));
        }
    }

    public static boolean buffSteal(LivingEntity user, LivingEntity target, boolean strip, boolean singular, boolean debuff, boolean cleanse) {
        List list = target.m_21220_().stream().toList();
        if (list.isEmpty()) {
            return false;
        }
        for (MobEffectInstance statusEffectInstance : list) {
            MobEffect statusEffect = statusEffectInstance.m_19544_();
            int duration = statusEffectInstance.m_19557_();
            int amplifier = statusEffectInstance.m_19564_();
            if (statusEffect.m_19486_() && !debuff) {
                if (user != null && !cleanse) {
                    HelperMethods.incrementStatusEffect(user, statusEffect, duration, 1, amplifier);
                }
                if (strip) {
                    HelperMethods.decrementStatusEffect(target, statusEffectInstance.m_19544_());
                }
                if (!singular) continue;
                return true;
            }
            if (statusEffect.m_19486_() || !debuff) continue;
            if (user != null && !cleanse) {
                HelperMethods.incrementStatusEffect(user, statusEffect, duration, 1, amplifier);
            }
            if (strip) {
                HelperMethods.decrementStatusEffect(target, statusEffectInstance.m_19544_());
            }
            if (!singular) continue;
            return true;
        }
        return true;
    }

    public static void spawnParticle(Level world, ParticleOptions particle, double xpos, double ypos, double zpos, double xvelocity, double yvelocity, double zvelocity) {
        if (world.f_46443_) {
            world.m_7106_(particle, xpos, ypos, zpos, xvelocity, yvelocity, zvelocity);
        } else if (world instanceof ServerLevel) {
            ServerLevel serverWorld = (ServerLevel)world;
            serverWorld.m_8767_(particle, xpos, ypos, zpos, 1, xvelocity, yvelocity, zvelocity, 0.0);
        }
    }

    public static void spawnParticlesPlane(Level world, ParticleOptions particle, BlockPos blockpos, int radius, double xvelocity, double yvelocity, double zvelocity) {
        double xpos = blockpos.m_123341_() - (radius + 1);
        double ypos = blockpos.m_123342_();
        double zpos = blockpos.m_123343_() - (radius + 1);
        for (int i = radius * 2; i > 0; --i) {
            for (int j = radius * 2; j > 0; --j) {
                float choose = (float)(Math.random() * 1.0);
                HelperMethods.spawnParticle(world, particle, xpos + (double)i + (double)choose, ypos, zpos + (double)j + (double)choose, xvelocity, yvelocity, zvelocity);
            }
        }
    }

    public static void spawnParticlesInFrontOfPlayer(ServerLevel world, LivingEntity livingEntity, ParticleOptions particle, int distance, double speed, int count) {
        Vec3 lookVec = livingEntity.m_20252_(1.0f).m_82541_();
        Vec3 startPosition = livingEntity.m_146892_().m_82549_(lookVec.m_82490_((double)distance));
        for (int i = 0; i < count; ++i) {
            double offsetX = (world.f_46441_.m_188500_() - 0.5) * 2.0;
            double offsetY = (world.f_46441_.m_188500_() - 0.5) * 2.0;
            double offsetZ = (world.f_46441_.m_188500_() - 0.5) * 2.0;
            double xPos = startPosition.f_82479_ + offsetX;
            double yPos = startPosition.f_82480_ + offsetY;
            double zPos = startPosition.f_82481_ + offsetZ;
            double xVelocity = lookVec.f_82479_ * speed;
            double yVelocity = lookVec.f_82480_ * speed;
            double zVelocity = lookVec.f_82481_ * speed;
            world.m_8767_(particle, xPos, yPos, zPos, 0, xVelocity, yVelocity, zVelocity, 1.0);
        }
    }

    public static boolean respecialise(ServerPlayer user) {
        ResourceLocation prom;
        List<String> specialisations = SimplySkills.getSpecialisationsAsArray();
        for (String specialisation : specialisations) {
            ((Category)SkillsAPI.getCategory((ResourceLocation)new ResourceLocation(specialisation)).get()).erase(user);
        }
        ((Category)SkillsAPI.getCategory((ResourceLocation)new ResourceLocation("simplyskills:tree")).get()).resetSkills(user);
        ResourceLocation ascendancyTree = new ResourceLocation("simplyskills:ascendancy");
        if (SkillsAPI.getCategory((ResourceLocation)ascendancyTree).isPresent()) {
            ((Category)SkillsAPI.getCategory((ResourceLocation)ascendancyTree).get()).resetSkills(user);
        }
        if (FabricLoader.getInstance().isModLoaded("prominent") && SkillsAPI.getCategory((ResourceLocation)(prom = new ResourceLocation("puffish_skills:prom"))).isPresent()) {
            ((Category)SkillsAPI.getCategory((ResourceLocation)prom).get()).resetSkills(user);
        }
        return true;
    }

    public static boolean levelAll(ServerPlayer user) {
        List<String> specialisations = SimplySkills.getSpecialisationsAsArray();
        if (!FabricLoader.getInstance().isModLoaded("prominent")) {
            for (String specialisation : specialisations) {
                ((Category)SkillsAPI.getCategory((ResourceLocation)new ResourceLocation(specialisation)).get()).unlock(user);
                ((Category)SkillsAPI.getCategory((ResourceLocation)new ResourceLocation(specialisation)).get()).addExtraPoints(user, 99);
            }
        }
        ((Category)SkillsAPI.getCategory((ResourceLocation)new ResourceLocation("simplyskills:tree")).get()).addExtraPoints(user, 99);
        if (!FabricLoader.getInstance().isModLoaded("prominent")) {
            ((Category)SkillsAPI.getCategory((ResourceLocation)new ResourceLocation("simplyskills:ascendancy")).get()).unlock(user);
            ((Category)SkillsAPI.getCategory((ResourceLocation)new ResourceLocation("simplyskills:ascendancy")).get()).addExtraPoints(user, 99);
        }
        if (FabricLoader.getInstance().isModLoaded("prominent")) {
            ((Category)SkillsAPI.getCategory((ResourceLocation)new ResourceLocation("puffish_skills:prom")).get()).addExtraPoints(user, 99);
        }
        return true;
    }

    public static void treeResetOnDeath(ServerPlayer user) {
        if (SimplySkills.generalConfig.treeResetOnDeath) {
            HelperMethods.resetAllTrees(user);
        }
    }

    public static void resetAllTrees(ServerPlayer user) {
        List<String> specialisations = SimplySkills.getSpecialisationsAsArray();
        for (String specialisation : specialisations) {
            ((Category)SkillsAPI.getCategory((ResourceLocation)new ResourceLocation(specialisation)).get()).erase(user);
            ((Category)SkillsAPI.getCategory((ResourceLocation)new ResourceLocation("simplyskills:ascendancy")).get()).erase(user);
            if (FabricLoader.getInstance().isModLoaded("prominent")) {
                ((Category)SkillsAPI.getCategory((ResourceLocation)new ResourceLocation("puffish_skills:prom")).get()).erase(user);
                continue;
            }
            ((Category)SkillsAPI.getCategory((ResourceLocation)new ResourceLocation("simplyskills:tree")).get()).erase(user);
        }
    }

    public static int getSlotWithStack(Player player, ItemStack stack) {
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            if (!ItemStack.m_41728_((ItemStack)player.m_150109_().m_8020_(i), (ItemStack)stack)) continue;
            return i;
        }
        return -1;
    }

    public static boolean storeBuildTemplate(ServerPlayer user, ItemStack stack) {
        int categoryCount = 0;
        int skillCount = 0;
        String userUUID = user.m_20149_();
        stack.m_41784_().m_128359_("player_name", user.m_7755_().getString());
        if (!stack.m_41784_().m_128461_("player_uuid").isEmpty()) {
            return false;
        }
        CompoundTag nbt = stack.m_41784_();
        for (Category category : SkillsAPI.streamUnlockedCategories((ServerPlayer)user)::iterator) {
            String categoryKey = "category" + categoryCount;
            nbt.m_128359_(categoryKey, category.getId().toString());
            for (Skill skill : category.streamUnlockedSkills(user)::iterator) {
                String skillKey = "skill" + skillCount;
                nbt.m_128359_(skillKey, skill.getId());
                ++skillCount;
            }
            ++categoryCount;
        }
        HelperMethods.resetAllTrees(user);
        nbt.m_128359_("player_uuid", userUUID);
        int slot = HelperMethods.getSlotWithStack((Player)user, stack);
        if (slot != -1) {
            ModPacketHandler.syncItemStackNbt(user, slot, stack);
        }
        return true;
    }

    public static boolean applyBuildTemplate(ServerPlayer user, ItemStack stack) {
        int slot;
        CompoundTag nbt = stack.m_41784_();
        String uuid = user.m_20149_();
        if (!nbt.m_128461_("player_uuid").equals(uuid) && !SimplySkills.generalConfig.enableBuildSharing) {
            return false;
        }
        HelperMethods.resetAllTrees(user);
        int size = stack.m_41783_() != null ? stack.m_41783_().m_128440_() : 0;
        for (int i = 0; i < size; ++i) {
            String categoryKey = "category" + i;
            String category = nbt.m_128461_(categoryKey);
            if (category.isEmpty()) continue;
            SkillsAPI.getCategory((ResourceLocation)new ResourceLocation(category)).ifPresent(categoryObj -> {
                categoryObj.unlock(user);
                for (int s = 0; s < size; ++s) {
                    String skillKey = "skill" + s;
                    String skill = nbt.m_128461_(skillKey);
                    if (skill.isEmpty()) continue;
                    categoryObj.getSkill(skill).ifPresent(skillObj -> skillObj.unlock(user));
                }
            });
        }
        if (!stack.m_41783_().m_128456_()) {
            int tempSize = stack.m_41783_().m_128440_();
            for (int i = 0; i < tempSize; ++i) {
                String categoryKey = "category" + i;
                if (nbt.m_128461_(categoryKey).isEmpty()) continue;
                nbt.m_128473_(categoryKey);
                for (int s = 0; s < tempSize; ++s) {
                    String skillKey = "skill" + s;
                    if (nbt.m_128461_(skillKey).isEmpty()) continue;
                    nbt.m_128473_(skillKey);
                }
            }
            nbt.m_128473_("player_uuid");
            nbt.m_128473_("player_name");
        }
        if ((slot = HelperMethods.getSlotWithStack((Player)user, stack)) != -1) {
            ModPacketHandler.syncItemStackNbt(user, slot, stack);
        }
        return true;
    }

    public static void printNBT(ItemStack stack, List<Component> tooltip, String type) {
        CompoundTag nbt = stack.m_41783_();
        if (nbt == null) {
            return;
        }
        if (!nbt.m_128456_()) {
            int tempSize = nbt.m_128440_();
            int skillPrintCount = 0;
            for (int i = 0; i < tempSize; ++i) {
                if (!nbt.m_128461_("category" + i).isEmpty() && type.equals("category") && !nbt.m_128461_("category" + i).contains("tree")) {
                    tooltip.add((Component)Component.m_237113_((String)("  \u00a76\u25c7 \u00a7f" + nbt.m_128461_("category" + i).replace("simplyskills:", "").replace("puffish_skills:prom", "Talent Tree"))));
                }
                if (nbt.m_128461_("skill" + i).isEmpty()) continue;
                ++skillPrintCount;
            }
            if (type.equals("skill")) {
                tooltip.add((Component)Component.m_237113_((String)("  \u00a7b\u25c7 \u00a7f" + skillPrintCount)));
            }
            if (!nbt.m_128461_("player_name").isEmpty()) {
                String name = nbt.m_128461_("player_name");
                if (type.equals("name")) {
                    tooltip.add((Component)Component.m_237113_((String)("\u00a77Bound to: " + name)));
                }
            }
        }
    }

    public static int getUnspentPoints(ServerPlayer player) {
        return SkillsAPI.streamUnlockedCategories((ServerPlayer)player).mapToInt(category -> category.getPointsLeft(player)).sum();
    }

    public static double getHighestAttributeValue(Player player) {
        double attackDamage = player.m_21133_(Attributes.f_22281_);
        double toughness = SpellPower.getSpellPower((SpellSchool)SpellSchools.FROST, (LivingEntity)player).baseValue();
        double fire = SpellPower.getSpellPower((SpellSchool)SpellSchools.FIRE, (LivingEntity)player).baseValue();
        double arcane = SpellPower.getSpellPower((SpellSchool)SpellSchools.ARCANE, (LivingEntity)player).baseValue();
        double soul = SpellPower.getSpellPower((SpellSchool)SpellSchools.SOUL, (LivingEntity)player).baseValue();
        double healing = SpellPower.getSpellPower((SpellSchool)SpellSchools.HEALING, (LivingEntity)player).baseValue();
        double lightning = SpellPower.getSpellPower((SpellSchool)SpellSchools.LIGHTNING, (LivingEntity)player).baseValue();
        double ranged = player.m_21133_(AttributesMod.RANGED_DAMAGE);
        Double[] attributeValues = new Double[]{attackDamage, toughness, fire, arcane, soul, healing, lightning, ranged};
        return Arrays.stream(attributeValues).max(Comparator.naturalOrder()).orElse((Double)Double.MIN_VALUE);
    }

    public static double getHighestSpecificAttributeValue(Player player, Attribute ... attributes) {
        double highestValue = Double.MIN_VALUE;
        for (Attribute attribute : attributes) {
            double attributeValue = player.m_21133_(attribute);
            if (!(attributeValue > highestValue)) continue;
            highestValue = attributeValue;
        }
        return highestValue;
    }

    public static void spawnWaistHeightParticles(ServerLevel world, ParticleOptions particle, Entity entity1, Entity entity2, int count) {
        Vec3 startPos = entity1.m_20182_().m_82520_(0.0, (double)entity1.m_20206_() / 2.0, 0.0);
        Vec3 endPos = entity2.m_20182_().m_82520_(0.0, (double)entity2.m_20206_() / 2.0, 0.0);
        Vec3 direction = endPos.m_82546_(startPos);
        double distance = direction.m_82553_();
        Vec3 normalizedDirection = direction.m_82541_();
        for (int i = 0; i < count; ++i) {
            double lerpFactor = (double)i / (double)(count - 1);
            Vec3 currentPos = startPos.m_82549_(normalizedDirection.m_82490_(distance * lerpFactor));
            world.m_8767_(particle, currentPos.f_82479_, currentPos.f_82480_, currentPos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void spawnOrbitParticles(ServerLevel world, Vec3 center, ParticleOptions particleType, double radius, int particleCount) {
        for (int i = 0; i < particleCount; ++i) {
            double angle = Math.PI * 2 * (double)i / (double)particleCount;
            double x = center.f_82479_ + radius * Math.cos(angle);
            double z = center.f_82481_ + radius * Math.sin(angle);
            double y = center.f_82480_;
            world.m_8767_(particleType, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static double getGroundDistance(Entity entity) {
        BlockPos pos = entity.m_20183_();
        while (pos.m_123342_() > 0 && !entity.m_9236_().m_8055_(pos).m_60796_((BlockGetter)entity.m_9236_(), pos)) {
            pos = pos.m_7495_();
        }
        return entity.m_20186_() - (double)pos.m_123342_();
    }

    public static boolean hasHarmfulStatusEffect(LivingEntity entity) {
        for (MobEffectInstance effectInstance : entity.m_21220_()) {
            if (effectInstance.m_19544_().m_19483_() != MobEffectCategory.HARMFUL) continue;
            return true;
        }
        return false;
    }

    public static int countHarmfulStatusEffects(LivingEntity entity) {
        int harmfulEffectCount = 0;
        for (MobEffectInstance effectInstance : entity.m_21220_()) {
            if (effectInstance.m_19544_().m_19483_() != MobEffectCategory.HARMFUL) continue;
            ++harmfulEffectCount;
        }
        return harmfulEffectCount;
    }

    public static boolean isDualWielding(LivingEntity livingEntity) {
        return !(!(livingEntity.m_21205_().m_41720_() instanceof SwordItem) && !(livingEntity.m_21205_().m_41720_() instanceof AxeItem) || !(livingEntity.m_21206_().m_41720_() instanceof SwordItem) && !(livingEntity.m_21206_().m_41720_() instanceof AxeItem));
    }

    public static void spawnDirectionalParticles(ServerLevel world, ParticleOptions particle, Entity entity, int count, double distance) {
        Vec3 startPos = entity.m_20182_().m_82520_(0.0, (double)entity.m_20206_() / 2.0, 0.0);
        float pitch = entity.m_5686_(1.0f);
        float yaw = entity.m_5675_(1.0f);
        double pitchRadians = Math.toRadians(pitch);
        double yawRadians = Math.toRadians(yaw);
        double xDirection = -Math.sin(yawRadians) * Math.cos(pitchRadians);
        double yDirection = -Math.sin(pitchRadians);
        double zDirection = Math.cos(yawRadians) * Math.cos(pitchRadians);
        Vec3 direction = new Vec3(xDirection, yDirection, zDirection).m_82541_();
        for (int i = 0; i < count; ++i) {
            double lerpFactor = (double)i / (double)(count - 1);
            Vec3 currentPos = startPos.m_82549_(direction.m_82490_(distance * lerpFactor));
            world.m_8767_(particle, currentPos.f_82479_, currentPos.f_82480_, currentPos.f_82481_, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public static void damageEntitiesInTrajectory(ServerLevel world, Entity sourceEntity, Player playerEntity, double distance, float damage, DamageSource damageSource) {
        Vec3 startPos = sourceEntity.m_20182_().m_82520_(0.0, (double)sourceEntity.m_20206_() / 2.0, 0.0);
        float pitch = sourceEntity.m_5686_(1.0f);
        float yaw = sourceEntity.m_5675_(1.0f);
        double pitchRadians = Math.toRadians(pitch);
        double yawRadians = Math.toRadians(yaw);
        double xDirection = -Math.sin(yawRadians) * Math.cos(pitchRadians);
        double yDirection = -Math.sin(pitchRadians);
        double zDirection = Math.cos(yawRadians) * Math.cos(pitchRadians);
        Vec3 direction = new Vec3(xDirection, yDirection, zDirection).m_82541_();
        Vec3 endPos = startPos.m_82549_(direction.m_82490_(distance));
        double boxSize = 0.5;
        AABB searchBox = new AABB(startPos, endPos).m_82400_(boxSize);
        for (Entity entity : world.m_45933_(sourceEntity, searchBox)) {
            LivingEntity livingTarget;
            AABB entityBox = entity.m_20191_().m_82400_((double)entity.m_6143_());
            if (!entityBox.m_82381_(searchBox) || !(entity instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(livingTarget = (LivingEntity)entity, playerEntity)) continue;
            livingTarget.m_6469_(damageSource, damage);
            if (!(sourceEntity instanceof LivingEntity)) continue;
            LivingEntity livingSource = (LivingEntity)sourceEntity;
            NecromancerAbilities.effectPestilence(playerEntity, livingSource, livingTarget);
        }
    }
}

