/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.mixins;

import java.util.ArrayList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.puffish.skillsmod.SkillsMod;
import net.puffish.skillsmod.api.Category;
import net.puffish.skillsmod.api.SkillsAPI;
import net.puffish.skillsmod.server.network.packets.in.SkillClickInPacket;
import net.sweenus.simplyskills.abilities.AbilityLogic;
import net.sweenus.simplyskills.network.ModPacketHandler;
import net.sweenus.simplyskills.registry.SoundRegistry;
import net.sweenus.simplyskills.util.HelperMethods;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SkillsMod.class})
public class SkillsModMixin {
    @Inject(at={@At(value="HEAD")}, method={"tryUnlockSkill"})
    public void simplyskills$tryUnlockSkill(ServerPlayer player, ResourceLocation categoryId, String skillId, boolean force, CallbackInfo ci) {
        Category category = (Category)SkillsAPI.getCategory((ResourceLocation)categoryId).orElseThrow();
        if (!HelperMethods.hasUnlockedSkill(category, skillId, (LivingEntity)player) && category.getPointsLeft(player) > 0) {
            double choose_pitch = Math.random() * 1.3;
            ArrayList<SoundEvent> sounds = new ArrayList<SoundEvent>();
            sounds.add(SoundRegistry.PLACE_STONE_06);
            sounds.add(SoundRegistry.PLACE_STONE_07);
            sounds.add(SoundRegistry.PLACE_STONE_08);
            sounds.add(SoundRegistry.PLACE_STONE_09);
            sounds.add(SoundRegistry.PLACE_STONE_10);
            SoundEvent sound = (SoundEvent)sounds.get(player.m_217043_().m_188503_(sounds.size()));
            player.m_9236_().m_6269_(null, (Entity)player, sound, SoundSource.PLAYERS, 0.3f, (float)choose_pitch);
            if (category.streamUnlockedSkills(player).count() > 40L && categoryId.equals((Object)new ResourceLocation("simplyskills:tree"))) {
                SkillsAPI.getCategory((ResourceLocation)new ResourceLocation("simplyskills", "ascendancy")).ifPresent(ascendancy -> ascendancy.unlock(player));
            }
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"tryUnlockSkill"})
    public void simplyskills$tryUnlockSkillTail(ServerPlayer player, ResourceLocation categoryId, String skillId, boolean force, CallbackInfo ci) {
        ModPacketHandler.sendSignatureAbility(player);
    }

    @Inject(at={@At(value="TAIL")}, method={"resetSkills"})
    public void simplyskills$resetSkills(ServerPlayer player, ResourceLocation categoryId, CallbackInfo ci) {
        ModPacketHandler.sendSignatureAbility(player);
    }

    @Inject(at={@At(value="TAIL")}, method={"eraseCategory"})
    public void simplyskills$eraseCategory(ServerPlayer player, ResourceLocation categoryId, CallbackInfo ci) {
        ModPacketHandler.sendSignatureAbility(player);
    }

    @Inject(at={@At(value="TAIL")}, method={"onSkillClickPacket"})
    public void simplyskills$onSkillClickPacket(ServerPlayer player, SkillClickInPacket packet, CallbackInfo ci) {
        AbilityLogic.performJunctionLogic(player, packet.getSkillId(), packet.getCategoryId());
    }

    @Inject(at={@At(value="HEAD")}, method={"unlockCategory"}, cancellable=true)
    public void simplyskills$unlockCategory(ServerPlayer player, ResourceLocation categoryIdentifier, CallbackInfo ci) {
        String categoryId = categoryIdentifier.toString();
        if (AbilityLogic.skillTreeUnlockManager((Player)player, categoryId)) {
            ci.cancel();
        }
    }
}

