/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.mixins;

import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.sweenus.simplyskills.abilities.AbilityEffects;
import net.sweenus.simplyskills.abilities.AscendancyAbilities;
import net.sweenus.simplyskills.abilities.CrusaderAbilities;
import net.sweenus.simplyskills.abilities.RangerAbilities;
import net.sweenus.simplyskills.abilities.WarriorAbilities;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.util.HelperMethods;
import net.sweenus.simplyskills.util.SkillReferencePosition;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Player.class})
public class PlayerEntityMixin {
    @Inject(at={@At(value="HEAD")}, method={"onKilledOther"})
    public void simplyskills$onKilledOther(ServerLevel world, LivingEntity other, CallbackInfoReturnable<Boolean> cir) {
        Player player = (Player)this;
        if (player instanceof ServerPlayer) {
            if (HelperMethods.isUnlocked("simplyskills:berserker", SkillReferencePosition.berserkerSpecialisationBloodthirsty, (LivingEntity)player)) {
                AbilityEffects.effectBerserkerBloodthirsty(player);
            }
            if (HelperMethods.isUnlocked("simplyskills:ranger", SkillReferencePosition.rangerSpecialisationElementalArrowsRenewal, (LivingEntity)player)) {
                RangerAbilities.passiveRangerElementalArrowsRenewal(player);
            }
            if (HelperMethods.isUnlocked("simplyskills:rogue", SkillReferencePosition.rogueSpecialisationEvasionFanOfBladesRenewal, (LivingEntity)player)) {
                player.m_7292_(new MobEffectInstance(EffectRegistry.FANOFBLADES, 500, 1, false, false, true));
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"takeShieldHit"})
    public void simplyskills$takeShieldHit(LivingEntity attacker, CallbackInfo ci) {
        Player player = (Player)this;
        if (player instanceof ServerPlayer) {
            if (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.bulwarkRebuke, (LivingEntity)player)) {
                WarriorAbilities.passiveWarriorRebuke(player, attacker);
            }
            if (HelperMethods.isUnlocked("simplyskills:crusader", SkillReferencePosition.crusaderRetribution, (LivingEntity)player)) {
                CrusaderAbilities.passiveCrusaderRetribution(player, attacker);
            }
            if (HelperMethods.isUnlocked("simplyskills:crusader", SkillReferencePosition.crusaderExhaustiveRecovery, (LivingEntity)player)) {
                CrusaderAbilities.passiveCrusaderExhaustiveRecovery(player, attacker);
            }
            if (HelperMethods.isUnlocked("simplyskills:ascendancy", SkillReferencePosition.ascendancyRighteousShield, (LivingEntity)player)) {
                AscendancyAbilities.goldenAegis(player);
            }
        }
    }
}

