/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.mixins;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.sweenus.simplyskills.SimplySkills;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.util.DynamicDamage;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={LivingEntity.class})
public abstract class LivingEntityMixin {
    @Shadow
    protected float f_20898_;
    @Shadow
    private long f_20930_;

    @Shadow
    public abstract float m_21233_();

    @Shadow
    @Nullable
    public abstract LivingEntity m_21188_();

    @Shadow
    public abstract float m_21223_();

    @Shadow
    public abstract boolean m_6469_(DamageSource var1, float var2);

    @Inject(at={@At(value="HEAD")}, method={"canTarget(Lnet/minecraft/entity/LivingEntity;)Z"}, cancellable=true)
    public void simplyskills$canTarget(LivingEntity target, CallbackInfoReturnable<Boolean> cir) {
        if (target.m_21023_(EffectRegistry.STEALTH)) {
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"isDead"}, cancellable=true)
    public void simplyskills$tick(CallbackInfoReturnable<Boolean> cir) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (livingEntity.m_21223_() <= 0.0f && livingEntity.m_21023_(EffectRegistry.UNDYING)) {
            livingEntity.m_21153_(1.0f);
            cir.setReturnValue((Object)false);
        }
    }

    @Inject(method={"modifyAppliedDamage"}, at={@At(value="RETURN")}, cancellable=true)
    protected void simplyskills$modifyAppliedDamage(DamageSource source, float amount, CallbackInfoReturnable<Float> cir) {
        LivingEntity livingEntity;
        LivingEntity attacker = this.m_21188_();
        float newAmount = DynamicDamage.dynamicDamageReduction(attacker, livingEntity = (LivingEntity)this, amount, this.f_20898_, ((Float)cir.getReturnValue()).floatValue(), this.f_20930_);
        if (newAmount != amount) {
            cir.setReturnValue((Object)Float.valueOf(newAmount));
        }
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="HEAD")})
    private void simplyskills$readCustomDataFromNbt(CallbackInfo ci) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (!livingEntity.m_9236_().f_46443_ && SimplySkills.generalConfig.enableDAS && !(livingEntity instanceof Player)) {
            DynamicDamage.dynamicPlayerCountScaling(livingEntity);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void simplyskills$onEntityTick(CallbackInfo ci) {
        LivingEntity livingEntity = (LivingEntity)this;
        if (!(livingEntity.m_9236_().f_46443_ || !SimplySkills.generalConfig.enableDAS || livingEntity instanceof Player || livingEntity.f_19797_ % (SimplySkills.generalConfig.DASUpdateFrequency * 20) != 0 && livingEntity.f_19797_ != 20)) {
            DynamicDamage.dynamicPlayerCountScaling(livingEntity);
        }
    }
}

