/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.items;

import java.util.List;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.puffish.skillsmod.api.Category;
import net.puffish.skillsmod.api.SkillsAPI;
import net.sweenus.simplyskills.SimplySkills;
import net.sweenus.simplyskills.client.SimplySkillsClient;
import net.sweenus.simplyskills.network.ModPacketHandler;
import net.sweenus.simplyskills.network.UpdateUnspentPointsPacket;
import net.sweenus.simplyskills.registry.SoundRegistry;
import net.sweenus.simplyskills.util.HelperMethods;

public class SkillChronicle
extends Item {
    public SkillChronicle(Item.Properties settings) {
        super(settings);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.m_21120_(hand);
        if (itemStack.m_41773_() >= itemStack.m_41776_() + 10) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        world.m_5594_(null, user.m_20183_(), SoundRegistry.SOUNDEFFECT6, SoundSource.PLAYERS, 0.3f, 0.7f);
        user.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    public int m_8105_(ItemStack stack) {
        return 60;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.CROSSBOW;
    }

    public void m_5929_(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        if (!world.f_46443_ && user.m_6844_(EquipmentSlot.MAINHAND) == stack && remainingUseTicks < 35) {
            user.m_21253_();
        }
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (!world.f_46443_ && user instanceof Player) {
            Player player = (Player)user;
            if (user instanceof ServerPlayer) {
                ServerPlayer serverUser = (ServerPlayer)user;
                if (remainingUseTicks < 35) {
                    int pointsRemaining = 0;
                    boolean hasSpentPoints = false;
                    boolean success = false;
                    for (Category uc : SkillsAPI.streamUnlockedCategories((ServerPlayer)serverUser)::iterator) {
                        if (FabricLoader.getInstance().isModLoaded("prominent") && uc.getId().toString().equals("puffish_skills:prom")) {
                            pointsRemaining = uc.getPointsLeft(serverUser);
                            hasSpentPoints = uc.streamUnlockedSkills(serverUser).findAny().isPresent();
                            continue;
                        }
                        if (FabricLoader.getInstance().isModLoaded("prominent") || !uc.getId().toString().equals("simplyskills:tree")) continue;
                        pointsRemaining = uc.getPointsLeft(serverUser);
                        hasSpentPoints = uc.streamUnlockedSkills(serverUser).findAny().isPresent();
                    }
                    if (hasSpentPoints) {
                        if (HelperMethods.storeBuildTemplate(serverUser, stack)) {
                            world.m_5594_(null, user.m_20183_(), SoundRegistry.SOUNDEFFECT44, SoundSource.PLAYERS, 0.6f, 1.0f);
                            player.m_36335_().m_41524_((Item)this, SimplySkills.generalConfig.skillChronicleCooldown);
                            user.m_213846_((Component)Component.m_237113_((String)"Build Stored Successfully"));
                            success = true;
                        }
                    } else if (HelperMethods.applyBuildTemplate(serverUser, stack)) {
                        world.m_5594_(null, user.m_20183_(), SoundRegistry.SOUNDEFFECT43, SoundSource.PLAYERS, 0.7f, 1.0f);
                        player.m_36335_().m_41524_((Item)this, SimplySkills.generalConfig.skillChronicleCooldown);
                        user.m_213846_((Component)Component.m_237113_((String)"Build Retrieved Successfully"));
                        success = true;
                    }
                    if (!success) {
                        user.m_213846_((Component)Component.m_237113_((String)"You do not meet the requirements"));
                        player.m_36335_().m_41524_((Item)this, 60);
                    }
                }
            }
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ModPacketHandler.sendStopSoundPacket(serverPlayer, SoundRegistry.SOUNDEFFECT6.m_11660_());
            }
            if (!player.m_36335_().m_41519_((Item)this)) {
                player.m_36335_().m_41524_((Item)this, 60);
            }
        }
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        if (!world.f_46443_ && entity.f_19797_ % 60 == 0 && entity instanceof ServerPlayer) {
            ServerPlayer user = (ServerPlayer)entity;
            int unspentPoints = HelperMethods.getUnspentPoints(user);
            ModPacketHandler.sendTo(user, new UpdateUnspentPointsPacket(unspentPoints));
        }
        super.m_6883_(stack, world, entity, slot, selected);
    }

    public void m_7373_(ItemStack itemStack, Level world, List<Component> tooltip, TooltipFlag tooltipContext) {
        CompoundTag nbt = itemStack.m_41784_();
        if (nbt != null) {
            if (!nbt.m_128461_("player_uuid").isEmpty()) {
                tooltip.add((Component)Component.m_237113_((String)""));
                tooltip.add((Component)Component.m_237115_((String)"item.simplyskills.skill_chronicle.tooltip10"));
                tooltip.add((Component)Component.m_237113_((String)""));
                tooltip.add((Component)Component.m_237115_((String)"item.simplyskills.skill_chronicle.tooltip8"));
                tooltip.add((Component)Component.m_237113_((String)""));
                if (FabricLoader.getInstance().isModLoaded("prominent")) {
                    tooltip.add((Component)Component.m_237113_((String)"\u00a77Stored Skill Trees."));
                } else {
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyskills.skill_chronicle.tooltip14"));
                }
                HelperMethods.printNBT(itemStack, tooltip, "category");
                tooltip.add((Component)Component.m_237113_((String)""));
                tooltip.add((Component)Component.m_237115_((String)"item.simplyskills.skill_chronicle.tooltip15"));
                HelperMethods.printNBT(itemStack, tooltip, "skill");
                tooltip.add((Component)Component.m_237113_((String)""));
                HelperMethods.printNBT(itemStack, tooltip, "name");
                if (SimplySkillsClient.unspentPoints > 0) {
                    tooltip.add((Component)Component.m_237113_((String)""));
                    tooltip.add((Component)Component.m_237110_((String)"item.simplyskills.skill_chronicle.tooltip11", (Object[])new Object[]{SimplySkillsClient.unspentPoints}));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyskills.skill_chronicle.tooltip12"));
                }
                tooltip.add((Component)Component.m_237113_((String)""));
            } else {
                tooltip.add((Component)Component.m_237113_((String)""));
                tooltip.add((Component)Component.m_237115_((String)"item.simplyskills.skill_chronicle.tooltip9"));
                tooltip.add((Component)Component.m_237113_((String)""));
                tooltip.add((Component)Component.m_237115_((String)"item.simplyskills.skill_chronicle.tooltip7"));
                if (SimplySkillsClient.unspentPoints > 0) {
                    tooltip.add((Component)Component.m_237113_((String)""));
                    tooltip.add((Component)Component.m_237110_((String)"item.simplyskills.skill_chronicle.tooltip11", (Object[])new Object[]{SimplySkillsClient.unspentPoints}));
                    tooltip.add((Component)Component.m_237115_((String)"item.simplyskills.skill_chronicle.tooltip13"));
                }
                tooltip.add((Component)Component.m_237113_((String)""));
            }
        }
        tooltip.add((Component)Component.m_237115_((String)"item.simplyskills.skill_chronicle.tooltip16"));
        if (Screen.m_96639_()) {
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237115_((String)"item.simplyskills.skill_chronicle.tooltip1"));
            tooltip.add((Component)Component.m_237115_((String)"item.simplyskills.skill_chronicle.tooltip2"));
            if (FabricLoader.getInstance().isModLoaded("prominent")) {
                tooltip.add((Component)Component.m_237113_((String)"skill trees."));
            } else {
                tooltip.add((Component)Component.m_237115_((String)"item.simplyskills.skill_chronicle.tooltip3"));
            }
            tooltip.add((Component)Component.m_237113_((String)""));
            tooltip.add((Component)Component.m_237115_((String)"item.simplyskills.skill_chronicle.tooltip4"));
            tooltip.add((Component)Component.m_237115_((String)"item.simplyskills.skill_chronicle.tooltip5"));
            tooltip.add((Component)Component.m_237115_((String)"item.simplyskills.skill_chronicle.tooltip6"));
        }
    }
}

