/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.entities.ai;

import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.phys.Vec3;
import net.sweenus.simplyskills.util.HelperMethods;

public class DirectionalFlightMoveControl
extends MoveControl {
    private final int maxPitchChange;
    private final boolean noGravity;
    private final Mob entity;
    private final double minAltitudeAboveGround = 4.0;
    private long lastAttackTime = 0L;
    private static final long ATTACK_COOLDOWN = 5000L;
    private double yOffset = 0.0;

    public DirectionalFlightMoveControl(Mob entity, int maxPitchChange, boolean noGravity) {
        super(entity);
        this.maxPitchChange = maxPitchChange;
        this.noGravity = noGravity;
        this.entity = entity;
    }

    public void m_8126_() {
        if (this.noGravity) {
            this.entity.m_20242_(true);
        }
        this.yOffset = this.entity.m_5448_() != null ? 0.0 : 4.0;
        if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
            this.f_24981_ = MoveControl.Operation.WAIT;
            if (this.entity.m_5448_() == null) {
                this.f_24975_ = this.entity.m_20185_() + this.entity.m_217043_().m_188583_() * 5.0;
                this.f_24976_ = this.entity.m_20186_() + this.entity.m_217043_().m_188583_() * 5.0;
                this.f_24977_ = this.entity.m_20189_() + this.entity.m_217043_().m_188583_() * 5.0;
            } else {
                this.f_24975_ = this.entity.m_5448_().m_20185_();
                this.f_24976_ = this.entity.m_5448_().m_20186_();
                this.f_24977_ = this.entity.m_5448_().m_20189_();
            }
            this.f_24976_ += Math.sin((double)this.entity.f_19797_ * 0.3) * 0.5;
            double d = this.f_24975_ - this.entity.m_20185_();
            double e = this.f_24976_ + this.yOffset - this.entity.m_20186_();
            double f = this.f_24977_ - this.entity.m_20189_();
            double g = d * d + e * e + f * f;
            if (g < 2.500000277905201E-7) {
                this.entity.m_21567_(0.0f);
                this.entity.m_21564_(0.0f);
                this.f_24975_ = this.entity.m_20185_() + this.entity.m_217043_().m_188583_() * 5.0;
                this.f_24976_ = this.entity.m_20186_() + this.entity.m_217043_().m_188583_() * 5.0;
                this.f_24977_ = this.entity.m_20189_() + this.entity.m_217043_().m_188583_() * 5.0;
                return;
            }
            float h = (float)(Mth.m_14136_((double)f, (double)d) * 57.29577951308232) - 90.0f;
            this.entity.m_146922_(this.m_24991_(this.entity.m_146908_(), h, 90.0f));
            float i = this.entity.m_20096_() ? (float)(this.f_24978_ * this.entity.m_21133_(Attributes.f_22279_)) : (float)(this.f_24978_ * this.entity.m_21133_(Attributes.f_22280_));
            this.entity.m_7910_(i);
            double j = Math.sqrt(d * d + f * f);
            boolean recentlyAttacked = this.entity.m_5448_() != null && System.currentTimeMillis() - this.lastAttackTime > 5000L;
            double groundDistance = HelperMethods.getGroundDistance((Entity)this.entity);
            if (groundDistance < this.minAltitudeAboveGround && !recentlyAttacked) {
                this.f_24976_ = this.entity.m_20186_() + (this.minAltitudeAboveGround - groundDistance);
                e = this.f_24976_ - this.entity.m_20186_();
            }
            if (Math.abs(e) > (double)1.0E-5f || Math.abs(j) > (double)1.0E-5f) {
                float k = (float)(-(Mth.m_14136_((double)e, (double)j) * 57.29577951308232));
                this.entity.m_146926_(this.m_24991_(this.entity.m_146909_(), k, this.maxPitchChange));
                this.entity.m_21567_(e > 0.0 ? i : -i);
            }
        } else {
            this.entity.m_21567_(0.1f);
            Vec3 velocity = this.entity.m_20184_();
            this.entity.m_146926_((float)(-(Mth.m_14136_((double)velocity.f_82480_, (double)Math.sqrt(velocity.f_82479_ * velocity.f_82479_ + velocity.f_82481_ * velocity.f_82481_)) * 57.29577951308232)));
            this.entity.m_21564_(0.1f);
            this.entity.m_146922_((float)(Mth.m_14136_((double)velocity.f_82481_, (double)velocity.f_82479_) * 57.29577951308232) - 90.0f);
        }
    }

    public void onAttack() {
        this.lastAttackTime = System.currentTimeMillis();
    }
}

