/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.entities;

import java.util.Comparator;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.EntityGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.sweenus.simplyskills.abilities.AscendancyAbilities;
import net.sweenus.simplyskills.abilities.NecromancerAbilities;
import net.sweenus.simplyskills.abilities.SignatureAbilities;
import net.sweenus.simplyskills.effects.instance.SimplyStatusEffectInstance;
import net.sweenus.simplyskills.entities.ai.DirectionalFlightMoveControl;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.registry.SoundRegistry;
import net.sweenus.simplyskills.util.HelperMethods;
import net.sweenus.simplyskills.util.SkillReferencePosition;
import org.jetbrains.annotations.Nullable;

public class WraithEntity
extends TamableAnimal
implements NeutralMob,
FlyingAnimal {
    public static int lifespan = 2400;
    public static Entity lookTarget = null;

    public WraithEntity(EntityType<? extends TamableAnimal> entityType, Level world) {
        super(entityType, world);
        this.f_21342_ = new DirectionalFlightMoveControl((Mob)this, 1, true);
        this.m_20242_(true);
    }

    public static AttributeSupplier.Builder createWraithAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 15.0).m_22268_(Attributes.f_22280_, (double)1.6f).m_22268_(Attributes.f_22279_, (double)0.6f).m_22268_(Attributes.f_22281_, 10.0).m_22268_(Attributes.f_22278_, 0.1).m_22268_(Attributes.f_22277_, 10.0);
    }

    public void m_8119_() {
        if (!this.m_9236_().m_5776_()) {
            LivingEntity livingEntity;
            boolean ownerNotInWorld = true;
            if (this.m_21805_() != null) {
                Player owner = this.m_9236_().m_46003_(this.m_21805_());
                boolean bl = ownerNotInWorld = owner == null || !owner.m_6084_();
            }
            if (this.f_19797_ > lifespan || this.f_19797_ > 120 && (this.m_269323_() == null || ownerNotInWorld)) {
                this.m_6469_(this.m_269291_().m_269264_(), this.m_21233_());
                this.m_142687_(Entity.RemovalReason.UNLOADED_WITH_PLAYER);
            }
            this.m_20229_(0.0, 0.0, 0.0);
            if (!this.m_20068_()) {
                this.m_20242_(true);
            }
            this.f_19860_ = this.m_146909_();
            this.f_19859_ = this.m_146908_();
            if (this.m_5448_() == null && this.m_269323_() != null) {
                this.m_6710_(this.m_269323_());
            } else if (this.m_5448_() != null && !this.m_5448_().equals((Object)this.m_269323_()) && this.m_20270_((Entity)this.m_5448_()) > 20.0f) {
                this.m_6710_(this.m_269323_());
            }
            AABB box = HelperMethods.createBoxHeight((Entity)this, 16);
            int frequency = 20 + this.m_217043_().m_188503_(30);
            if (this.f_19797_ % frequency == 0 && this.m_269323_() != null && this.m_269323_().m_6084_() && (livingEntity = this.m_269323_()) instanceof Player) {
                Player player = (Player)livingEntity;
                Level world = this.m_9236_();
                Entity closestEntity = world.m_6249_((Entity)this, box, EntitySelector.f_20403_).stream().filter(entity -> {
                    TamableAnimal tameableEntity;
                    return !(entity instanceof TamableAnimal && (tameableEntity = (TamableAnimal)entity).m_21824_() && tameableEntity.m_21805_() != null && tameableEntity.m_21805_().equals(this.m_21805_()));
                }).filter(entity -> {
                    Player playerEntity;
                    return !(entity instanceof Player && (playerEntity = (Player)entity).m_20148_().equals(this.m_21805_()));
                }).min(Comparator.comparingDouble(entity -> entity.m_20280_((Entity)this))).orElse(null);
                if (closestEntity != null && closestEntity instanceof LivingEntity) {
                    LivingEntity ee = (LivingEntity)closestEntity;
                    if (!(closestEntity instanceof AgeableMob) && HelperMethods.checkFriendlyFire(ee, player)) {
                        if (HelperMethods.isUnlocked("simplyskills:necromancer", SkillReferencePosition.necromancerSpecialisationWitherWraiths, (LivingEntity)player)) {
                            SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:minion_soul_spell_wither", 32, (Entity)ee, null);
                        } else if (HelperMethods.isUnlocked("simplyskills:necromancer", SkillReferencePosition.necromancerSpecialisationFrostWraiths, (LivingEntity)player)) {
                            SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:minion_soul_spell_frost", 32, (Entity)ee, null);
                        } else {
                            SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:minion_soul_spell", 32, (Entity)ee, null);
                        }
                        HelperMethods.spawnWaistHeightParticles((ServerLevel)world, (ParticleOptions)ParticleTypes.f_123762_, (Entity)this, (Entity)ee, 20);
                        lookTarget = ee;
                        int chance = this.m_217043_().m_188503_(100);
                        int chanceCheck = HelperMethods.countHarmfulStatusEffects((LivingEntity)this) * 5;
                        if (chance < chanceCheck && HelperMethods.isUnlocked("simplyskills:necromancer", SkillReferencePosition.necromancerSpecialisationWraithLegion, (LivingEntity)player)) {
                            SimplyStatusEffectInstance agonyEffect = new SimplyStatusEffectInstance(EffectRegistry.AGONY, 200 + AscendancyAbilities.getAscendancyPoints(player), 0, false, false, true);
                            agonyEffect.setSourceEntity((LivingEntity)player);
                            ee.m_7292_((MobEffectInstance)agonyEffect);
                            player.m_9236_().m_6269_(null, (Entity)player, SoundRegistry.MAGIC_SHAMANIC_SPELL_04, SoundSource.PLAYERS, 0.1f, 1.0f);
                        }
                        return;
                    }
                }
            }
            if (lookTarget != null) {
                this.m_21391_(lookTarget, 90.0f, 10.0f);
                Vec3 direction = new Vec3(lookTarget.m_20185_() - this.m_20185_(), 0.0, lookTarget.m_20189_() - this.m_20189_());
                float targetYaw = (float)(Mth.m_14136_((double)direction.f_82481_, (double)direction.f_82479_) * 57.29577951308232) - 90.0f;
                this.m_5618_(targetYaw);
                this.f_20885_ = targetYaw;
            }
        }
        super.m_8119_();
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (Objects.equals(source.m_7639_(), this.m_269323_())) {
            return false;
        }
        return super.m_6469_(source, amount);
    }

    public boolean m_7327_(Entity target) {
        MoveControl moveControl = this.m_21566_();
        if (moveControl instanceof DirectionalFlightMoveControl) {
            ((DirectionalFlightMoveControl)moveControl).onAttack();
        }
        target.f_19802_ = 0;
        return super.m_7327_(target);
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    public void m_6667_(DamageSource damageSource) {
        LivingEntity livingEntity;
        if (!this.m_9236_().m_5776_() && this.m_269323_() != null && (livingEntity = this.m_269323_()) instanceof Player) {
            Player player = (Player)livingEntity;
            NecromancerAbilities.effectNecromancerEnrage((LivingEntity)this, player);
            NecromancerAbilities.effectNecromancerDeathEssence(player);
            NecromancerAbilities.effectShadowCombust(player, this);
            NecromancerAbilities.effectEndlessServitude(player, this);
        }
        super.m_6667_(damageSource);
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(1, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 8.0f, 12.0f, true));
        this.f_21345_.m_25352_(4, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
    }

    public void m_8107_() {
        super.m_8107_();
    }

    public EntityGetter m_9236_() {
        return this.m_9236_();
    }

    public int m_6784_() {
        return 0;
    }

    public void m_7870_(int angerTime) {
    }

    @Nullable
    public UUID m_6120_() {
        return null;
    }

    public void m_6925_(@Nullable UUID angryAt) {
    }

    public void m_6825_() {
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel world, AgeableMob entity) {
        return null;
    }

    public boolean m_29443_() {
        return true;
    }

    protected void m_7840_(double heightDifference, boolean onGround, BlockState landedState, BlockPos landedPosition) {
    }

    public boolean m_142535_(float fallDistance, float damageMultiplier, DamageSource damageSource) {
        return false;
    }

    protected PathNavigation m_6037_(Level world) {
        FlyingPathNavigation birdNavigation = new FlyingPathNavigation((Mob)this, world){};
        birdNavigation.m_26440_(false);
        birdNavigation.m_7008_(false);
        birdNavigation.m_26443_(false);
        return birdNavigation;
    }
}

