/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.effects;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.spell_engine.particle.Particles;
import net.sweenus.simplyskills.effects.instance.SimplyStatusEffectInstance;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.registry.SoundRegistry;
import net.sweenus.simplyskills.util.HelperMethods;
import net.sweenus.simplyskills.util.SkillReferencePosition;

public class VitalityBondEffect
extends MobEffect {
    public LivingEntity target;

    public VitalityBondEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
    }

    public void setTarget(LivingEntity livingEntity) {
        this.target = livingEntity;
    }

    public void m_6742_(LivingEntity livingEntity, int amplifier) {
        if (!livingEntity.m_9236_().m_5776_()) {
            MobEffectInstance mobEffectInstance = livingEntity.m_21124_(EffectRegistry.VITALITYBOND);
            if (mobEffectInstance instanceof SimplyStatusEffectInstance) {
                SimplyStatusEffectInstance statusEffect = (SimplyStatusEffectInstance)mobEffectInstance;
                this.target = statusEffect.getSourceEntity();
            }
            float incrementFrequency = 10.0f;
            if (this.target != null && this.target != livingEntity && (float)livingEntity.f_19797_ % incrementFrequency == 0.0f) {
                LivingEntity healingEntity = null;
                LivingEntity sacrificeEntity = null;
                float incrementAmount = 1.0f;
                float livingEntityHealthPercent = livingEntity.m_21223_() / livingEntity.m_21233_() * 100.0f;
                float targetHealthPercent = this.target.m_21223_() / this.target.m_21233_() * 100.0f;
                if (amplifier > 0) {
                    amplifier = 0;
                }
                if (HelperMethods.isUnlocked("simplyskills:cleric", SkillReferencePosition.clericSpecialisationSacredOrbSpeed, this.target)) {
                    HelperMethods.incrementStatusEffect(livingEntity, MobEffects.f_19598_, (int)incrementFrequency + 5, 1, 6);
                    HelperMethods.incrementStatusEffect(livingEntity, MobEffects.f_19596_, (int)incrementFrequency + 5, 1, 2);
                    HelperMethods.incrementStatusEffect(this.target, MobEffects.f_19599_, (int)incrementFrequency + 5, 1, 3);
                }
                if (HelperMethods.isUnlocked("simplyskills:cleric", SkillReferencePosition.clericSpecialisationSacredOrbDebuffs, this.target)) {
                    HelperMethods.buffSteal(this.target, livingEntity, true, true, true, false);
                }
                if (HelperMethods.isUnlocked("simplyskills:cleric", SkillReferencePosition.clericSpecialisationSacredOrbBuffs, this.target)) {
                    HelperMethods.buffSteal(livingEntity, this.target, false, false, false, false);
                }
                if (Math.abs(livingEntityHealthPercent - targetHealthPercent) > 15.0f && (livingEntityHealthPercent < 85.0f || targetHealthPercent < 85.0f)) {
                    if (livingEntityHealthPercent > targetHealthPercent) {
                        healingEntity = this.target;
                        sacrificeEntity = livingEntity;
                    } else if (livingEntityHealthPercent < targetHealthPercent) {
                        healingEntity = livingEntity;
                        sacrificeEntity = this.target;
                    }
                    HelperMethods.spawnParticlesPlane(livingEntity.m_9236_(), (ParticleOptions)Particles.healing_ascend.particleType, healingEntity.m_20183_(), 1, 0.01, 0.9, 0.03);
                    HelperMethods.spawnParticlesPlane(livingEntity.m_9236_(), (ParticleOptions)Particles.holy_hit.particleType, sacrificeEntity.m_20183_(), 1, 0.01, 0.9, 0.03);
                    sacrificeEntity.m_9236_().m_6269_(null, (Entity)sacrificeEntity, SoundRegistry.SOUNDEFFECT28, SoundSource.PLAYERS, 0.1f, 1.1f);
                    healingEntity.m_9236_().m_6269_(null, (Entity)healingEntity, SoundRegistry.SOUNDEFFECT25, SoundSource.PLAYERS, 0.1f, 1.0f);
                    if (sacrificeEntity != null && healingEntity != null && sacrificeEntity.m_21223_() > 4.0f + incrementAmount) {
                        sacrificeEntity.m_21153_(sacrificeEntity.m_21223_() - incrementAmount);
                        healingEntity.m_5634_(incrementAmount);
                    }
                }
            }
        }
        super.m_6742_(livingEntity, amplifier);
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }

    public void m_6385_(LivingEntity entity, AttributeMap attributes, int amplifier) {
        entity.m_9236_().m_6269_(null, (Entity)entity, SoundRegistry.SPELL_RADIANT_HIT, SoundSource.PLAYERS, 0.1f, 1.5f);
        super.m_6385_(entity, attributes, amplifier);
    }

    public void m_6386_(LivingEntity entity, AttributeMap attributes, int amplifier) {
        entity.m_9236_().m_6269_(null, (Entity)entity, SoundRegistry.SPELL_RADIANT_EXPIRE, SoundSource.PLAYERS, 0.4f, 1.0f);
        super.m_6386_(entity, attributes, amplifier);
    }
}

