/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.effects;

import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyskills.SimplySkills;
import net.sweenus.simplyskills.abilities.SignatureAbilities;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.util.HelperMethods;
import net.sweenus.simplyskills.util.SkillReferencePosition;

public class StaticChargeEffect
extends MobEffect {
    public Player ownerEntity;

    public StaticChargeEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
    }

    public void m_6742_(LivingEntity livingEntity, int amplifier) {
        if (!livingEntity.m_9236_().m_5776_()) {
            int leapFrequency = SimplySkills.wizardConfig.signatureWizardStaticChargeLeapFrequency;
            int leapChance = SimplySkills.wizardConfig.signatureWizardStaticChargeLeapChance;
            int weaknessDuration = SimplySkills.wizardConfig.signatureWizardStaticChargeWeaknessDuration;
            int weaknessAmplifier = SimplySkills.wizardConfig.signatureWizardStaticChargeWeaknessAmplifier;
            if (livingEntity.f_19797_ % leapFrequency == 0) {
                AABB box = HelperMethods.createBox((Entity)livingEntity, 3);
                for (Entity entities : livingEntity.m_9236_().m_6249_((Entity)livingEntity, box, EntitySelector.f_20403_)) {
                    LivingEntity le;
                    if (entities == null || this.ownerEntity == null || !(entities instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entities, this.ownerEntity) || le.m_217043_().m_188503_(100) >= leapChance) continue;
                    SignatureAbilities.castSpellEngineIndirectTarget(this.ownerEntity, "simplyskills:static_charge", 3, (Entity)le, null);
                    le.m_7292_(new MobEffectInstance(MobEffects.f_19613_, weaknessDuration, weaknessAmplifier, false, false, true));
                    MobEffect sc = EffectRegistry.STATICCHARGE;
                    HelperMethods.decrementStatusEffect(livingEntity, sc);
                    if (livingEntity.m_21023_(sc)) {
                        le.m_7292_(new MobEffectInstance(sc, livingEntity.m_21124_(sc).m_19557_(), livingEntity.m_21124_(sc).m_19564_(), false, false, true));
                        livingEntity.m_21195_(sc);
                    }
                    StaticChargeEffect.onHitEffects(this.ownerEntity, StaticChargeEffect.calculateSpeedChance(this.ownerEntity), le);
                    break;
                }
            }
        }
        super.m_6742_(livingEntity, amplifier);
    }

    public static int calculateSpeedChance(Player ownerEntity) {
        int speedBaseChance = SimplySkills.wizardConfig.signatureWizardStaticDischargeBaseSpeedChance;
        int speedChancePerTier = SimplySkills.wizardConfig.signatureWizardStaticDischargeSpeedChancePerTier;
        int speedChance = speedBaseChance;
        if (HelperMethods.isUnlocked("simplyskills:wizard", SkillReferencePosition.wizardSpecialisationStaticDischargeSpeedTwo, (LivingEntity)ownerEntity)) {
            speedChance += speedChancePerTier;
        } else if (HelperMethods.isUnlocked("simplyskills:wizard", SkillReferencePosition.wizardSpecialisationStaticDischargeSpeedThree, (LivingEntity)ownerEntity)) {
            speedChance += speedChancePerTier * 2;
        }
        return speedChance;
    }

    public static void onHitEffects(Player ownerEntity, int speedChance, LivingEntity le) {
        int dischargeSpeedDuration = SimplySkills.wizardConfig.signatureWizardStaticDischargeSpeedDuration;
        int staticDischargeSpeedStacks = SimplySkills.wizardConfig.signatureWizardStaticDischargeSpeedStacks;
        int staticDischargeSpeedMaxAmplifier = SimplySkills.wizardConfig.signatureWizardStaticDischargeSpeedMaxAmplifier;
        if (HelperMethods.isUnlocked("simplyskills:wizard", SkillReferencePosition.wizardSpecialisationStaticDischargeSpeed, (LivingEntity)ownerEntity) && ownerEntity.m_217043_().m_188503_(100) < speedChance) {
            HelperMethods.incrementStatusEffect((LivingEntity)ownerEntity, MobEffects.f_19596_, dischargeSpeedDuration, staticDischargeSpeedStacks, staticDischargeSpeedMaxAmplifier);
        }
        if (HelperMethods.isUnlocked("simplyskills:wizard", SkillReferencePosition.wizardSpecialisationStaticDischargeLightningOrb, (LivingEntity)ownerEntity) && ownerEntity.m_217043_().m_188503_(100) < speedChance / 2) {
            SignatureAbilities.castSpellEngineIndirectTarget(ownerEntity, "simplyskills:lightning_ball_homing", 3, (Entity)le, HelperMethods.getBlockLookingAt(ownerEntity, 256));
        }
    }

    public void m_6385_(LivingEntity entity, AttributeMap attributes, int amplifier) {
        if (!entity.m_9236_().m_5776_()) {
            AABB box = HelperMethods.createBox((Entity)entity, 80);
            for (Entity entities : entity.m_9236_().m_6249_((Entity)entity, box, EntitySelector.f_20403_)) {
                Player pe;
                if (entities == null || !(entities instanceof Player) || !HelperMethods.isUnlocked("simplyskills:wizard", SkillReferencePosition.wizardSpecialisationStaticDischargeLeap, (LivingEntity)(pe = (Player)entities))) continue;
                this.ownerEntity = pe;
                break;
            }
        }
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }
}

