/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.effects;

import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyskills.abilities.AscendancyAbilities;
import net.sweenus.simplyskills.abilities.SignatureAbilities;
import net.sweenus.simplyskills.abilities.compat.SimplySwordsGemEffects;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.registry.SoundRegistry;
import net.sweenus.simplyskills.util.HelperMethods;

public class SkywardSunderEffect
extends MobEffect {
    public SkywardSunderEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
    }

    public void m_6742_(LivingEntity livingEntity, int amplifier) {
        ServerPlayer player;
        if (!livingEntity.m_9236_().m_5776_() && livingEntity instanceof ServerPlayer && (player = (ServerPlayer)livingEntity).m_21023_(EffectRegistry.SKYWARDSUNDER)) {
            MobEffectInstance skywardSunder = player.m_21124_(EffectRegistry.SKYWARDSUNDER);
            if (skywardSunder == null) {
                return;
            }
            double bullrushVelocity = 0.1 * (double)(46 - skywardSunder.m_19557_());
            int bullrushRadius = 2;
            double damageModifier = 0.9 + 0.03 * (double)AscendancyAbilities.getAscendancyPoints((Player)player);
            int slash_1 = 30;
            int slash_2 = 15;
            if (skywardSunder.m_19557_() > slash_1) {
                player.m_20256_(livingEntity.m_20154_().m_82490_(bullrushVelocity));
                player.m_20334_(livingEntity.m_20184_().f_82479_, 0.0, livingEntity.m_20184_().f_82481_);
                player.f_19864_ = true;
            }
            if (skywardSunder.m_19557_() == slash_1 + 12) {
                SignatureAbilities.castSpellEngineIndirectTarget((Player)player, "simplyskills:skyward_sunder", 3, (Entity)player, null);
                player.m_9236_().m_6269_(null, (Entity)player, SoundRegistry.OBJECT_IMPACT_THUD_REPEAT, SoundSource.PLAYERS, 0.6f, 1.0f);
            }
            if (skywardSunder.m_19557_() == slash_1) {
                player.m_20334_(0.0, 1.2, 0.0);
                player.f_19864_ = true;
            }
            if (skywardSunder.m_19557_() == slash_2) {
                player.m_20334_(0.0, -1.2, 0.0);
                player.f_19864_ = true;
            }
            if (skywardSunder.m_19557_() == slash_2 + 5) {
                SignatureAbilities.castSpellEngineIndirectTarget((Player)player, "simplyskills:skyward_sunder_slam", 3, (Entity)player, null);
            }
            if (skywardSunder.m_19557_() == slash_2 - 2) {
                player.m_9236_().m_6269_(null, (Entity)player, SoundRegistry.DAMAGE_03, SoundSource.PLAYERS, 0.8f, 1.0f);
            }
            if (skywardSunder.m_19557_() == 12) {
                player.m_9236_().m_6269_(null, (Entity)player, SoundRegistry.SPELL_EARTH_PUNCH, SoundSource.PLAYERS, 0.6f, 1.0f);
            }
            if (skywardSunder.m_19557_() == 2) {
                HelperMethods.spawnParticlesPlane(player.m_9236_(), (ParticleOptions)ParticleTypes.f_123778_, player.m_20183_(), bullrushRadius, 0.0, 1.0, 0.0);
                HelperMethods.spawnParticlesPlane(player.m_9236_(), (ParticleOptions)ParticleTypes.f_123759_, player.m_20183_(), bullrushRadius, 0.0, 1.0, 0.0);
            }
            double damage = HelperMethods.getHighestAttributeValue((Player)player) * damageModifier;
            AABB box = new AABB(player.m_20185_() + (double)bullrushRadius, player.m_20186_() + (double)bullrushRadius, player.m_20189_() + (double)bullrushRadius, player.m_20185_() - (double)bullrushRadius, player.m_20186_() - (double)bullrushRadius, player.m_20189_() - (double)bullrushRadius);
            for (Entity entities : livingEntity.m_9236_().m_6249_((Entity)livingEntity, box, EntitySelector.f_20403_)) {
                LivingEntity le;
                if (entities == null) continue;
                if (entities instanceof LivingEntity && HelperMethods.checkFriendlyFire(le = (LivingEntity)entities, (Player)player) && (skywardSunder.m_19557_() == 1 || skywardSunder.m_19557_() == slash_2 || skywardSunder.m_19557_() == slash_1)) {
                    le.f_19802_ = 0;
                    le.m_6469_(player.m_269291_().m_269075_((Player)player), (float)damage);
                    le.f_19802_ = 0;
                    le.m_20334_(player.m_20184_().f_82479_, player.m_20184_().f_82480_, player.m_20184_().f_82481_);
                    le.f_19864_ = true;
                    HelperMethods.spawnParticlesPlane(player.m_9236_(), (ParticleOptions)ParticleTypes.f_123796_, player.m_20183_(), bullrushRadius - 1, 0.0, 1.0, 0.0);
                }
                if (!(entities instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entities, (Player)player) || skywardSunder.m_19557_() <= slash_1 || skywardSunder.m_19557_() % 2 != 0) continue;
                if (AscendancyAbilities.getAscendancyPoints((Player)player) > 30) {
                    le.m_7292_(new MobEffectInstance(EffectRegistry.DEATHMARK, 60, 0));
                }
                le.f_19802_ = 0;
                le.m_6469_(player.m_269291_().m_269075_((Player)player), 0.5f);
                le.f_19802_ = 0;
                le.m_20334_(player.m_20184_().f_82479_, player.m_20184_().f_82480_, player.m_20184_().f_82481_);
                le.f_19864_ = true;
            }
        }
        super.m_6742_(livingEntity, amplifier);
    }

    public void m_6386_(LivingEntity entity, AttributeMap attributes, int amplifier) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (FabricLoader.getInstance().isModLoaded("simplyswords")) {
                SimplySwordsGemEffects.warStandard(player);
            }
        }
        super.m_6386_(entity, attributes, amplifier);
    }

    public void m_6385_(LivingEntity entity, AttributeMap attributes, int amplifier) {
        MobEffectInstance mightEffect;
        Player player;
        if (!entity.m_9236_().m_5776_() && entity instanceof Player && (player = (Player)entity).m_21023_(EffectRegistry.MIGHT) && (mightEffect = player.m_21124_(EffectRegistry.MIGHT)) != null) {
            HelperMethods.incrementStatusEffect((LivingEntity)player, EffectRegistry.BARRIER, mightEffect.m_19557_(), mightEffect.m_19564_(), 9);
        }
        super.m_6385_(entity, attributes, amplifier);
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }
}

