/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.effects;

import java.util.Objects;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;
import net.sweenus.simplyskills.abilities.NecromancerAbilities;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.util.HelperMethods;
import org.jetbrains.annotations.Nullable;

public class ShadowAuraEffect
extends MobEffect {
    public ShadowAuraEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
    }

    public void m_6742_(LivingEntity livingEntity, int amplifier) {
        if (!livingEntity.m_9236_().m_5776_()) {
            HelperMethods.spawnOrbitParticles((ServerLevel)livingEntity.m_9236_(), livingEntity.m_20182_(), (ParticleOptions)ParticleTypes.f_123762_, 0.5, 3);
            if (livingEntity.f_19797_ % Math.max(22 - amplifier * 2, 1) == 0) {
                int radius = 2;
                AABB box = HelperMethods.createBox((Entity)livingEntity, radius);
                Player effectivePlayer = ShadowAuraEffect.getPlayerEntity(livingEntity);
                livingEntity.m_9236_().m_6249_((Entity)livingEntity, box, EntitySelector.f_20403_).stream().filter(Objects::nonNull).filter(entity -> entity instanceof LivingEntity).forEach(entity -> {
                    LivingEntity le = (LivingEntity)entity;
                    if (effectivePlayer != null && HelperMethods.checkFriendlyFire(le, effectivePlayer)) {
                        le.f_19802_ = 0;
                        le.m_6469_(effectivePlayer.m_9236_().m_269111_().m_269104_((Entity)effectivePlayer, (Entity)effectivePlayer), (float)SpellPower.getSpellPower((SpellSchool)SpellSchools.SOUL, (LivingEntity)effectivePlayer).randomValue() * ((float)amplifier / 5.0f));
                        HelperMethods.spawnWaistHeightParticles((ServerLevel)livingEntity.m_9236_(), (ParticleOptions)ParticleTypes.f_123762_, (Entity)livingEntity, (Entity)le, 5);
                        le.f_19802_ = 0;
                    }
                });
                if (effectivePlayer != null) {
                    float damage = 1.0f + (float)SpellPower.getSpellPower((SpellSchool)SpellSchools.SOUL, (LivingEntity)effectivePlayer).randomValue() * ((float)amplifier / 10.0f);
                    if (livingEntity.m_21223_() - damage * 2.0f < 0.0f && livingEntity instanceof TamableAnimal) {
                        TamableAnimal minion = (TamableAnimal)livingEntity;
                        NecromancerAbilities.effectShadowCombust(effectivePlayer, minion);
                        minion.m_21195_(EffectRegistry.SHADOWAURA);
                    } else {
                        livingEntity.m_21153_(livingEntity.m_21223_() - damage);
                    }
                }
            }
        }
        super.m_6742_(livingEntity, amplifier);
    }

    @Nullable
    private static Player getPlayerEntity(LivingEntity livingEntity) {
        LivingEntity owner;
        ServerPlayer effectivePlayer = null;
        if (livingEntity instanceof ServerPlayer) {
            effectivePlayer = (ServerPlayer)livingEntity;
        } else if (livingEntity instanceof TamableAnimal && (owner = ((TamableAnimal)livingEntity).m_269323_()) instanceof ServerPlayer) {
            effectivePlayer = (ServerPlayer)owner;
        }
        return effectivePlayer;
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }
}

