/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.effects;

import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyskills.abilities.AscendancyAbilities;
import net.sweenus.simplyskills.abilities.compat.SimplySwordsGemEffects;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.util.HelperMethods;

public class CyclonicCleaveEffect
extends MobEffect {
    public CyclonicCleaveEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
    }

    public void m_6742_(LivingEntity livingEntity, int amplifier) {
        ServerPlayer player;
        if (!livingEntity.m_9236_().m_5776_() && livingEntity instanceof ServerPlayer && (player = (ServerPlayer)livingEntity).m_21023_(EffectRegistry.CYCLONICCLEAVE)) {
            MobEffectInstance cyclonicCleave = player.m_21124_(EffectRegistry.CYCLONICCLEAVE);
            if (cyclonicCleave == null) {
                return;
            }
            double bullrushVelocity = 0.05 * (double)(39 - cyclonicCleave.m_19557_());
            int bullrushRadius = 2;
            double damageModifier = 0.8 + 0.03 * (double)AscendancyAbilities.getAscendancyPoints((Player)player);
            int bullrushHitFrequency = 5;
            if (cyclonicCleave.m_19557_() % 5 == 0 && cyclonicCleave.m_19557_() < 25) {
                player.m_9236_().m_6269_(null, (Entity)player, SoundEvents.f_12316_, SoundSource.PLAYERS, 1.0f, 1.1f);
            }
            if (cyclonicCleave.m_19557_() > 10) {
                player.m_20256_(livingEntity.m_20154_().m_82490_(bullrushVelocity));
                player.m_20334_(livingEntity.m_20184_().f_82479_, 0.0, livingEntity.m_20184_().f_82481_);
                player.f_19864_ = true;
            }
            double damage = FabricLoader.getInstance().isModLoaded("prominent") ? (player.m_21133_(Attributes.f_22281_) + player.m_21133_(Attributes.f_22283_)) * damageModifier : HelperMethods.getHighestAttributeValue((Player)player) * damageModifier;
            AABB box = HelperMethods.createBox((Entity)player, bullrushRadius);
            for (Entity entities : livingEntity.m_9236_().m_6249_((Entity)livingEntity, box, EntitySelector.f_20403_)) {
                LivingEntity le;
                if (entities == null || cyclonicCleave.m_19557_() >= 30 || !(entities instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entities, (Player)player)) continue;
                if (AscendancyAbilities.getAscendancyPoints((Player)player) > 29) {
                    le.m_20334_((player.m_20185_() - le.m_20185_()) / 4.0, (player.m_20186_() - le.m_20186_()) / 4.0, (player.m_20189_() - le.m_20189_()) / 4.0);
                }
                if (cyclonicCleave.m_19557_() % bullrushHitFrequency != 0) continue;
                le.f_19802_ = 0;
                le.m_6469_(player.m_269291_().m_269075_((Player)player), (float)damage);
                le.f_19802_ = 0;
                SimpleParticleType particleType = ParticleTypes.f_123796_;
                if (FabricLoader.getInstance().isModLoaded("prominent")) {
                    particleType = ParticleTypes.f_123760_;
                }
                HelperMethods.spawnParticlesPlane(player.m_9236_(), (ParticleOptions)particleType, player.m_20183_(), bullrushRadius - 1, 0.0, 1.0, 0.0);
            }
        }
        super.m_6742_(livingEntity, amplifier);
    }

    public void m_6386_(LivingEntity entity, AttributeMap attributes, int amplifier) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (FabricLoader.getInstance().isModLoaded("simplyswords")) {
                SimplySwordsGemEffects.warStandard(player);
            }
        }
        super.m_6386_(entity, attributes, amplifier);
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }
}

