/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.effects;

import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;
import net.sweenus.simplyskills.abilities.AscendancyAbilities;
import net.sweenus.simplyskills.abilities.SignatureAbilities;
import net.sweenus.simplyskills.abilities.compat.SimplySwordsGemEffects;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.registry.SoundRegistry;
import net.sweenus.simplyskills.util.HelperMethods;

public class CataclysmEffect
extends MobEffect {
    public CataclysmEffect(MobEffectCategory statusEffectCategory, int color) {
        super(statusEffectCategory, color);
    }

    public void m_6742_(LivingEntity livingEntity, int amplifier) {
        ServerPlayer player;
        if (!livingEntity.m_9236_().m_5776_() && livingEntity instanceof ServerPlayer && (player = (ServerPlayer)livingEntity).m_21023_(EffectRegistry.CATACLYSM)) {
            MobEffectInstance cataclysmEffect = player.m_21124_(EffectRegistry.CATACLYSM);
            if (cataclysmEffect == null) {
                return;
            }
            String spellId = "simplyskills:cataclysm_comet";
            if (SpellPower.getSpellPower((SpellSchool)SpellSchools.FIRE, (LivingEntity)player).baseValue() > SpellPower.getSpellPower((SpellSchool)SpellSchools.FROST, (LivingEntity)player).baseValue()) {
                spellId = "simplyskills:cataclysm_meteor";
            }
            int initialDuration = 90;
            int distanceIncrement = 5;
            int frequency = 20 - Math.min(12, AscendancyAbilities.getAscendancyPoints((Player)player) / 10);
            int currentDistance = (initialDuration - cataclysmEffect.m_19557_()) / frequency * distanceIncrement;
            if (cataclysmEffect.m_19557_() % frequency == 0) {
                player.m_9236_().m_6269_(null, (Entity)player, SoundRegistry.SPELL_ENERGY, SoundSource.PLAYERS, 0.5f, 1.1f);
                Vec3 lookVector = player.m_20252_(1.0f);
                Vec3 spellPosition = player.m_20182_().m_82549_(lookVector.m_82542_((double)currentDistance, 0.0, (double)currentDistance));
                BlockPos castPosition = new BlockPos((int)spellPosition.f_82479_, (int)spellPosition.f_82480_, (int)spellPosition.f_82481_);
                SignatureAbilities.castSpellEngineIndirectTarget((Player)player, spellId, 45, null, castPosition);
                if (AscendancyAbilities.getAscendancyPoints((Player)player) > 29) {
                    HelperMethods.incrementStatusEffect((LivingEntity)player, EffectRegistry.SPELLFORGED, 60, 1, 10);
                }
            }
        }
        super.m_6742_(livingEntity, amplifier);
    }

    public void m_6386_(LivingEntity entity, AttributeMap attributes, int amplifier) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (FabricLoader.getInstance().isModLoaded("simplyswords")) {
                SimplySwordsGemEffects.warStandard(player);
            }
        }
        super.m_6386_(entity, attributes, amplifier);
    }

    public boolean m_6584_(int duration, int amplifier) {
        return true;
    }
}

