/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.client.effects;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.spell_engine.api.effect.CustomModelStatusEffect;
import net.spell_engine.api.render.CustomModels;

public class OrbitingRotatingEffectRenderer
implements CustomModelStatusEffect.Renderer {
    public float speed = 16.25f;
    private final List<Model> models;
    private final float scale;
    private final float horizontalOffset;

    public void setSpeed(float newSpeed) {
        this.speed = newSpeed;
    }

    public OrbitingRotatingEffectRenderer(List<Model> models, float scale, float horizontalOffset) {
        this.models = models;
        this.scale = scale;
        this.horizontalOffset = horizontalOffset;
    }

    public void renderEffect(int amplifier, LivingEntity livingEntity, float delta, PoseStack matrixStack, MultiBufferSource vertexConsumers, int light) {
        matrixStack.m_85836_();
        float time = (float)livingEntity.m_9236_().m_46467_() + delta;
        float initialAngle = time * this.speed - 45.0f;
        float horizontalOffset = this.horizontalOffset * livingEntity.m_6134_();
        float verticalOffset = livingEntity.m_20206_() / 2.0f;
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        int stacks = amplifier + 1;
        float turnAngle = 360.0f / (float)stacks;
        for (int i = 0; i < stacks; ++i) {
            float angle = initialAngle + turnAngle * (float)i;
            this.renderModel(matrixStack, this.scale, verticalOffset, horizontalOffset, angle, itemRenderer, vertexConsumers, light, livingEntity);
        }
        matrixStack.m_85849_();
    }

    private void renderModel(PoseStack matrixStack, float scale, float verticalOffset, float horizontalOffset, float rotation, ItemRenderer itemRenderer, MultiBufferSource vertexConsumers, int light, LivingEntity livingEntity) {
        matrixStack.m_85836_();
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(rotation));
        matrixStack.m_252880_(0.0f, verticalOffset, -horizontalOffset);
        matrixStack.m_85841_(scale, scale, scale);
        float selfRotationSpeed = 10.0f;
        float selfRotationAngle = ((float)livingEntity.f_19797_ + Minecraft.m_91087_().m_91296_()) * selfRotationSpeed;
        matrixStack.m_252781_(Axis.f_252436_.m_252977_(selfRotationAngle));
        for (Model model : this.models) {
            matrixStack.m_85836_();
            CustomModels.render((RenderType)model.layer(), (ItemRenderer)itemRenderer, (ResourceLocation)model.modelId(), (PoseStack)matrixStack, (MultiBufferSource)vertexConsumers, (int)light, (int)livingEntity.m_19879_());
            matrixStack.m_85849_();
        }
        matrixStack.m_85849_();
    }

    public record Model(RenderType layer, ResourceLocation modelId) {
    }
}

