/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.abilities.compat;

import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.SwordItem;
import net.sweenus.simplyskills.abilities.compat.SimplySwordsRequiredMethods;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.registry.SoundRegistry;

public class SimplySwordsGemEffects {
    public static boolean passVersionCheck() {
        if (FabricLoader.getInstance().isModLoaded("simplyswords")) {
            if (FabricLoader.getInstance().getModContainer("simplyswords").isPresent()) {
                String blacklistedVersion1 = "1.50";
                String blacklistedVersion2 = "1.48";
                String version = ((ModContainer)FabricLoader.getInstance().getModContainer("simplyswords").get()).getMetadata().getVersion().toString();
                if (version.contains(blacklistedVersion1) || version.contains(blacklistedVersion2)) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static void doGenericAbilityGemEffects(Player user) {
        if (FabricLoader.getInstance().isModLoaded("simplyswords") && SimplySwordsGemEffects.passVersionCheck()) {
            int procChance;
            String allNetherEffects;
            String mainHandNetherEffect = "";
            String offHandNetherEffect = "";
            if (user.m_21205_().m_41720_() instanceof SwordItem) {
                mainHandNetherEffect = user.m_21205_().m_41784_().m_128461_("nether_power");
            }
            if (user.m_21206_().m_41720_() instanceof SwordItem) {
                offHandNetherEffect = user.m_21206_().m_41784_().m_128461_("nether_power");
            }
            if ((allNetherEffects = offHandNetherEffect + mainHandNetherEffect).contains("precise")) {
                procChance = SimplySwordsRequiredMethods.preciseChance;
                if (user.m_217043_().m_188503_(100) < procChance) {
                    user.m_7292_(new MobEffectInstance(EffectRegistry.PRECISION, 200, 5, false, false, true));
                    SimplySwordsGemEffects.doSound(user);
                }
            }
            if (allNetherEffects.contains("mighty")) {
                procChance = SimplySwordsRequiredMethods.mightyChance;
                if (user.m_217043_().m_188503_(100) < procChance) {
                    user.m_7292_(new MobEffectInstance(EffectRegistry.MIGHT, 200, 3, false, false, true));
                    SimplySwordsGemEffects.doSound(user);
                }
            }
            if (allNetherEffects.contains("stealthy")) {
                procChance = SimplySwordsRequiredMethods.stealthyChance;
                if (user.m_217043_().m_188503_(100) < procChance) {
                    user.m_7292_(new MobEffectInstance(EffectRegistry.STEALTH, 600, 0, false, false, true));
                    SimplySwordsGemEffects.doSound(user);
                }
            }
        }
    }

    public static boolean doSignatureGemEffects(Player user, String nether_power) {
        if (FabricLoader.getInstance().isModLoaded("simplyswords") && SimplySwordsGemEffects.passVersionCheck()) {
            String mainHandNetherEffect = "";
            String offHandNetherEffect = "";
            if (user.m_21205_().m_41720_() instanceof SwordItem) {
                mainHandNetherEffect = user.m_21205_().m_41784_().m_128461_("nether_power");
            }
            if (user.m_21206_().m_41720_() instanceof SwordItem && !nether_power.contains("spellforged")) {
                offHandNetherEffect = user.m_21206_().m_41784_().m_128461_("nether_power");
            }
            String allNetherEffects = offHandNetherEffect + mainHandNetherEffect;
            return allNetherEffects.contains(nether_power);
        }
        return false;
    }

    public static void doSound(Player user) {
        user.m_9236_().m_6269_(null, (Entity)user, SoundRegistry.FX_UI_UNLOCK3, SoundSource.PLAYERS, 1.0f, 1.6f);
    }

    public static int renewed(Player player, int cooldown, int minimumCD) {
        if (SimplySwordsGemEffects.doSignatureGemEffects(player, "renewed")) {
            int procChance = SimplySwordsRequiredMethods.renewedChance;
            if (player.m_217043_().m_188503_(100) < procChance) {
                SimplySwordsGemEffects.doSound(player);
                return minimumCD;
            }
        }
        return cooldown;
    }

    public static int accelerant(Player player, int cooldown, int minimumCD) {
        if (SimplySwordsGemEffects.doSignatureGemEffects(player, "accelerant")) {
            SimplySwordsGemEffects.doSound(player);
            return cooldown - 12000;
        }
        return cooldown;
    }

    public static void spellshield(Player player) {
        if (SimplySwordsGemEffects.doSignatureGemEffects(player, "spellshield")) {
            int procChance = SimplySwordsRequiredMethods.spellshieldChance;
            if (player.m_217043_().m_188503_(100) < procChance) {
                player.m_7292_(new MobEffectInstance(EffectRegistry.BARRIER, 100, 0, false, false, true));
                SimplySwordsGemEffects.doSound(player);
            }
        }
    }

    public static void spellforged(Player player) {
        if (player.f_19797_ % 20 == 0 && SimplySwordsGemEffects.doSignatureGemEffects(player, "spellforged")) {
            player.m_7292_(new MobEffectInstance(EffectRegistry.SPELLFORGED, 25, 0, false, false, true));
        }
    }

    public static void soulshock(Player player) {
        if (player.f_19797_ % 20 == 0 && SimplySwordsGemEffects.doSignatureGemEffects(player, "soulshock")) {
            player.m_7292_(new MobEffectInstance(EffectRegistry.SOULSHOCK, 25, 0, false, false, true));
        }
    }

    public static void spellStandard(Player user) {
        if (SimplySwordsGemEffects.doSignatureGemEffects(user, "spell_Standard")) {
            SimplySwordsRequiredMethods.spawnSpellStandard(user);
        }
    }

    public static void warStandard(Player user) {
        if (SimplySwordsGemEffects.doSignatureGemEffects(user, "war_standard")) {
            SimplySwordsRequiredMethods.spawnWarStandard(user);
            SimplySwordsGemEffects.doSound(user);
        }
    }

    public static void deception(Player user) {
        if (SimplySwordsGemEffects.doSignatureGemEffects(user, "deception")) {
            int chance = SimplySwordsRequiredMethods.deceptionChance;
            if (user.m_217043_().m_188503_(100) < chance && user.m_21023_(EffectRegistry.REVEALED)) {
                user.m_21195_(EffectRegistry.REVEALED);
                SimplySwordsGemEffects.doSound(user);
            }
        }
    }
}

