/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.abilities;

import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.CrossbowItem;
import net.sweenus.simplyskills.SimplySkills;
import net.sweenus.simplyskills.abilities.RogueAbilities;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.registry.SoundRegistry;
import net.sweenus.simplyskills.util.HelperMethods;
import net.sweenus.simplyskills.util.SkillReferencePosition;

public class WayfarerAbilities {
    public static void passiveWayfarerBreakStealth(Entity target, Player player, Boolean brokenByDamage, Boolean backstabBonus) {
        if (player.m_21023_(EffectRegistry.STEALTH)) {
            if (brokenByDamage.booleanValue()) {
                int speedDuration = SimplySkills.rogueConfig.passiveRogueFleetfootedSpeedDuration;
                int speedStacks = SimplySkills.rogueConfig.passiveRogueFleetfootedSpeedStacks;
                int speedMaxStacks = SimplySkills.rogueConfig.passiveRogueFleetfootedSpeedMaxStacks;
                int evasionDuration = SimplySkills.wayfarerConfig.passiveWayfarerReflexiveEvasionDuration;
                int evasionChance = SimplySkills.wayfarerConfig.passiveWayfarerReflexiveChance;
                if (HelperMethods.isUnlocked("simplyskills:rogue", SkillReferencePosition.rogueFleetfooted, (LivingEntity)player)) {
                    HelperMethods.incrementStatusEffect((LivingEntity)player, MobEffects.f_19596_, speedDuration, speedStacks, speedMaxStacks);
                }
                if (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.wayfarerReflexive, (LivingEntity)player) && player.m_217043_().m_188503_(100) < evasionChance) {
                    HelperMethods.incrementStatusEffect((LivingEntity)player, EffectRegistry.EVASION, evasionDuration, 1, 1);
                }
            }
            if (!brokenByDamage.booleanValue()) {
                if (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.wayfarerReflexive, (LivingEntity)player)) {
                    HelperMethods.incrementStatusEffect((LivingEntity)player, EffectRegistry.MIGHT, 40, 1, 20);
                    HelperMethods.incrementStatusEffect((LivingEntity)player, EffectRegistry.MARKSMANSHIP, 40, 1, 20);
                }
                if (target != null && target instanceof LivingEntity) {
                    LivingEntity livingTarget = (LivingEntity)target;
                    int deathmarkDuration = SimplySkills.rogueConfig.passiveRogueExploitationDeathMarkDuration;
                    int deathmarkStacks = SimplySkills.rogueConfig.passiveRogueExploitationDeathMarkStacks;
                    if (backstabBonus.booleanValue() && HelperMethods.isBehindTarget((LivingEntity)player, livingTarget)) {
                        if (HelperMethods.isUnlocked("simplyskills:rogue", SkillReferencePosition.rogueExploitation, (LivingEntity)player)) {
                            HelperMethods.incrementStatusEffect(livingTarget, EffectRegistry.DEATHMARK, deathmarkDuration, deathmarkStacks, 3);
                        }
                        if (HelperMethods.isUnlocked("simplyskills:rogue", SkillReferencePosition.rogueOpportunisticMastery, (LivingEntity)player)) {
                            RogueAbilities.passiveRogueOpportunisticMastery((Entity)livingTarget, player);
                        }
                    }
                }
            }
            player.m_21195_(EffectRegistry.STEALTH);
            player.m_9236_().m_6269_(null, (Entity)player, SoundRegistry.SOUNDEFFECT36, SoundSource.PLAYERS, 0.7f, 1.4f);
            if (player.m_21023_(MobEffects.f_19609_)) {
                player.m_21195_(MobEffects.f_19609_);
            }
            player.m_7292_(new MobEffectInstance(EffectRegistry.REVEALED, 180, 5, false, false, true));
        }
    }

    public static void passiveWayfarerGuarding(Player player) {
        int barrierFrequency = SimplySkills.wayfarerConfig.passiveWayfarerGuardingBarrierFrequency;
        int barrierDuration = SimplySkills.wayfarerConfig.passiveWayfarerGuardingBarrierDuration;
        int barrierStacks = SimplySkills.wayfarerConfig.passiveWayfarerGuardingBarrierStacks;
        int barrierMaxStacks = SimplySkills.wayfarerConfig.passiveWayfarerGuardingBarrierMaxStacks;
        if (player.m_21206_().m_41720_() instanceof CrossbowItem && player.f_19797_ % barrierFrequency == 0) {
            HelperMethods.incrementStatusEffect((LivingEntity)player, EffectRegistry.BARRIER, barrierDuration, barrierStacks, barrierMaxStacks);
        }
    }

    public static void passiveWayfarerSlender(Player player) {
        int slenderArmorThreshold = SimplySkills.wayfarerConfig.passiveWayfarerSlenderArmorThreshold;
        int frailArmorThreshold = SimplySkills.initiateConfig.passiveInitiateFrailArmorThreshold;
        if (player.f_19797_ % 20 == 0) {
            int buffAmplifier;
            int armorValue = player.m_21230_();
            if (armorValue < slenderArmorThreshold && (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.roguePath, (LivingEntity)player) || HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.rangerPath, (LivingEntity)player))) {
                buffAmplifier = (slenderArmorThreshold - armorValue) / 5;
                player.m_7292_(new MobEffectInstance(EffectRegistry.AGILE, 25, buffAmplifier, false, false, false));
            }
            if (armorValue < frailArmorThreshold && HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.wizardPath, (LivingEntity)player)) {
                buffAmplifier = (frailArmorThreshold - armorValue) / 5;
                player.m_7292_(new MobEffectInstance(EffectRegistry.AGILE, 25, buffAmplifier, false, false, false));
            }
        }
    }
}

