/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.abilities;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.entity.SpellProjectile;
import net.spell_engine.internals.SpellHelper;
import net.sweenus.simplyskills.SimplySkills;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.util.HelperMethods;
import net.sweenus.simplyskills.util.SkillReferencePosition;

public class RangerAbilities {
    public static void passiveRangerReveal(Player player) {
        int frequency = SimplySkills.rangerConfig.passiveRangerRevealFrequency;
        if (player.f_19797_ % frequency == 0) {
            int radius = SimplySkills.rangerConfig.passiveRangerRevealRadius;
            AABB box = HelperMethods.createBox((Entity)player, radius);
            block0: for (Entity entities : player.m_9236_().m_6249_((Entity)player, box, EntitySelector.f_20403_)) {
                LivingEntity le;
                if (entities == null || !(entities instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entities, player)) continue;
                for (MobEffectInstance statusEffect : le.m_21220_()) {
                    if (statusEffect == null || !statusEffect.m_19544_().equals(EffectRegistry.STEALTH)) continue;
                    le.m_21195_(statusEffect.m_19544_());
                    le.m_7292_(new MobEffectInstance(EffectRegistry.REVEALED, 180, 1, false, false, true));
                    continue block0;
                }
            }
        }
    }

    public static boolean isOwnPet(Entity entity, Player player) {
        OwnableEntity te;
        if (entity instanceof OwnableEntity && (te = (OwnableEntity)entity).m_269323_() != null) {
            return Objects.equals(te.m_21805_(), player.m_20148_());
        }
        return false;
    }

    public static void passiveRangerTamer(Player player) {
        int frequency = SimplySkills.rangerConfig.passiveRangerTamerFrequency;
        if (player.f_19797_ % frequency == 0) {
            int radius = SimplySkills.rangerConfig.passiveRangerTamerRadius;
            int resistanceAmplifier = SimplySkills.rangerConfig.passiveRangerTamerResistanceAmplifier;
            int regenerationAmplifier = SimplySkills.rangerConfig.passiveRangerTamerRegenerationAmplifier;
            AABB box = HelperMethods.createBox((Entity)player, radius);
            for (Entity entities : player.m_9236_().m_6249_((Entity)player, box, EntitySelector.f_20403_)) {
                if (entities == null || !(entities instanceof LivingEntity)) continue;
                LivingEntity le = (LivingEntity)entities;
                if (!RangerAbilities.isOwnPet(entities, player)) continue;
                le.m_7292_(new MobEffectInstance(MobEffects.f_19605_, frequency + 5, regenerationAmplifier, false, false, true));
                le.m_7292_(new MobEffectInstance(MobEffects.f_19606_, frequency + 5, resistanceAmplifier, false, false, true));
            }
        }
    }

    public static void passiveRangerBonded(Player player) {
        int frequency = SimplySkills.rangerConfig.passiveRangerBondedFrequency;
        if (player.f_19797_ % frequency == 0) {
            int radius = SimplySkills.rangerConfig.passiveRangerBondedRadius;
            int petMinimumHealthPercent = SimplySkills.rangerConfig.passiveRangerBondedPetMinimumHealthPercent;
            int healthTransferAmount = SimplySkills.rangerConfig.passiveRangerBondedHealthTransferAmount;
            AABB box = HelperMethods.createBox((Entity)player, radius);
            for (Entity entities : player.m_9236_().m_6249_((Entity)player, box, EntitySelector.f_20403_)) {
                float playerHealthPercent;
                float teHealthPercent;
                if (entities == null || !(entities instanceof LivingEntity)) continue;
                LivingEntity le = (LivingEntity)entities;
                if (!RangerAbilities.isOwnPet(entities, player) || !((teHealthPercent = le.m_21223_() / le.m_21233_() * 100.0f) > (playerHealthPercent = player.m_21223_() / player.m_21233_() * 100.0f)) || !(teHealthPercent > (float)petMinimumHealthPercent)) continue;
                le.m_21153_(le.m_21223_() - (float)healthTransferAmount);
                player.m_5634_((float)healthTransferAmount);
            }
        }
    }

    public static void passiveRangerTrained(Player player) {
        int frequency = SimplySkills.rangerConfig.passiveRangerTrainedFrequency;
        if (player.f_19797_ % frequency == 0) {
            int radius = SimplySkills.rangerConfig.passiveRangerTrainedRadius;
            int strengthAmplifier = SimplySkills.rangerConfig.passiveRangerTrainedStrengthAmplifier;
            int speedAmplifier = SimplySkills.rangerConfig.passiveRangerTrainedSpeedAmplifier;
            int minimumHealthPercent = SimplySkills.rangerConfig.passiveRangerTrainedMinimumHealthPercent;
            AABB box = HelperMethods.createBox((Entity)player, radius);
            for (Entity entities : player.m_9236_().m_6249_((Entity)player, box, EntitySelector.f_20403_)) {
                float teHealthPercent;
                if (entities == null || !(entities instanceof LivingEntity)) continue;
                LivingEntity le = (LivingEntity)entities;
                if (!RangerAbilities.isOwnPet(entities, player) || !((teHealthPercent = le.m_21223_() / le.m_21233_() * 100.0f) > (float)minimumHealthPercent)) continue;
                le.m_7292_(new MobEffectInstance(MobEffects.f_19600_, frequency + 5, strengthAmplifier, false, false, true));
                le.m_7292_(new MobEffectInstance(MobEffects.f_19596_, frequency + 5, speedAmplifier, false, false, true));
            }
        }
    }

    public static void passiveRangerIncognito(Player player) {
        int frequency = SimplySkills.rangerConfig.passiveRangerIncognitoFrequency;
        if (player.f_19797_ % frequency == 0) {
            int radius = SimplySkills.rangerConfig.passiveRangerIncognitoRadius;
            AABB box = HelperMethods.createBox((Entity)player, radius);
            for (Entity entities : player.m_9236_().m_6249_((Entity)player, box, EntitySelector.f_20403_)) {
                if (entities == null || !(entities instanceof LivingEntity)) continue;
                LivingEntity le = (LivingEntity)entities;
                if (!RangerAbilities.isOwnPet(entities, player) || !player.m_21023_(EffectRegistry.STEALTH)) continue;
                le.m_7292_(new MobEffectInstance(MobEffects.f_19609_, frequency + 5, 0, false, false, true));
            }
        }
    }

    public static void passiveRangerElementalArrowsRenewal(Player player) {
        int random = new Random().nextInt(100);
        int renewalChance = SimplySkills.rangerConfig.passiveRangerElementalArrowsRenewalChance;
        int renewalDuration = SimplySkills.rangerConfig.passiveRangerElementalArrowsRenewalDuration;
        int renewalMaxStacks = SimplySkills.rangerConfig.passiveRangerElementalArrowsRenewalMaximumStacks;
        int renewalStacks = SimplySkills.rangerConfig.passiveRangerElementalArrowsRenewalStacks;
        if (random < renewalChance) {
            HelperMethods.incrementStatusEffect((LivingEntity)player, EffectRegistry.ELEMENTALARROWS, renewalDuration, renewalStacks, renewalMaxStacks);
        }
    }

    public static boolean signatureRangerDisengage(String rangerSkillTree, Player player) {
        int radius = SimplySkills.rangerConfig.signatureRangerDisengageRadius;
        int velocity = SimplySkills.rangerConfig.signatureRangerDisengageVelocity;
        int height = SimplySkills.rangerConfig.signatureRangerDisengageHeight;
        int slownessDuration = SimplySkills.rangerConfig.signatureRangerDisengageSlownessDuration;
        int slownessAmplifier = SimplySkills.rangerConfig.signatureRangerDisengageSlownessAmplifier;
        int slowFallDuration = SimplySkills.rangerConfig.signatureRangerDisengageSlowFallDuration;
        int slowFallAmplifier = SimplySkills.rangerConfig.signatureRangerDisengageSlowFallAmplifier;
        AABB box = HelperMethods.createBox((Entity)player, radius);
        for (Entity entities : player.m_9236_().m_6249_((Entity)player, box, EntitySelector.f_20403_)) {
            LivingEntity le;
            if (entities == null || !(entities instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entities, player)) continue;
            le.m_7292_(new MobEffectInstance(MobEffects.f_19597_, slownessDuration, slownessAmplifier, false, false, true));
        }
        player.m_20256_(player.m_20154_().m_82548_().m_82490_((double)velocity));
        player.m_20334_(player.m_20184_().f_82479_, (double)height, player.m_20184_().f_82481_);
        player.m_7292_(new MobEffectInstance(MobEffects.f_19591_, slowFallDuration, slowFallAmplifier, false, false, true));
        player.f_19864_ = true;
        if (HelperMethods.isUnlocked(rangerSkillTree, SkillReferencePosition.rangerSpecialisationDisengageRecuperate, (LivingEntity)player)) {
            RangerAbilities.signatureRangerDisengageRecuperate(player);
        }
        if (HelperMethods.isUnlocked(rangerSkillTree, SkillReferencePosition.rangerSpecialisationDisengageExploitation, (LivingEntity)player)) {
            RangerAbilities.signatureRangerDisengageExploitation(player);
        }
        if (HelperMethods.isUnlocked(rangerSkillTree, SkillReferencePosition.rangerSpecialisationDisengageMarksman, (LivingEntity)player)) {
            int marksmanDuration = SimplySkills.rangerConfig.signatureRangerDisengageMarksmanDuration;
            int marksmanStacks = SimplySkills.rangerConfig.signatureRangerDisengageMarksmanStacks;
            if (player.m_21205_().m_41720_() instanceof BowItem) {
                HelperMethods.incrementStatusEffect((LivingEntity)player, EffectRegistry.MARKSMAN, marksmanDuration, marksmanStacks, 99);
            } else {
                HelperMethods.incrementStatusEffect((LivingEntity)player, EffectRegistry.BARRIER, marksmanDuration, marksmanStacks, 6);
            }
        }
        return true;
    }

    public static void signatureRangerDisengageRecuperate(Player player) {
        int radius = SimplySkills.rangerConfig.signatureRangerDisengageRecuperateRadius;
        AABB box = HelperMethods.createBox((Entity)player, radius);
        for (Entity entities : player.m_9236_().m_6249_((Entity)player, box, EntitySelector.f_20403_)) {
            if (entities == null || !(entities instanceof LivingEntity)) continue;
            LivingEntity le = (LivingEntity)entities;
            if (!RangerAbilities.isOwnPet(entities, player)) continue;
            le.m_5634_(le.m_21233_());
        }
    }

    public static void signatureRangerDisengageExploitation(Player player) {
        int radius = SimplySkills.rangerConfig.signatureRangerDisengageExploitationRadius;
        int effectDuration = SimplySkills.rangerConfig.signatureRangerDisengageExploitationDuration;
        AABB box = HelperMethods.createBox((Entity)player, radius);
        for (Entity entities : player.m_9236_().m_6249_((Entity)player, box, EntitySelector.f_20403_)) {
            if (entities == null || !(entities instanceof LivingEntity)) continue;
            LivingEntity le = (LivingEntity)entities;
            if (!RangerAbilities.isOwnPet(entities, player)) continue;
            le.m_7292_(new MobEffectInstance(EffectRegistry.IMMOBILIZINGAURA, effectDuration, 0, false, false, true));
        }
    }

    public static boolean signatureRangerElementalArrows(String rangerSkillTree, Player player) {
        int elementalArrowsDuration = SimplySkills.rangerConfig.effectRangerElementalArrowsDuration;
        int elementalArrowsStacks = SimplySkills.rangerConfig.effectRangerElementalArrowsStacks;
        int elementalArrowsStacksIncreasePerTier = SimplySkills.rangerConfig.effectRangerElementalArrowsStacksIncreasePerTier;
        int amplifier = elementalArrowsStacks;
        if (HelperMethods.isUnlocked(rangerSkillTree, SkillReferencePosition.rangerSpecialisationElementalArrowsStacksOne, (LivingEntity)player)) {
            amplifier += elementalArrowsStacksIncreasePerTier;
        }
        if (HelperMethods.isUnlocked(rangerSkillTree, SkillReferencePosition.rangerSpecialisationElementalArrowsStacksTwo, (LivingEntity)player)) {
            amplifier += elementalArrowsStacksIncreasePerTier * 2;
        }
        if (HelperMethods.isUnlocked(rangerSkillTree, SkillReferencePosition.rangerSpecialisationElementalArrowsStacksThree, (LivingEntity)player)) {
            amplifier += elementalArrowsStacksIncreasePerTier * 3;
        }
        player.m_7292_(new MobEffectInstance(EffectRegistry.ELEMENTALARROWS, elementalArrowsDuration, amplifier, false, false, true));
        return true;
    }

    public static boolean signatureRangerArrowRain(String rangerSkillTree, Player player) {
        int arrowRainDuration = SimplySkills.rangerConfig.effectRangerArrowRainDuration;
        player.m_7292_(new MobEffectInstance(EffectRegistry.ARROWRAIN, arrowRainDuration, 0, false, false, true));
        return true;
    }

    public static void signatureRangerElementalArtillery(ServerPlayer player, SpellProjectile spellProjectile, ResourceLocation spellId, SpellHelper.ImpactContext context, Spell.ProjectileData.Perks perks) {
        if (player != null && spellProjectile.f_19797_ % 12 == 0 && spellProjectile.f_19797_ > 30 && HelperMethods.isUnlocked("simplyskills:ranger", SkillReferencePosition.rangerSpecialisationArrowRainElementalArtillery, (LivingEntity)player) && spellId.toString().contains("arrow_rain")) {
            Vec3 position = spellProjectile.m_20182_();
            ArrayList<String> list = new ArrayList<String>();
            list.add("simplyskills:frost_arrow_homing");
            list.add("simplyskills:fire_arrow_homing");
            list.add("simplyskills:lightning_arrow_homing");
            Random rand = new Random();
            ResourceLocation randomSpell = new ResourceLocation((String)list.get(rand.nextInt(list.size())));
            SpellProjectile projectile = new SpellProjectile(spellProjectile.m_9236_(), (LivingEntity)spellProjectile.m_19749_(), position.m_7096_(), position.m_7098_(), position.m_7094_(), spellProjectile.behaviour(), randomSpell, (Entity)null, context, perks.copy());
            projectile.m_20256_(spellProjectile.m_20184_());
            projectile.range = spellProjectile.range;
            ProjectileUtil.m_37284_((Entity)projectile, (float)0.2f);
            int radius = 20;
            AABB box = new AABB(spellProjectile.m_20185_() + (double)radius, spellProjectile.m_20186_() + (double)((float)radius * 3.0f), spellProjectile.m_20189_() + (double)radius, spellProjectile.m_20185_() - (double)radius, spellProjectile.m_20186_() - (double)((float)radius * 3.0f), spellProjectile.m_20189_() - (double)radius);
            for (Entity entities : player.m_9236_().m_6249_((Entity)player, box, EntitySelector.f_20403_)) {
                LivingEntity le;
                if (entities == null || player.m_217043_().m_188503_(100) >= 35 || !(entities instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entities, (Player)player)) continue;
                projectile.setFollowedTarget((Entity)le);
                break;
            }
            spellProjectile.m_9236_().m_7967_((Entity)projectile);
        }
    }
}

