/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.abilities;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.CrossbowItem;
import net.minecraft.world.phys.AABB;
import net.sweenus.simplyskills.SimplySkills;
import net.sweenus.simplyskills.effects.instance.SimplyStatusEffectInstance;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.registry.SoundRegistry;
import net.sweenus.simplyskills.util.HelperMethods;
import net.sweenus.simplyskills.util.SkillReferencePosition;

public class ProminenceAbilities {
    public static int getAscendancyPoints(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (FabricLoader.getInstance().isModLoaded("prominent") && BuiltInRegistries.f_256951_.m_7745_(new ResourceLocation("eldritch_end:corruption")) != null) {
                return (int)player.m_21133_((Attribute)BuiltInRegistries.f_256951_.m_7745_(new ResourceLocation("eldritch_end:corruption")));
            }
            return HelperMethods.countUnlockedSkills("ascendancy", serverPlayer);
        }
        return 0;
    }

    public static boolean boneArmor(Player player) {
        ServerLevel world = (ServerLevel)player.m_9236_();
        AABB box = HelperMethods.createBoxHeight((Entity)player, 12);
        AtomicInteger count = new AtomicInteger();
        player.m_9236_().m_6249_((Entity)player, box, EntitySelector.f_20403_).stream().filter(Objects::nonNull).filter(entity -> entity instanceof LivingEntity).filter(entity -> player instanceof ServerPlayer).forEach(entity -> {
            LivingEntity le = (LivingEntity)entity;
            ServerPlayer playerEntity = (ServerPlayer)player;
            if (HelperMethods.checkFriendlyFire(le, (Player)playerEntity)) {
                SimplyStatusEffectInstance tauntedEffect = new SimplyStatusEffectInstance(EffectRegistry.TAUNTED, 160 + ProminenceAbilities.getAscendancyPoints(player), 0, false, false, true);
                if (ProminenceAbilities.getAscendancyPoints(player) > 29) {
                    le.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 300 + ProminenceAbilities.getAscendancyPoints(player), 1, false, false, true));
                }
                tauntedEffect.setSourceEntity((LivingEntity)player);
                le.m_7292_((MobEffectInstance)tauntedEffect);
                count.getAndIncrement();
                HelperMethods.spawnWaistHeightParticles(world, (ParticleOptions)ParticleTypes.f_123762_, (Entity)player, (Entity)le, 20);
            }
        });
        player.m_9236_().m_6269_(null, (Entity)player, SoundRegistry.MAGIC_SHAMANIC_SPELL_04, SoundSource.PLAYERS, 0.2f, 1.0f);
        player.m_7292_(new MobEffectInstance(EffectRegistry.BONEARMOR, 400, Math.min(6, count.get()), false, false, true));
        player.m_7292_(new MobEffectInstance(MobEffects.f_19616_, 400, Math.min(6, count.get()), false, false, true));
        return true;
    }

    public static void boneArmorEffect(ServerPlayer player) {
        MobEffectInstance boneArmorEffect;
        if (HelperMethods.isUnlocked("puffish_skills:prom", SkillReferencePosition.ascendancyBoneArmor, (LivingEntity)player) && player.m_21023_(EffectRegistry.BONEARMOR) && (boneArmorEffect = player.m_21124_(EffectRegistry.BONEARMOR)) != null) {
            HelperMethods.decrementStatusEffect((LivingEntity)player, EffectRegistry.BONEARMOR);
            player.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 40, 2, false, false, true));
        }
    }

    public static void focusEffect(Player player, ResourceLocation spellId) {
        if (HelperMethods.isUnlocked("puffish_skills:prom", SkillReferencePosition.promFocus, (LivingEntity)player) && spellId.toString().contains("archers:barrage")) {
            if (player.m_21205_().m_41720_() instanceof BowItem) {
                player.m_7292_(new MobEffectInstance(EffectRegistry.FOCUS, 220, 0, false, false, true));
            } else if (player.m_21205_().m_41720_() instanceof CrossbowItem) {
                player.m_21195_(EffectRegistry.REVEALED);
                HelperMethods.incrementStatusEffect((LivingEntity)player, EffectRegistry.MARKSMANSHIP, 80, 8, 15);
                player.m_7292_(new MobEffectInstance(EffectRegistry.STEALTH, 80, 0, false, false, true));
            }
        }
    }

    public static void promTwinstrike(Player player, LivingEntity target) {
        int effectChance = SimplySkills.warriorConfig.passiveWarriorTwinstrikeChance;
        int effectDamage = (int)player.m_21133_(Attributes.f_22281_);
        DamageSource damageSource = player.m_269291_().m_269075_(player);
        if (HelperMethods.isDualWielding((LivingEntity)player)) {
            effectChance *= 2;
        }
        if (player.m_217043_().m_188503_(100) < effectChance) {
            target.m_6469_(damageSource, (float)effectDamage);
            target.f_19802_ = 0;
        }
    }

    public static void warriorsDevotion(Player player) {
        if (player.f_19797_ % 20 == 0 && HelperMethods.isUnlocked("puffish_skills:prom", SkillReferencePosition.promWarriorsDevotion, (LivingEntity)player) && (player.m_21205_().m_41619_() || player.m_21206_().m_41619_())) {
            player.m_7292_(new MobEffectInstance(EffectRegistry.WARRIORSDEVOTION, 30, 0, false, false, true));
        }
    }
}

