/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.abilities;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;
import net.sweenus.simplyskills.entities.GreaterDreadglareEntity;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.registry.EntityRegistry;
import net.sweenus.simplyskills.registry.SoundRegistry;
import net.sweenus.simplyskills.util.HelperMethods;
import net.sweenus.simplyskills.util.SkillReferencePosition;

public class NecromancerAbilities {
    public static void effectNecromancerWinterborn(Player player) {
        if (HelperMethods.isUnlocked("simplyskills:necromancer", SkillReferencePosition.necromancerSpecialisationWinterborn, (LivingEntity)player)) {
            double frostSpellPower = SpellPower.getSpellPower((SpellSchool)SpellSchools.FROST, (LivingEntity)player).baseValue();
            player.m_7292_(new MobEffectInstance(EffectRegistry.SOULSHOCK, 220, (int)frostSpellPower, false, false, false));
        }
    }

    public static void effectNecromancerEnrage(LivingEntity livingEntity, Player player) {
        if (HelperMethods.isUnlocked("simplyskills:necromancer", SkillReferencePosition.necromancerSpecialisationEnrage, (LivingEntity)player)) {
            AABB box = HelperMethods.createBoxHeight((Entity)livingEntity, 15);
            for (Entity entities : livingEntity.m_9236_().m_6249_((Entity)livingEntity, box, EntitySelector.f_20403_)) {
                OwnableEntity te;
                if (entities == null || !(entities instanceof OwnableEntity) || HelperMethods.checkFriendlyFire((LivingEntity)(te = (OwnableEntity)entities), player)) continue;
                HelperMethods.incrementStatusEffect((LivingEntity)te, MobEffects.f_19600_, 200, 1, 3);
                HelperMethods.incrementStatusEffect((LivingEntity)te, MobEffects.f_19606_, 200, 1, 3);
            }
            player.m_9236_().m_6269_(null, (Entity)player, SoundRegistry.MAGIC_SHAMANIC_VOICE_20, SoundSource.PLAYERS, 0.2f, 1.2f);
        }
    }

    public static void effectNecromancerDeathEssence(Player player) {
        if (HelperMethods.isUnlocked("simplyskills:necromancer", SkillReferencePosition.necromancerSpecialisationDeathEssence, (LivingEntity)player)) {
            HelperMethods.incrementStatusEffect((LivingEntity)player, EffectRegistry.BONEARMOR, 400, 1, 25);
        }
    }

    public static void effectDeathWarden(Player player) {
        if (HelperMethods.isUnlocked("simplyskills:necromancer", SkillReferencePosition.necromancerSpecialisationDeathWarden, (LivingEntity)player)) {
            boolean success = false;
            AABB box = HelperMethods.createBoxHeight((Entity)player, 15);
            for (Entity entities : player.m_9236_().m_6249_((Entity)player, box, EntitySelector.f_20403_)) {
                OwnableEntity te;
                if (entities == null || !(entities instanceof OwnableEntity) || (te = (OwnableEntity)entities).m_269323_() == null || !te.m_269323_().equals((Object)player)) continue;
                float healAmount = (float)((double)player.m_21233_() * 0.15);
                player.m_5634_(healAmount);
                entities.m_6469_(player.m_269291_().m_269264_(), healAmount);
                HelperMethods.spawnWaistHeightParticles((ServerLevel)player.m_9236_(), (ParticleOptions)ParticleTypes.f_123759_, (Entity)player, entities, 20);
                success = true;
            }
            if (success) {
                player.m_9236_().m_6269_(null, (Entity)player, SoundRegistry.MAGIC_SHAMANIC_VOICE_20, SoundSource.PLAYERS, 0.2f, 1.3f);
            }
        }
    }

    public static void effectPlague(Player player) {
        if (HelperMethods.isUnlocked("simplyskills:necromancer", SkillReferencePosition.necromancerSpecialisationPlague, (LivingEntity)player) && player.f_19797_ % 20 == 0 && player.m_21220_() != null && HelperMethods.hasHarmfulStatusEffect((LivingEntity)player)) {
            AABB box = HelperMethods.createBoxHeight((Entity)player, 15);
            List<Entity> validEntities = player.m_9236_().m_6249_((Entity)player, box, EntitySelector.f_20403_).stream().filter(entities -> entities instanceof TamableAnimal).filter(entities -> {
                TamableAnimal te = (TamableAnimal)entities;
                return te.m_269323_() != null && te.m_269323_().equals((Object)player);
            }).toList();
            if (!validEntities.isEmpty()) {
                Entity randomEntity = validEntities.get(new Random().nextInt(validEntities.size()));
                HelperMethods.buffSteal((LivingEntity)randomEntity, (LivingEntity)player, true, true, true, false);
                HelperMethods.spawnWaistHeightParticles((ServerLevel)player.m_9236_(), (ParticleOptions)ParticleTypes.f_123806_, (Entity)player, randomEntity, 12);
                player.m_9236_().m_6269_(null, (Entity)player, SoundRegistry.MAGIC_SHAMANIC_SPELL_03, SoundSource.PLAYERS, 0.1f, 1.5f);
            }
        }
    }

    public static void effectPestilence(Player player, LivingEntity minion, LivingEntity target) {
        if (HelperMethods.isUnlocked("simplyskills:necromancer", SkillReferencePosition.necromancerSpecialisationPestilence, (LivingEntity)player)) {
            HelperMethods.buffSteal(target, minion, true, true, true, false);
        }
    }

    public static void effectDelightfulSuffering(Player player) {
        if (HelperMethods.isUnlocked("simplyskills:necromancer", SkillReferencePosition.necromancerSpecialisationDelightfulSuffering, (LivingEntity)player)) {
            int duration = 800;
            ArrayList<MobEffectInstance> list = new ArrayList<MobEffectInstance>();
            list.add(0, new MobEffectInstance(MobEffects.f_19612_, duration, 0, false, false, true));
            list.add(1, new MobEffectInstance(MobEffects.f_19597_, duration, 0, false, false, true));
            list.add(2, new MobEffectInstance(MobEffects.f_19615_, duration, 0, false, false, true));
            list.add(3, new MobEffectInstance(MobEffects.f_19599_, duration, 0, false, false, true));
            list.add(4, new MobEffectInstance(MobEffects.f_19599_, duration, 0, false, false, true));
            if (!list.isEmpty()) {
                MobEffect chosenEffect = ((MobEffectInstance)list.get(player.m_217043_().m_188503_(4))).m_19544_();
                HelperMethods.incrementStatusEffect((LivingEntity)player, chosenEffect, duration, 1, 2);
            }
        }
    }

    public static void effectEndlessServitude(Player player, TamableAnimal minion) {
        if (HelperMethods.isUnlocked("simplyskills:necromancer", SkillReferencePosition.necromancerSpecialisationEndlessServitude, (LivingEntity)player)) {
            int chanceThreshold = Math.min(21 + HelperMethods.countHarmfulStatusEffects((LivingEntity)minion) * 5, 60);
            int chance = minion.m_217043_().m_188503_(100);
            if (chance < chanceThreshold) {
                EntityType entityType = minion.m_6095_();
                NecromancerAbilities.summonMinion((EntityType<? extends LivingEntity>)entityType, player);
                player.m_9236_().m_6269_(null, (Entity)player, SoundRegistry.MAGIC_SHAMANIC_SPELL_02, SoundSource.PLAYERS, 0.2f, 1.0f);
            }
        }
    }

    public static void effectShadowCombust(Player player, TamableAnimal minion) {
        if (HelperMethods.isUnlocked("simplyskills:necromancer", SkillReferencePosition.necromancerSpecialisationShadowCombust, (LivingEntity)player)) {
            int radius = 4;
            if (minion instanceof GreaterDreadglareEntity) {
                radius = 7;
            }
            AABB box = HelperMethods.createBox((Entity)minion, radius);
            minion.m_9236_().m_6249_((Entity)minion, box, EntitySelector.f_20403_).stream().filter(Objects::nonNull).filter(entity -> entity instanceof LivingEntity).forEach(entity -> {
                LivingEntity le = (LivingEntity)entity;
                if (player != null && HelperMethods.checkFriendlyFire(le, player)) {
                    le.f_19802_ = 0;
                    float damageMulti = 3.2f;
                    if (minion instanceof GreaterDreadglareEntity) {
                        damageMulti = 6.4f;
                    }
                    le.m_6469_(player.m_9236_().m_269111_().m_269104_((Entity)player, (Entity)player), (float)SpellPower.getSpellPower((SpellSchool)SpellSchools.SOUL, (LivingEntity)player).baseValue() * damageMulti);
                    HelperMethods.spawnWaistHeightParticles((ServerLevel)minion.m_9236_(), (ParticleOptions)ParticleTypes.f_123762_, (Entity)minion, (Entity)le, 8);
                    le.f_19802_ = 0;
                }
            });
            if (player != null) {
                player.m_9236_().m_6269_(null, (Entity)player, SoundRegistry.MAGIC_SHAMANIC_SPELL_03, SoundSource.PLAYERS, 0.1f, 1.0f);
                player.m_9236_().m_6269_(null, (Entity)player, SoundEvents.f_11913_, SoundSource.PLAYERS, 0.1f, 1.0f);
            }
            HelperMethods.spawnOrbitParticles((ServerLevel)minion.m_9236_(), minion.m_20182_(), (ParticleOptions)ParticleTypes.f_123813_, 1.0, 2);
            HelperMethods.spawnOrbitParticles((ServerLevel)minion.m_9236_(), minion.m_20182_(), (ParticleOptions)ParticleTypes.f_123746_, 2.0, 20);
            HelperMethods.spawnOrbitParticles((ServerLevel)minion.m_9236_(), minion.m_20182_(), (ParticleOptions)ParticleTypes.f_123762_, radius, 20);
            if (minion.m_6084_()) {
                minion.m_6469_(minion.m_9236_().m_269111_().m_269104_((Entity)minion, (Entity)minion), minion.m_21233_());
            }
        }
    }

    public static int getMinionLimit(String necromancerTree, Player player) {
        int count = 0;
        for (String skillRef : SkillReferencePosition.undeadLegionSkills) {
            if (!HelperMethods.isUnlocked(necromancerTree, skillRef, (LivingEntity)player)) continue;
            ++count;
        }
        return 1 + count;
    }

    public static boolean signatureNecromancerSummoningRitual(String necromancerTree, Player player) {
        for (int i = 0; i < NecromancerAbilities.getMinionLimit(necromancerTree, player); ++i) {
            if (HelperMethods.isUnlocked(necromancerTree, SkillReferencePosition.necromancerSpecialisationGreaterDreadglare, (LivingEntity)player)) {
                NecromancerAbilities.summonMinion(EntityRegistry.GREATER_DREADGLARE, player);
                break;
            }
            if (HelperMethods.isUnlocked(necromancerTree, SkillReferencePosition.necromancerSpecialisationSummonWraith, (LivingEntity)player)) {
                int chance = player.m_217043_().m_188503_(100);
                if (HelperMethods.isUnlocked("simplyskills:necromancer", SkillReferencePosition.necromancerSpecialisationWraithLegion, (LivingEntity)player)) {
                    chance = 5;
                }
                if (chance < 50) {
                    NecromancerAbilities.summonMinion(EntityRegistry.WRAITH, player);
                    continue;
                }
                NecromancerAbilities.summonMinion(EntityRegistry.DREADGLARE, player);
                continue;
            }
            NecromancerAbilities.summonMinion(EntityRegistry.DREADGLARE, player);
        }
        player.m_9236_().m_6269_(null, (Entity)player, SoundRegistry.MAGIC_SHAMANIC_VOICE_20, SoundSource.PLAYERS, 0.3f, 1.0f);
        return true;
    }

    public static void summonMinion(EntityType<? extends LivingEntity> livingEntity, Player player) {
        LivingEntity minion = (LivingEntity)livingEntity.m_262496_((ServerLevel)player.m_9236_(), player.m_20183_().m_6630_(4).m_5484_(player.m_6374_(), 3), MobSpawnType.MOB_SUMMONED);
        if (minion != null) {
            if (minion instanceof TamableAnimal) {
                TamableAnimal tameableMinion = (TamableAnimal)minion;
                tameableMinion.m_21828_(player);
                tameableMinion.m_7105_(true);
                tameableMinion.m_21446_(player.m_20183_().m_6630_(3), 32);
                if (HelperMethods.isUnlocked("simplyskills:necromancer", SkillReferencePosition.necromancerSpecialisationShadowAura, (LivingEntity)player)) {
                    int amplifier = 0;
                    if (tameableMinion instanceof GreaterDreadglareEntity) {
                        amplifier = 3;
                    }
                    minion.m_7292_(new MobEffectInstance(EffectRegistry.SHADOWAURA, 2400, amplifier, false, false, false));
                }
            }
            double attackDamageMultiplier = 1.2;
            if (minion instanceof GreaterDreadglareEntity) {
                attackDamageMultiplier = 3.0;
            }
            double healthMultiplier = NecromancerAbilities.getHealthMultiplier(livingEntity);
            NecromancerAbilities.setMinionAttributes(player, minion, attackDamageMultiplier, healthMultiplier);
        }
    }

    private static double getHealthMultiplier(EntityType<?> entityType) {
        if (entityType.equals(EntityRegistry.DREADGLARE)) {
            return 1.4;
        }
        if (entityType.equals(EntityRegistry.WRAITH)) {
            return 0.8;
        }
        if (entityType.equals(EntityRegistry.GREATER_DREADGLARE)) {
            return 4.8;
        }
        return 1.0;
    }

    private static void setMinionAttributes(Player player, LivingEntity minion, double attackDamageMultiplier, double healthMultiplier) {
        double attackDamage = 3.0 + attackDamageMultiplier * SpellPower.getSpellPower((SpellSchool)SpellSchools.SOUL, (LivingEntity)player).baseValue();
        AttributeInstance attackAttribute = minion.m_21051_(Attributes.f_22281_);
        if (attackAttribute != null) {
            attackAttribute.m_22100_(attackDamage);
        }
        double maxHealth = 1.0 + healthMultiplier * player.m_21133_(Attributes.f_22276_);
        AttributeInstance healthAttribute = minion.m_21051_(Attributes.f_22276_);
        if (healthAttribute != null) {
            healthAttribute.m_22100_(maxHealth);
            minion.m_5634_((float)maxHealth);
        }
        if (HelperMethods.isUnlocked("simplyskills:necromancer", SkillReferencePosition.necromancerSpecialisationNecroticFortification, (LivingEntity)player)) {
            double multiplier = 0.5;
            if (minion instanceof GreaterDreadglareEntity) {
                multiplier = 1.0;
            }
            double maxArmor = 1.0 + multiplier * player.m_21133_(Attributes.f_22284_);
            double maxArmorToughness = 1.0 + multiplier * player.m_21133_(Attributes.f_22285_);
            AttributeInstance armorAttribute = minion.m_21051_(Attributes.f_22284_);
            AttributeInstance armorToughnessAttribute = minion.m_21051_(Attributes.f_22285_);
            if (armorAttribute != null) {
                armorAttribute.m_22100_(maxArmor);
            }
            if (armorToughnessAttribute != null) {
                armorToughnessAttribute.m_22100_(maxArmorToughness);
            }
        }
    }
}

