/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.abilities;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.entity.SpellProjectile;
import net.spell_engine.internals.SpellHelper;
import net.spell_engine.internals.SpellRegistry;
import net.spell_engine.internals.casting.SpellCast;
import net.spell_engine.particle.Particles;
import net.spell_power.api.SpellPower;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;
import net.sweenus.simplyskills.abilities.SignatureAbilities;
import net.sweenus.simplyskills.effects.instance.SimplyStatusEffectInstance;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.util.HelperMethods;
import net.sweenus.simplyskills.util.SkillReferencePosition;

public class ClericAbilities {
    public static void passiveClericHealingWard(Player player, List<Entity> targets, ResourceLocation spellId) {
        int random = new Random().nextInt(100);
        int chance = 10;
        Spell spell = SpellRegistry.getSpell((ResourceLocation)spellId);
        SpellSchool healingSchool = SpellSchools.HEALING;
        if (random < chance) {
            targets.forEach(target -> {
                if (target instanceof LivingEntity) {
                    LivingEntity livingTarget = (LivingEntity)target;
                    if (spell.school == healingSchool) {
                        HelperMethods.incrementStatusEffect(livingTarget, EffectRegistry.BARRIER, 100, 1, 20);
                    }
                }
            });
        }
    }

    public static void passiveClericMutualMending(Player player, ResourceLocation spellId, List<Entity> targets) {
        int random = new Random().nextInt(100);
        int chance = 20;
        if (spellId.toString().contains("holy_beam")) {
            chance = 10;
        }
        Spell spell = SpellRegistry.getSpell((ResourceLocation)spellId);
        SpellSchool healingSchool = SpellSchools.HEALING;
        if (random < chance && !targets.contains(player) && spell.school == healingSchool) {
            if (spellId.toString().contains("holy_beam")) {
                SignatureAbilities.castSpellEngineIndirectTarget(player, "paladins:heal", 10, (Entity)player, null);
            } else {
                SignatureAbilities.castSpellEngineIndirectTarget(player, spellId.toString(), 10, (Entity)player, null);
            }
        }
    }

    public static void passiveClericAltruism(Player player) {
        int frequency = 600;
        if (player.m_21230_() <= 10 && player.f_19797_ % frequency == 0) {
            HelperMethods.incrementStatusEffect((LivingEntity)player, EffectRegistry.SPELLFORGED, frequency + 5, 1, 2);
        }
    }

    public static boolean signatureClericDivineIntervention(String clericSkillTree, Player player) {
        Vec3 blockpos = null;
        boolean success = false;
        int divineInterventionRange = 25;
        if (HelperMethods.getTargetedEntity((Entity)player, divineInterventionRange) != null) {
            blockpos = HelperMethods.getTargetedEntity((Entity)player, divineInterventionRange).m_20182_();
        }
        if (blockpos == null) {
            blockpos = HelperMethods.getPositionLookingAt(player, divineInterventionRange);
        }
        if (blockpos != null) {
            int xpos = (int)blockpos.m_7096_();
            int ypos = (int)blockpos.m_7098_();
            int zpos = (int)blockpos.m_7094_();
            BlockPos searchArea = new BlockPos(xpos, ypos, zpos);
            AABB box = HelperMethods.createBoxAtBlock(searchArea, 3);
            for (Entity entities : player.m_9236_().m_6249_((Entity)player, box, EntitySelector.f_20403_)) {
                LivingEntity le;
                if (entities == null || !(entities instanceof LivingEntity) || HelperMethods.checkFriendlyFire(le = (LivingEntity)entities, player)) continue;
                success = true;
                if (HelperMethods.isUnlocked(clericSkillTree, SkillReferencePosition.clericSpecialisationDivineInterventionFireResistance, (LivingEntity)player)) {
                    HelperMethods.incrementStatusEffect(le, MobEffects.f_19607_, 240, 1, 5);
                }
                if (HelperMethods.isUnlocked(clericSkillTree, SkillReferencePosition.clericSpecialisationDivineInterventionMight, (LivingEntity)player)) {
                    HelperMethods.incrementStatusEffect(le, EffectRegistry.MIGHT, 240, 3, 10);
                }
                if (HelperMethods.isUnlocked(clericSkillTree, SkillReferencePosition.clericSpecialisationDivineInterventionSpellforged, (LivingEntity)player)) {
                    HelperMethods.incrementStatusEffect(le, EffectRegistry.SPELLFORGED, 240, 3, 10);
                }
                SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:divine_intervention", 15, (Entity)le, HelperMethods.getBlockLookingAt(player, 256));
                break;
            }
        }
        return success;
    }

    public static boolean signatureClericSacredOrb(String clericSkillTree, Player player) {
        SignatureAbilities.castSpellEngineDumbFire(player, "simplyskills:sacred_orb");
        return true;
    }

    public static void signatureClericSacredOrbHoming(SpellProjectile spellProjectile, ResourceLocation spellId) {
        if (spellProjectile.getSpell() != null && spellId != null && spellId.toString().equals("simplyskills:sacred_orb") && spellProjectile.f_19797_ > 20 && spellProjectile.getFollowedTarget() == null) {
            AABB box = HelperMethods.createBox((Entity)spellProjectile, 6);
            for (Entity entities : spellProjectile.m_9236_().m_6249_((Entity)spellProjectile, box, EntitySelector.f_20403_)) {
                Player playerOwner;
                if (!(entities instanceof LivingEntity)) continue;
                LivingEntity le = (LivingEntity)entities;
                Entity entity = spellProjectile.m_19749_();
                if (!(entity instanceof Player) || HelperMethods.checkFriendlyFire(le, playerOwner = (Player)entity)) continue;
                spellProjectile.setFollowedTarget((Entity)le);
                break;
            }
        }
    }

    public static void signatureClericSacredOrbImpact(EntityHitResult entityHitResult, ResourceLocation spellId, Entity ownerEntity, SpellProjectile spellProjectile) {
        Entity entity;
        if (spellProjectile.getSpell() != null && spellId != null && spellId.toString().equals("simplyskills:sacred_orb") && entityHitResult.m_82443_() != null && (entity = entityHitResult.m_82443_()) instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            if (ownerEntity instanceof LivingEntity) {
                LivingEntity livingOwner = (LivingEntity)ownerEntity;
                SimplyStatusEffectInstance vitalityBond = new SimplyStatusEffectInstance(EffectRegistry.VITALITYBOND, 500, 0, false, false, true);
                SimplyStatusEffectInstance vitalityBond2 = new SimplyStatusEffectInstance(EffectRegistry.VITALITYBOND, 500, 0, false, false, true);
                vitalityBond.setSourceEntity(livingOwner);
                vitalityBond2.setSourceEntity(livingOwner);
                livingEntity.m_7292_((MobEffectInstance)vitalityBond);
                livingOwner.m_7292_((MobEffectInstance)vitalityBond2);
            }
        }
    }

    public static boolean signatureClericAnointWeapon(Player player) {
        player.m_7292_(new MobEffectInstance(EffectRegistry.ANOINTED, 400, 0, false, false, true));
        return true;
    }

    public static void signatureClericAnointWeaponCleanse(Player player) {
        int frequency = 20;
        if (player.f_19797_ % frequency == 0) {
            HelperMethods.buffSteal((LivingEntity)player, (LivingEntity)player, true, true, true, true);
        }
    }

    public static void signatureClericAnointWeaponUndying(Player player) {
        float playerHealthPercent = player.m_21223_() / player.m_21233_() * 100.0f;
        int roll = player.m_217043_().m_188503_(100);
        int chance = 15;
        if (playerHealthPercent < 30.0f && roll < chance) {
            player.m_7292_(new MobEffectInstance(EffectRegistry.UNDYING, 120, 0, false, false, true));
        }
    }

    public static void signatureClericAnointWeaponEffect(Player player) {
        int radius = 4;
        float damageMultiplier = 2.2f;
        AABB box = HelperMethods.createBox((Entity)player, radius);
        ArrayList<LivingEntity> targets = new ArrayList<LivingEntity>();
        ArrayList<LivingEntity> hostileTargets = new ArrayList<LivingEntity>();
        for (Entity entities : player.m_9236_().m_6249_((Entity)player, box, EntitySelector.f_20403_)) {
            if (!(entities instanceof LivingEntity)) continue;
            LivingEntity le = (LivingEntity)entities;
            if (!HelperMethods.checkFriendlyFire(le, player)) {
                targets.add(le);
                continue;
            }
            if (!HelperMethods.checkFriendlyFire(le, player)) continue;
            hostileTargets.add(le);
        }
        ResourceLocation spellId = new ResourceLocation("simplyskills:paladins_flash_heal");
        SpellCast.Action action = SpellCast.Action.CHANNEL;
        DamageSource damageSource = player.m_269291_().m_269104_((Entity)player, (Entity)player);
        SpellHelper.performSpell((Level)player.m_9236_(), (Player)player, (ResourceLocation)spellId, targets, (SpellCast.Action)action, (float)20.0f);
        float amount = (float)(SpellPower.getSpellPower((SpellSchool)SpellSchools.HEALING, (LivingEntity)player).randomValue() * (double)damageMultiplier) / (float)hostileTargets.size();
        hostileTargets.forEach(entity -> {
            Mob mobEntity;
            entity.f_19802_ = 0;
            entity.m_6469_(damageSource, amount);
            entity.f_19802_ = 0;
            if (entity instanceof Mob && (mobEntity = (Mob)entity).m_21222_()) {
                HelperMethods.incrementStatusEffect((LivingEntity)mobEntity, MobEffects.f_19597_, 40, 1, 4);
            }
            for (int i = 6; i > 0; --i) {
                HelperMethods.spawnParticle(player.m_9236_(), (ParticleOptions)Particles.holy_spark_mini.particleType, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 0.1, 0.1 + (double)i, 0.2);
                HelperMethods.spawnParticle(player.m_9236_(), (ParticleOptions)Particles.holy_spark_mini.particleType, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 0.2, 0.2 + (double)i, 0.1);
                HelperMethods.spawnParticle(player.m_9236_(), (ParticleOptions)Particles.holy_hit.particleType, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), 0.1, 0.2 * (double)i, 0.2);
            }
        });
        if (HelperMethods.isUnlocked("simplyskills:cleric", SkillReferencePosition.clericSpecialisationAnointWeaponResistance, (LivingEntity)player)) {
            HelperMethods.incrementStatusEffect((LivingEntity)player, MobEffects.f_19606_, 40, 1, 2);
        }
    }
}

