/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.abilities;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.puffish.skillsmod.api.Category;
import net.puffish.skillsmod.api.Skill;
import net.puffish.skillsmod.api.SkillsAPI;
import net.spell_engine.internals.SpellRegistry;
import net.spell_power.api.SpellSchool;
import net.sweenus.simplyskills.SimplySkills;
import net.sweenus.simplyskills.abilities.AbilityEffects;
import net.sweenus.simplyskills.abilities.AscendancyAbilities;
import net.sweenus.simplyskills.abilities.ClericAbilities;
import net.sweenus.simplyskills.abilities.CrusaderAbilities;
import net.sweenus.simplyskills.abilities.InitiateAbilities;
import net.sweenus.simplyskills.abilities.NecromancerAbilities;
import net.sweenus.simplyskills.abilities.ProminenceAbilities;
import net.sweenus.simplyskills.abilities.SpellbladeAbilities;
import net.sweenus.simplyskills.abilities.WayfarerAbilities;
import net.sweenus.simplyskills.abilities.WizardAbilities;
import net.sweenus.simplyskills.abilities.compat.SimplySwordsGemEffects;
import net.sweenus.simplyskills.items.GraciousManuscript;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.registry.ItemRegistry;
import net.sweenus.simplyskills.util.HelperMethods;
import net.sweenus.simplyskills.util.SkillReferencePosition;
import org.jetbrains.annotations.Nullable;

public class AbilityLogic {
    public static boolean skillTreeUnlockManager(Player player, String categoryID) {
        if (HelperMethods.stringContainsAny(categoryID, SimplySkills.getSpecialisations())) {
            if (SimplySkills.generalConfig.removeUnlockRestrictions || player.m_21205_().m_41720_() instanceof GraciousManuscript) {
                return false;
            }
            List<String> specialisationList = SimplySkills.getSpecialisationsAsArray();
            for (String s : specialisationList) {
                if (!categoryID.contains(s)) continue;
                for (Category value : SkillsAPI.streamUnlockedCategories((ServerPlayer)((ServerPlayer)player))::iterator) {
                    if (!HelperMethods.stringContainsAny(value.getId().toString(), SimplySkills.getSpecialisations())) continue;
                    return true;
                }
            }
            if (categoryID.contains("simplyskills:wizard") && !HelperMethods.isUnlocked("simplyskills:wizard", null, (LivingEntity)player)) {
                if (SimplySkills.wizardConfig.enableWizardSpecialisation) {
                    AbilityLogic.playUnlockSound(player);
                    player.m_213846_((Component)Component.m_237115_((String)"system.simplyskills.unlock"));
                    return false;
                }
            } else if (categoryID.contains("simplyskills:berserker") && !HelperMethods.isUnlocked("simplyskills:berserker", null, (LivingEntity)player)) {
                if (SimplySkills.berserkerConfig.enableBerserkerSpecialisation) {
                    AbilityLogic.playUnlockSound(player);
                    player.m_213846_((Component)Component.m_237115_((String)"system.simplyskills.unlock"));
                    return false;
                }
            } else if (categoryID.contains("simplyskills:rogue") && !HelperMethods.isUnlocked("simplyskills:rogue", null, (LivingEntity)player)) {
                if (SimplySkills.rogueConfig.enableRogueSpecialisation) {
                    AbilityLogic.playUnlockSound(player);
                    player.m_213846_((Component)Component.m_237115_((String)"system.simplyskills.unlock"));
                    return false;
                }
            } else if (categoryID.contains("simplyskills:ranger") && !HelperMethods.isUnlocked("simplyskills:ranger", null, (LivingEntity)player)) {
                if (SimplySkills.rangerConfig.enableRangerSpecialisation) {
                    AbilityLogic.playUnlockSound(player);
                    player.m_213846_((Component)Component.m_237115_((String)"system.simplyskills.unlock"));
                    return false;
                }
            } else if (categoryID.contains("simplyskills:spellblade") && !HelperMethods.isUnlocked("simplyskills:spellblade", null, (LivingEntity)player)) {
                if (SimplySkills.spellbladeConfig.enableSpellbladeSpecialisation) {
                    AbilityLogic.playUnlockSound(player);
                    player.m_213846_((Component)Component.m_237115_((String)"system.simplyskills.unlock"));
                    return false;
                }
            } else if (categoryID.contains("simplyskills:crusader") && !HelperMethods.isUnlocked("simplyskills:crusader", null, (LivingEntity)player)) {
                if (!FabricLoader.getInstance().isModLoaded("paladins")) {
                    return true;
                }
                if (SimplySkills.crusaderConfig.enableCrusaderSpecialisation) {
                    AbilityLogic.playUnlockSound(player);
                    player.m_213846_((Component)Component.m_237115_((String)"system.simplyskills.unlock"));
                    return false;
                }
            } else if (categoryID.contains("simplyskills:cleric") && !HelperMethods.isUnlocked("simplyskills:cleric", null, (LivingEntity)player)) {
                if (!FabricLoader.getInstance().isModLoaded("paladins")) {
                    return true;
                }
                if (SimplySkills.clericConfig.enableClericSpecialisation) {
                    AbilityLogic.playUnlockSound(player);
                    player.m_213846_((Component)Component.m_237115_((String)"system.simplyskills.unlock"));
                    return false;
                }
            } else if (categoryID.contains("simplyskills:necromancer") && !HelperMethods.isUnlocked("simplyskills:necromancer", null, (LivingEntity)player)) {
                if (SimplySkills.necromancerConfig.enableNecromancerSpecialisation) {
                    AbilityLogic.playUnlockSound(player);
                    player.m_213846_((Component)Component.m_237115_((String)"system.simplyskills.unlock"));
                    return false;
                }
            } else if (categoryID.contains("simplyskills:ascendancy") && !HelperMethods.isUnlocked("simplyskills:ascendancy", null, (LivingEntity)player) && SimplySkills.generalConfig.enableAscendancy) {
                AbilityLogic.playUnlockSound(player);
                return false;
            }
        }
        return false;
    }

    static void playUnlockSound(Player player) {
        if (player.m_21205_().m_41720_() != ItemRegistry.GRACIOUSMANUSCRIPT) {
            player.m_9236_().m_6269_(null, (Entity)player, SoundEvents.f_12496_, SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    public static void performJunctionLogic(ServerPlayer player, String skillId, ResourceLocation categoryId) {
        ArrayList<String> sapphire = new ArrayList<String>();
        sapphire.add(SkillReferencePosition.sapphire_portal_1);
        sapphire.add(SkillReferencePosition.sapphire_portal_2);
        ArrayList<String> ruby = new ArrayList<String>();
        ruby.add(SkillReferencePosition.ruby_portal_1);
        ruby.add(SkillReferencePosition.ruby_portal_2);
        for (String s : sapphire) {
            if (!skillId.equals(s) || !HelperMethods.isUnlocked(categoryId.toString(), s, (LivingEntity)player)) continue;
            for (String su : sapphire) {
                if (HelperMethods.isUnlocked(categoryId.toString(), su, (LivingEntity)player)) continue;
                ((Skill)((Category)SkillsAPI.getCategory((ResourceLocation)categoryId).get()).getSkill(su).get()).unlock(player);
            }
        }
        for (String s : ruby) {
            if (!skillId.equals(s) || !HelperMethods.isUnlocked(categoryId.toString(), s, (LivingEntity)player)) continue;
            for (String su : ruby) {
                if (HelperMethods.isUnlocked(categoryId.toString(), su, (LivingEntity)player)) continue;
                ((Skill)((Category)SkillsAPI.getCategory((ResourceLocation)categoryId).get()).getSkill(su).get()).unlock(player);
            }
        }
    }

    public static void performTagEffects(Player player, String tags) {
        if (tags.contains("magic")) {
            // empty if block
        }
        if (tags.contains("physical")) {
            // empty if block
        }
        if (tags.contains("arrow")) {
            // empty if block
        }
        if (tags.contains("arcane")) {
            // empty if block
        }
    }

    public static void onSpellCastEffects(Player player, @Nullable List<Entity> targets, @Nullable ResourceLocation spellId, @Nullable Set<? extends SpellSchool> schools) {
        SpellSchool school = null;
        if (spellId != null) {
            school = SpellRegistry.getSpell((ResourceLocation)spellId).school;
        }
        if (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.initiateEmpower, (LivingEntity)player) || FabricLoader.getInstance().isModLoaded("prominent") && HelperMethods.isUnlocked("puffish_skills:prom", SkillReferencePosition.initiateEmpower, (LivingEntity)player)) {
            InitiateAbilities.passiveInitiateEmpower(player, school, schools);
        }
        if (player.m_21023_(EffectRegistry.STEALTH)) {
            WayfarerAbilities.passiveWayfarerBreakStealth(null, player, false, false);
            if (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.initiateWhisperedWizardry, (LivingEntity)player)) {
                HelperMethods.incrementStatusEffect((LivingEntity)player, EffectRegistry.SPELLFORGED, 80, 1, 5);
            }
        } else if (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.initiateSpellcloak, (LivingEntity)player) && !player.m_21023_(EffectRegistry.REVEALED)) {
            player.m_7292_(new MobEffectInstance(EffectRegistry.STEALTH, 40, 0, false, false, true));
        }
        if (FabricLoader.getInstance().isModLoaded("simplyswords")) {
            SimplySwordsGemEffects.spellshield(player);
            SimplySwordsGemEffects.spellStandard(player);
        }
        if ((HelperMethods.isUnlocked("simplyskills:wizard", SkillReferencePosition.wizardSpellEcho, (LivingEntity)player) || AscendancyAbilities.magicCircleEffect(player)) && targets != null) {
            WizardAbilities.passiveWizardSpellEcho(player, targets);
        }
        if (HelperMethods.isUnlocked("simplyskills:spellblade", SkillReferencePosition.spellbladeWeaponExpert, (LivingEntity)player)) {
            SpellbladeAbilities.effectSpellbladeWeaponExpert(player);
        }
        if (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.initiateOverload, (LivingEntity)player)) {
            HelperMethods.incrementStatusEffect((LivingEntity)player, EffectRegistry.OVERLOAD, 160, 1, 9);
        }
        if (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.initiateEldritchEnfeeblement, (LivingEntity)player) && targets != null) {
            InitiateAbilities.passiveInitiateEldritchEnfeeblement(player, targets);
        }
        if (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.initiatePerilousPrecision, (LivingEntity)player) && targets != null) {
            InitiateAbilities.passiveInitiatePerilousPrecision(player, targets);
        }
        NecromancerAbilities.effectDelightfulSuffering(player);
        if (spellId != null) {
            if (FabricLoader.getInstance().isModLoaded("prominent")) {
                ProminenceAbilities.focusEffect(player, spellId);
            }
            if (HelperMethods.isUnlocked("simplyskills:cleric", SkillReferencePosition.clericMutualMending, (LivingEntity)player) && FabricLoader.getInstance().isModLoaded("paladins")) {
                ClericAbilities.passiveClericMutualMending(player, spellId, targets);
            }
            if (HelperMethods.isUnlocked("simplyskills:cleric", SkillReferencePosition.clericHealingWard, (LivingEntity)player) && FabricLoader.getInstance().isModLoaded("paladins")) {
                ClericAbilities.passiveClericHealingWard(player, targets, spellId);
            }
            if (school.id.toString().contains("physical_melee")) {
                if (HelperMethods.isUnlocked("simplyskills:tree", SkillReferencePosition.wayfarerQuickfire, (LivingEntity)player)) {
                    HelperMethods.incrementStatusEffect((LivingEntity)player, EffectRegistry.MARKSMANSHIP, 40, 1, 6);
                }
                AbilityEffects.effectRangerElementalArrows(player);
            }
            CrusaderAbilities.signatureHeavensmithsCallImpact("simplyskills:crusader", targets, spellId, player);
        }
    }
}

