/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.abilities;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.sweenus.simplyskills.SimplySkills;
import net.sweenus.simplyskills.abilities.SignatureAbilities;
import net.sweenus.simplyskills.entities.SimplySkillsArrowEntity;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.registry.EntityRegistry;
import net.sweenus.simplyskills.util.HelperMethods;
import net.sweenus.simplyskills.util.SkillReferencePosition;

public class AbilityEffects {
    public static void effectBerserkerBerserking(Entity target, Player player) {
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            if (player.m_21023_(EffectRegistry.BERSERKING)) {
                int berserkingSubEffectDuration = SimplySkills.berserkerConfig.signatureBerserkerBerserkingSubEffectDuration;
                int berserkingSubEffectMaxAmplifier = SimplySkills.berserkerConfig.signatureBerserkerBerserkingSubEffectMaxAmplifier;
                HelperMethods.incrementStatusEffect((LivingEntity)player, MobEffects.f_19598_, berserkingSubEffectDuration, 1, berserkingSubEffectMaxAmplifier);
                HelperMethods.incrementStatusEffect((LivingEntity)player, MobEffects.f_19600_, berserkingSubEffectDuration, 1, berserkingSubEffectMaxAmplifier);
                HelperMethods.incrementStatusEffect((LivingEntity)player, MobEffects.f_19596_, berserkingSubEffectDuration, 1, berserkingSubEffectMaxAmplifier);
            }
        }
    }

    public static void effectBerserkerBloodthirsty(Player player) {
        if (player.m_21023_(EffectRegistry.BLOODTHIRSTY)) {
            float bloodthirstyHealPercent = SimplySkills.berserkerConfig.signatureBerserkerBloodthirstyHealPercent;
            float healAmount = player.m_21233_() * bloodthirstyHealPercent;
            player.m_5634_(healAmount);
        }
    }

    public static void effectBerserkerBloodthirstyTireless(Player player) {
        if (player.m_21023_(EffectRegistry.BLOODTHIRSTY)) {
            int bloodthirstyTirelessChance = SimplySkills.berserkerConfig.signatureBerserkerBloodthirstyTirelessChance;
            if (player.m_217043_().m_188503_(100) < bloodthirstyTirelessChance) {
                HelperMethods.decrementStatusEffect((LivingEntity)player, EffectRegistry.EXHAUSTION);
            }
        }
    }

    public static void effectBerserkerBloodthirstyTremor(Player player) {
        if (player.m_21023_(EffectRegistry.BLOODTHIRSTY)) {
            int bloodthirstyTremoreChance = SimplySkills.berserkerConfig.signatureBerserkerBloodthirstyTremorChance;
            if (player.m_217043_().m_188503_(100) < bloodthirstyTremoreChance) {
                HelperMethods.incrementStatusEffect((LivingEntity)player, EffectRegistry.EARTHSHAKER, 30, 1, 1);
            }
        }
    }

    public static void effectBerserkerRampage(Player player) {
        if (player.m_21023_(EffectRegistry.RAMPAGE)) {
            int rampageSubEffectDuration = SimplySkills.berserkerConfig.signatureBerserkerRampageSubEffectDuration;
            int rampageSubEffectMaxAmplifier = SimplySkills.berserkerConfig.signatureBerserkerRampageSubEffectMaxAmplifier;
            ArrayList<MobEffect> list = new ArrayList<MobEffect>();
            list.add(MobEffects.f_19600_);
            list.add(MobEffects.f_19596_);
            list.add(MobEffects.f_19606_);
            list.add(MobEffects.f_19598_);
            Random rand = new Random();
            MobEffect randomStatus = (MobEffect)list.get(rand.nextInt(list.size()));
            HelperMethods.incrementStatusEffect((LivingEntity)player, randomStatus, rampageSubEffectDuration, 1, rampageSubEffectMaxAmplifier);
        }
    }

    public static void effectRogueSiphoningStrikes(Entity target, Player player) {
        if (player.m_21023_(EffectRegistry.SIPHONINGSTRIKES) && target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            double leechMultiplier = SimplySkills.rogueConfig.signatureRogueSiphoningStrikesLeechMultiplier;
            double attackValue = Objects.requireNonNull(player.m_21051_(Attributes.f_22281_)).m_22135_();
            float healAmount = (float)(attackValue * leechMultiplier);
            player.m_5634_(healAmount);
            HelperMethods.decrementStatusEffect((LivingEntity)player, EffectRegistry.SIPHONINGSTRIKES);
            for (MobEffectInstance statusEffect : livingTarget.m_21220_()) {
                if (statusEffect == null || !statusEffect.m_19544_().m_19486_()) continue;
                livingTarget.m_21195_(statusEffect.m_19544_());
                break;
            }
            if (HelperMethods.isUnlocked("simplyskills:rogue", SkillReferencePosition.rogueSpecialisationSiphoningStrikesVanish, (LivingEntity)player)) {
                AbilityEffects.effectRogueSiphoningStrikesVanish(player);
            }
        }
    }

    public static void effectRogueFanOfBlades(Player player) {
        int fobFrequency = SimplySkills.rogueConfig.signatureRogueFanOfBladesBaseFrequency;
        if (HelperMethods.isUnlocked("simplyskills:rogue", SkillReferencePosition.rogueSpecialisationEvasionFanOfBladesAssault, (LivingEntity)player)) {
            fobFrequency = SimplySkills.rogueConfig.signatureRogueFanOfBladesEnhancedFrequency;
        }
        if (HelperMethods.isUnlocked("simplyskills:rogue", SkillReferencePosition.rogueSpecialisationEvasionFanOfBlades, (LivingEntity)player) && player.m_21023_(EffectRegistry.FANOFBLADES) && player.f_19797_ % fobFrequency == 0) {
            int fobRange = SimplySkills.rogueConfig.signatureRogueFanOfBladesRange;
            int fobRadius = SimplySkills.rogueConfig.signatureRogueFanOfBladesRadius;
            int disenchantDuration = SimplySkills.rogueConfig.signatureRogueFanOfBladesDisenchantDuration;
            BlockPos blockPos = player.m_20183_().m_5484_(player.m_6374_(), fobRange);
            BlockState blockstate = player.m_9236_().m_8055_(blockPos);
            BlockState blockstateUp = player.m_9236_().m_8055_(blockPos.m_6630_(1));
            for (int i = fobRange; !(i <= 0 || blockstate.m_60795_() && blockstateUp.m_60795_()); --i) {
                blockPos = player.m_20183_().m_5484_(player.m_6374_(), i);
            }
            AABB box = HelperMethods.createBoxBetween(player.m_20183_(), blockPos, fobRadius);
            for (Entity entities : player.m_9236_().m_6249_((Entity)player, box, EntitySelector.f_20403_)) {
                LivingEntity le;
                if (entities == null || !(entities instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entities, player)) continue;
                if (HelperMethods.isUnlocked("simplyskills:rogue", SkillReferencePosition.rogueSpecialisationEvasionFanOfBladesAssault, (LivingEntity)player)) {
                    SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:fan_of_blades_assault", fobRange * 2, (Entity)le, HelperMethods.getBlockLookingAt(player, 256));
                } else {
                    SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:fan_of_blades", fobRange * 2, (Entity)le, HelperMethods.getBlockLookingAt(player, 256));
                }
                if (!HelperMethods.isUnlocked("simplyskills:rogue", SkillReferencePosition.rogueSpecialisationEvasionFanOfBladesDisenchantment, (LivingEntity)player)) continue;
                le.m_7292_(new MobEffectInstance(EffectRegistry.DISENCHANTMENT, disenchantDuration, 0, false, false));
            }
            if (HelperMethods.isUnlocked("simplyskills:rogue", SkillReferencePosition.rogueBladestorm, (LivingEntity)player) && player.m_217043_().m_188503_(100) < 35 + fobFrequency) {
                HelperMethods.incrementStatusEffect((LivingEntity)player, EffectRegistry.BLADESTORM, 400, 1, 20);
            }
            HelperMethods.decrementStatusEffect((LivingEntity)player, EffectRegistry.FANOFBLADES);
        }
    }

    public static void effectRogueSiphoningStrikesVanish(Player player) {
        if (player.m_21023_(EffectRegistry.SIPHONINGSTRIKES) && player.m_21023_(EffectRegistry.REVEALED)) {
            player.m_21195_(EffectRegistry.REVEALED);
        }
    }

    public static boolean effectRangerElementalArrows(Player player) {
        if (player.m_21023_(EffectRegistry.ELEMENTALARROWS)) {
            BlockPos blockpos = null;
            int radius = SimplySkills.rangerConfig.effectRangerElementalArrowsRadius;
            int increase = SimplySkills.rangerConfig.effectRangerElementalArrowsRadiusIncreasePerTier;
            int targetingRange = SimplySkills.rangerConfig.effectRangerElementalArrowsTargetingRange;
            int arrowCount = 1;
            int increasedArrowCount = 6;
            if (HelperMethods.isUnlocked("simplyskills:ranger", SkillReferencePosition.rangerSpecialisationElementalArrowsRadiusOne, (LivingEntity)player)) {
                radius += increase;
            } else if (HelperMethods.isUnlocked("simplyskills:ranger", SkillReferencePosition.rangerSpecialisationElementalArrowsRadiusTwo, (LivingEntity)player)) {
                radius += increase * 2;
            } else if (HelperMethods.isUnlocked("simplyskills:ranger", SkillReferencePosition.rangerSpecialisationElementalArrowsRadiusThree, (LivingEntity)player)) {
                radius += increase * 3;
            }
            ArrayList<String> list = new ArrayList<String>();
            list.add("simplyskills:frost_arrow_rain");
            list.add("simplyskills:fire_arrow_rain");
            list.add("simplyskills:lightning_arrow_rain");
            if (HelperMethods.isUnlocked("simplyskills:ranger", SkillReferencePosition.rangerSpecialisationElementalArrowsFireAttuned, (LivingEntity)player)) {
                list.remove("simplyskills:frost_arrow_rain");
                list.remove("simplyskills:lightning_arrow_rain");
            } else if (HelperMethods.isUnlocked("simplyskills:ranger", SkillReferencePosition.rangerSpecialisationElementalArrowsFrostAttuned, (LivingEntity)player)) {
                list.remove("simplyskills:fire_arrow_rain");
                list.remove("simplyskills:lightning_arrow_rain");
            } else if (HelperMethods.isUnlocked("simplyskills:ranger", SkillReferencePosition.rangerSpecialisationElementalArrowsLightningAttuned, (LivingEntity)player)) {
                list.remove("simplyskills:fire_arrow_rain");
                list.remove("simplyskills:frost_arrow_rain");
            }
            HelperMethods.decrementStatusEffect((LivingEntity)player, EffectRegistry.ELEMENTALARROWS);
            if (HelperMethods.getTargetedEntity((Entity)player, targetingRange) != null) {
                blockpos = HelperMethods.getTargetedEntity((Entity)player, targetingRange).m_20183_();
            }
            if (blockpos == null) {
                blockpos = HelperMethods.getBlockLookingAt(player, targetingRange);
            }
            if (blockpos != null) {
                int xpos = blockpos.m_123341_();
                int ypos = blockpos.m_123342_();
                int zpos = blockpos.m_123343_();
                BlockPos searchArea = new BlockPos(xpos, ypos, zpos);
                AABB box = HelperMethods.createBoxAtBlock(searchArea, radius);
                for (Entity entities : player.m_9236_().m_6249_((Entity)player, box, EntitySelector.f_20403_)) {
                    if (player.m_9236_().m_6249_((Entity)player, box, EntitySelector.f_20403_).size() == 1) {
                        arrowCount = increasedArrowCount;
                    }
                    for (int i = arrowCount; i > 0; --i) {
                        LivingEntity le;
                        if (entities == null) continue;
                        Random rand = new Random();
                        String randomSpell = (String)list.get(rand.nextInt(list.size()));
                        if (!(entities instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entities, player)) continue;
                        SignatureAbilities.castSpellEngineIndirectTarget(player, randomSpell, 512, (Entity)le, HelperMethods.getBlockLookingAt(player, 256));
                    }
                }
                Random rand = new Random();
                String randomSpell = (String)list.get(rand.nextInt(list.size()));
                SignatureAbilities.castSpellEngineIndirectTarget(player, randomSpell, 512, null, HelperMethods.getBlockLookingAt(player, 256));
            }
            return true;
        }
        return false;
    }

    public static boolean effectRangerMarksman(Player player) {
        if (player.m_21023_(EffectRegistry.MARKSMAN)) {
            LivingEntity livingTarget;
            Entity target = null;
            int targetingRange = SimplySkills.rangerConfig.effectRangerElementalArrowsTargetingRange;
            if (HelperMethods.getTargetedEntity((Entity)player, targetingRange) != null) {
                target = HelperMethods.getTargetedEntity((Entity)player, targetingRange);
            }
            if (target instanceof LivingEntity && !HelperMethods.checkFriendlyFire(livingTarget = (LivingEntity)target, player)) {
                target = null;
            }
            String spell = "simplyskills:physical_bow_snipe";
            SignatureAbilities.castSpellEngineIndirectTarget(player, spell, 512, target, HelperMethods.getBlockLookingAt(player, 256));
            HelperMethods.decrementStatusEffect((LivingEntity)player, EffectRegistry.MARKSMAN);
            return true;
        }
        return false;
    }

    public static boolean effectRangerArrowRain(Player player) {
        if (player.m_21023_(EffectRegistry.ARROWRAIN)) {
            Entity target;
            BlockPos blockpos2;
            int arrowRainRadius = SimplySkills.rangerConfig.effectRangerArrowRainRadius;
            int arrowRainRadiusIncrease = SimplySkills.rangerConfig.effectRangerArrowRainRadiusIncreasePerTier;
            int arrowRainChance = SimplySkills.rangerConfig.effectRangerArrowRainArrowDensity;
            int arrowRainVolleys = SimplySkills.rangerConfig.effectRangerArrowRainVolleys;
            int arrowRainVolleyIncrease = SimplySkills.rangerConfig.effectRangerArrowRainVolleyIncreasePerTier;
            int arrowRainRange = SimplySkills.rangerConfig.effectRangerArrowRainRange;
            boolean preventShotgun = false;
            int projectileLimiter = 0;
            int projectileLimiterCap = 30;
            if (HelperMethods.isUnlocked("simplyskills:ranger", SkillReferencePosition.rangerSpecialisationArrowRainRadiusOne, (LivingEntity)player)) {
                arrowRainRadius += arrowRainRadiusIncrease;
            } else if (HelperMethods.isUnlocked("simplyskills:ranger", SkillReferencePosition.rangerSpecialisationArrowRainRadiusTwo, (LivingEntity)player)) {
                arrowRainRadius += arrowRainRadiusIncrease * 2;
            } else if (HelperMethods.isUnlocked("simplyskills:ranger", SkillReferencePosition.rangerSpecialisationArrowRainRadiusThree, (LivingEntity)player)) {
                arrowRainRadius += arrowRainRadiusIncrease * 3;
            }
            if (HelperMethods.isUnlocked("simplyskills:ranger", SkillReferencePosition.rangerSpecialisationArrowRainVolleyOne, (LivingEntity)player)) {
                arrowRainVolleys += arrowRainVolleyIncrease;
            } else if (HelperMethods.isUnlocked("simplyskills:ranger", SkillReferencePosition.rangerSpecialisationArrowRainVolleyTwo, (LivingEntity)player)) {
                arrowRainVolleys += arrowRainVolleyIncrease * 2;
            } else if (HelperMethods.isUnlocked("simplyskills:ranger", SkillReferencePosition.rangerSpecialisationArrowRainVolleyThree, (LivingEntity)player)) {
                arrowRainVolleys += arrowRainVolleyIncrease * 3;
            }
            Vec3 blockpos = HelperMethods.getPositionLookingAt(player, arrowRainRange);
            if (blockpos == null && (blockpos2 = HelperMethods.getBlockLookingAt(player, arrowRainRange)) != null && (target = EntityRegistry.SPELL_TARGET_ENTITY.m_262496_((ServerLevel)player.m_9236_(), blockpos2, MobSpawnType.TRIGGERED)) != null) {
                blockpos = target.m_20182_();
            }
            if (blockpos != null) {
                int xpos = (int)blockpos.m_7096_() - arrowRainRadius;
                int ypos = (int)blockpos.m_7098_();
                int zpos = (int)blockpos.m_7094_() - arrowRainRadius;
                for (int x = arrowRainRadius * 2; x > 0; --x) {
                    for (int z = arrowRainRadius * 2; z > 0; --z) {
                        for (int i = arrowRainVolleys; i > 0; --i) {
                            BlockPos spawnPosition = new BlockPos(xpos + x, ypos + 25 + (player.m_217043_().m_188503_(15) * arrowRainVolleys + 1), zpos + z);
                            if (player.m_217043_().m_188503_(100) >= arrowRainChance || !player.m_9236_().m_8055_(spawnPosition).m_60795_()) continue;
                            SimplySkillsArrowEntity arrowEntity = new SimplySkillsArrowEntity((EntityType<? extends Arrow>)EntityType.f_20548_, player.m_9236_());
                            arrowEntity.m_20248_(spawnPosition.m_123341_(), spawnPosition.m_123342_(), spawnPosition.m_123343_());
                            arrowEntity.m_5602_((Entity)player);
                            arrowEntity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                            arrowEntity.m_20334_(0.0, -0.5, 0.0);
                            player.m_9236_().m_7967_((Entity)arrowEntity);
                            if (!HelperMethods.isUnlocked("simplyskills:ranger", SkillReferencePosition.rangerSpecialisationArrowRainElemental, (LivingEntity)player)) continue;
                            BlockPos blockPos = player.m_20183_().m_5484_(player.m_6374_(), 3);
                            AABB box = HelperMethods.createBoxBetween(player.m_20183_(), blockPos, 3);
                            for (Entity entities : player.m_9236_().m_6249_((Entity)player, box, EntitySelector.f_20403_)) {
                                LivingEntity le;
                                if (entities == null || !(entities instanceof LivingEntity) || !HelperMethods.checkFriendlyFire(le = (LivingEntity)entities, player)) continue;
                                preventShotgun = true;
                                projectileLimiterCap = 4;
                            }
                            arrowEntity.m_36870_(new MobEffectInstance(MobEffects.f_19597_));
                            if (preventShotgun && projectileLimiter >= projectileLimiterCap) continue;
                            if (player.m_217043_().m_188503_(100) < 5) {
                                SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:fire_arrow_rain", 512, (Entity)arrowEntity, null);
                                arrowEntity.m_6842_(true);
                                ++projectileLimiter;
                                continue;
                            }
                            if (player.m_217043_().m_188503_(100) < 15) {
                                SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:frost_arrow_rain", 512, (Entity)arrowEntity, null);
                                arrowEntity.m_6842_(true);
                                ++projectileLimiter;
                                continue;
                            }
                            if (player.m_217043_().m_188503_(100) >= 25) continue;
                            SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:lightning_arrow_rain", 512, (Entity)arrowEntity, null);
                            arrowEntity.m_6842_(true);
                            ++projectileLimiter;
                        }
                    }
                }
                HelperMethods.decrementStatusEffect((LivingEntity)player, EffectRegistry.ARROWRAIN);
            }
            return true;
        }
        return false;
    }

    public static void effectWizardFrostVolley(Player player) {
        int frequency = SimplySkills.wizardConfig.signatureWizardIceCometVolleyFrequency;
        if (HelperMethods.isUnlocked("simplyskills:wizard", SkillReferencePosition.wizardSpecialisationIceCometVolley, (LivingEntity)player) && player.m_21023_(EffectRegistry.FROSTVOLLEY) && player.f_19797_ % frequency == 0) {
            LivingEntity livingTarget;
            Entity target = null;
            int volleyRange = SimplySkills.wizardConfig.signatureWizardIceCometVolleyRange;
            if (HelperMethods.getTargetedEntity((Entity)player, volleyRange) != null) {
                target = HelperMethods.getTargetedEntity((Entity)player, volleyRange);
            }
            if (target instanceof LivingEntity && !HelperMethods.checkFriendlyFire(livingTarget = (LivingEntity)target, player)) {
                target = null;
            }
            String spell = "simplyskills:frost_arrow";
            SignatureAbilities.castSpellEngineIndirectTarget(player, spell, volleyRange, target, HelperMethods.getBlockLookingAt(player, volleyRange));
            HelperMethods.decrementStatusEffect((LivingEntity)player, EffectRegistry.FROSTVOLLEY);
        }
    }

    public static void effectWizardArcaneVolley(Player player) {
        int volleyFrequency = SimplySkills.wizardConfig.signatureWizardArcaneBoltVolleyFrequency;
        if (HelperMethods.isUnlocked("simplyskills:wizard", SkillReferencePosition.wizardSpecialisationArcaneBoltVolley, (LivingEntity)player) && player.m_21023_(EffectRegistry.ARCANEVOLLEY) && player.f_19797_ % volleyFrequency == 0) {
            LivingEntity livingTarget;
            Entity target = null;
            int volleyRange = SimplySkills.wizardConfig.signatureWizardArcaneBoltVolleyRange;
            if (HelperMethods.getTargetedEntity((Entity)player, volleyRange) != null) {
                target = HelperMethods.getTargetedEntity((Entity)player, volleyRange);
            }
            if (target instanceof LivingEntity && !HelperMethods.checkFriendlyFire(livingTarget = (LivingEntity)target, player)) {
                target = null;
            }
            String spell = "simplyskills:arcane_bolt_lesser";
            SignatureAbilities.castSpellEngineIndirectTarget(player, spell, volleyRange, target, HelperMethods.getBlockLookingAt(player, volleyRange));
            HelperMethods.decrementStatusEffect((LivingEntity)player, EffectRegistry.ARCANEVOLLEY);
        }
    }

    public static void effectWizardMeteoricWrath(Player player) {
        int frequency = SimplySkills.wizardConfig.signatureWizardMeteoricWrathFrequency;
        if (HelperMethods.isUnlocked("simplyskills:wizard", SkillReferencePosition.wizardSpecialisationMeteorShowerWrath, (LivingEntity)player) && player.m_21023_(EffectRegistry.METEORICWRATH) && player.f_19797_ % frequency == 0) {
            int chance = SimplySkills.wizardConfig.signatureWizardMeteoricWrathChance;
            int radius = SimplySkills.wizardConfig.signatureWizardMeteoricWrathRadius;
            int baseRenewalChance = SimplySkills.wizardConfig.signatureWizardMeteoricWrathRenewalBaseChance;
            int renewalChancePerTier = SimplySkills.wizardConfig.signatureWizardMeteoricWrathRenewalChanceIncreasePerTier;
            String spellIdentifier = "simplyskills:fire_meteor_small";
            if (SignatureAbilities.castSpellEngineAOE(player, spellIdentifier, radius, chance, true)) {
                int renewalChance = 0;
                if (HelperMethods.isUnlocked("simplyskills:wizard", SkillReferencePosition.wizardSpecialisationMeteorShowerRenewingWrath, (LivingEntity)player)) {
                    renewalChance = baseRenewalChance;
                } else if (HelperMethods.isUnlocked("simplyskills:wizard", SkillReferencePosition.wizardSpecialisationMeteorShowerRenewingWrathTwo, (LivingEntity)player)) {
                    renewalChance = baseRenewalChance + renewalChancePerTier;
                } else if (HelperMethods.isUnlocked("simplyskills:wizard", SkillReferencePosition.wizardSpecialisationMeteorShowerRenewingWrathThree, (LivingEntity)player)) {
                    renewalChance = baseRenewalChance + renewalChancePerTier * 2;
                }
                if (player.m_217043_().m_188503_(100) > renewalChance) {
                    HelperMethods.decrementStatusEffect((LivingEntity)player, EffectRegistry.METEORICWRATH);
                }
            }
        }
    }

    public static void effectSpellbladeSpellweaving(Entity target, Player player) {
        int chance = SimplySkills.spellbladeConfig.passiveSpellbladeSpellweavingChance;
        int spellweaverHasteDuration = SimplySkills.spellbladeConfig.signatureSpellbladeSpellweaverHasteDuration;
        int spellweaverHasteStacks = SimplySkills.spellbladeConfig.signatureSpellbladeSpellweaverHasteStacks;
        int spellweaverHasteMaxStacks = SimplySkills.spellbladeConfig.signatureSpellbladeSpellweaverHasteMaxStacks;
        int spellweaverRegenerationDuration = SimplySkills.spellbladeConfig.signatureSpellbladeSpellweaverRegenerationDuration;
        int spellweaverRegenerationStacks = SimplySkills.spellbladeConfig.signatureSpellbladeSpellweaverRegenerationStacks;
        int spellweaverRegenerationMaxStacks = SimplySkills.spellbladeConfig.signatureSpellbladeSpellweaverRegenerationMaxStacks;
        int spellweaverRegenerationChance = SimplySkills.spellbladeConfig.signatureSpellbladeSpellweaverRegenerationChance;
        if (player.m_21023_(EffectRegistry.SPELLWEAVER) && HelperMethods.isUnlocked("simplyskills:spellblade", SkillReferencePosition.spellbladeSpecialisationSpellweaver, (LivingEntity)player)) {
            chance = SimplySkills.spellbladeConfig.signatureSpellbladeSpellweaverChance;
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add("simplyskills:frost_arrow");
        list.add("simplyskills:fire_arrow");
        list.add("simplyskills:lightning_arrow");
        list.add("simplyskills:arcane_bolt");
        list.add("simplyskills:arcane_bolt_lesser");
        list.add("simplyskills:ice_comet");
        list.add("simplyskills:fire_meteor_small");
        list.add("simplyskills:static_discharge");
        if (player.m_21023_(EffectRegistry.SPELLWEAVER)) {
            list.add("simplyskills:physical_swordrain");
            list.add("simplyskills:arcane_slash_projectile");
            list.add("simplyskills:righteous_hammer_projectile");
            list.add("simplyskills:lightning_ball_homing");
            list.add("simplyskills:fire_meteor_large");
        }
        int spellChoice = player.m_217043_().m_188503_(list.size());
        if (target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            if (player.m_217043_().m_188503_(100) < chance) {
                SignatureAbilities.castSpellEngineIndirectTarget(player, (String)list.get(spellChoice), 8, (Entity)livingTarget, HelperMethods.getBlockLookingAt(player, 256));
                if (HelperMethods.isUnlocked("simplyskills:spellblade", SkillReferencePosition.spellbladeSpecialisationSpellweaverHaste, (LivingEntity)player)) {
                    HelperMethods.incrementStatusEffect((LivingEntity)player, MobEffects.f_19598_, spellweaverHasteDuration, spellweaverHasteStacks, spellweaverHasteMaxStacks);
                }
                if (HelperMethods.isUnlocked("simplyskills:spellblade", SkillReferencePosition.spellbladeSpecialisationSpellweaverRegeneration, (LivingEntity)player) && player.m_217043_().m_188503_(100) < spellweaverRegenerationChance) {
                    HelperMethods.incrementStatusEffect((LivingEntity)player, MobEffects.f_19605_, spellweaverRegenerationDuration, spellweaverRegenerationStacks, spellweaverRegenerationMaxStacks);
                }
            }
        }
    }
}

