/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills;

import java.util.ArrayList;
import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.object.builder.v1.entity.FabricDefaultAttributeRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.puffish.skillsmod.api.Category;
import net.puffish.skillsmod.api.SkillsAPI;
import net.sweenus.simplyskills.config.BerserkerConfig;
import net.sweenus.simplyskills.config.ClericConfig;
import net.sweenus.simplyskills.config.ConfigWrapper;
import net.sweenus.simplyskills.config.CrusaderConfig;
import net.sweenus.simplyskills.config.GeneralConfig;
import net.sweenus.simplyskills.config.InitiateConfig;
import net.sweenus.simplyskills.config.NecromancerConfig;
import net.sweenus.simplyskills.config.RangerConfig;
import net.sweenus.simplyskills.config.RogueConfig;
import net.sweenus.simplyskills.config.SpellbladeConfig;
import net.sweenus.simplyskills.config.WarriorConfig;
import net.sweenus.simplyskills.config.WayfarerConfig;
import net.sweenus.simplyskills.config.WizardConfig;
import net.sweenus.simplyskills.entities.DreadglareEntity;
import net.sweenus.simplyskills.entities.GreaterDreadglareEntity;
import net.sweenus.simplyskills.entities.WraithEntity;
import net.sweenus.simplyskills.events.AmethystImbuementEvent;
import net.sweenus.simplyskills.network.KeybindPacket;
import net.sweenus.simplyskills.network.ModPacketHandler;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.registry.EntityRegistry;
import net.sweenus.simplyskills.registry.ItemRegistry;
import net.sweenus.simplyskills.registry.ModelRegistry;
import net.sweenus.simplyskills.registry.SoundRegistry;
import net.sweenus.simplyskills.rewards.PassiveSkillReward;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimplySkills
implements ModInitializer {
    public static final String MOD_ID = "simplyskills";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"simplyskills");
    public static List<String> specialisations = new ArrayList<String>();
    public static GeneralConfig generalConfig;
    public static WayfarerConfig wayfarerConfig;
    public static WarriorConfig warriorConfig;
    public static InitiateConfig initiateConfig;
    public static BerserkerConfig berserkerConfig;
    public static WizardConfig wizardConfig;
    public static SpellbladeConfig spellbladeConfig;
    public static RogueConfig rogueConfig;
    public static RangerConfig rangerConfig;
    public static CrusaderConfig crusaderConfig;
    public static ClericConfig clericConfig;
    public static NecromancerConfig necromancerConfig;

    private static void setSpecialisations() {
        specialisations.add("simplyskills:rogue");
        specialisations.add("simplyskills:ranger");
        specialisations.add("simplyskills:berserker");
        specialisations.add("simplyskills:wizard");
        specialisations.add("simplyskills:spellblade");
        specialisations.add("simplyskills:crusader");
        specialisations.add("simplyskills:cleric");
        specialisations.add("simplyskills:necromancer");
    }

    public static String[] getSpecialisations() {
        return new String[]{"simplyskills:rogue", "simplyskills:ranger", "simplyskills:berserker", "simplyskills:wizard", "simplyskills:spellblade", "simplyskills:crusader", "simplyskills:cleric", "simplyskills:necromancer"};
    }

    public static List<String> getSpecialisationsAsArray() {
        return specialisations;
    }

    public void onInitialize() {
        AutoConfig.register(ConfigWrapper.class, (ConfigSerializer.Factory)PartitioningSerializer.wrap(JanksonConfigSerializer::new));
        generalConfig = ((ConfigWrapper)AutoConfig.getConfigHolder(ConfigWrapper.class).getConfig()).client;
        wayfarerConfig = ((ConfigWrapper)AutoConfig.getConfigHolder(ConfigWrapper.class).getConfig()).wayfarer;
        warriorConfig = ((ConfigWrapper)AutoConfig.getConfigHolder(ConfigWrapper.class).getConfig()).warrior;
        initiateConfig = ((ConfigWrapper)AutoConfig.getConfigHolder(ConfigWrapper.class).getConfig()).initiate;
        berserkerConfig = ((ConfigWrapper)AutoConfig.getConfigHolder(ConfigWrapper.class).getConfig()).berserker;
        wizardConfig = ((ConfigWrapper)AutoConfig.getConfigHolder(ConfigWrapper.class).getConfig()).wizard;
        spellbladeConfig = ((ConfigWrapper)AutoConfig.getConfigHolder(ConfigWrapper.class).getConfig()).spellblade;
        rogueConfig = ((ConfigWrapper)AutoConfig.getConfigHolder(ConfigWrapper.class).getConfig()).rogue;
        rangerConfig = ((ConfigWrapper)AutoConfig.getConfigHolder(ConfigWrapper.class).getConfig()).ranger;
        crusaderConfig = ((ConfigWrapper)AutoConfig.getConfigHolder(ConfigWrapper.class).getConfig()).crusader;
        clericConfig = ((ConfigWrapper)AutoConfig.getConfigHolder(ConfigWrapper.class).getConfig()).cleric;
        necromancerConfig = ((ConfigWrapper)AutoConfig.getConfigHolder(ConfigWrapper.class).getConfig()).necromancer;
        EffectRegistry.registerEffects();
        PassiveSkillReward.register();
        SoundRegistry.registerSounds();
        ItemRegistry.registerItems();
        ModelRegistry.registerModels();
        EntityRegistry.registerEntities();
        KeybindPacket.init();
        ModPacketHandler.registerServer();
        if (FabricLoader.getInstance().isModLoaded("amethyst_core")) {
            AmethystImbuementEvent.registerAIEvents();
        }
        SimplySkills.setSpecialisations();
        FabricDefaultAttributeRegistry.register(EntityRegistry.DREADGLARE, (AttributeSupplier.Builder)DreadglareEntity.createDreadglareAttributes());
        FabricDefaultAttributeRegistry.register(EntityRegistry.GREATER_DREADGLARE, (AttributeSupplier.Builder)GreaterDreadglareEntity.createGreaterDreadglareAttributes());
        FabricDefaultAttributeRegistry.register(EntityRegistry.WRAITH, (AttributeSupplier.Builder)WraithEntity.createWraithAttributes());
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            if (SimplySkills.generalConfig.disableDefaultPuffishTrees) {
                this.processPlayer(handler.f_9743_);
            }
            ModPacketHandler.sendSignatureAbility(handler.f_9743_);
        });
    }

    private void processPlayer(ServerPlayer player) {
        SkillsAPI.streamUnlockedCategories((ServerPlayer)player).forEach(category -> this.processCategory(player, (Category)category));
    }

    private void processCategory(ServerPlayer player, Category category) {
        String categoryId = category.getId().toString();
        if (categoryId.equals("puffish_skills:combat") || categoryId.equals("puffish_skills:mining")) {
            SkillsAPI.getCategory((ResourceLocation)new ResourceLocation(categoryId)).ifPresent(categoryObj -> {
                categoryObj.erase(player);
                categoryObj.lock(player);
            });
        }
        if (FabricLoader.getInstance().isModLoaded("prominent") && categoryId.equals("simplyskills:tree")) {
            SkillsAPI.getCategory((ResourceLocation)new ResourceLocation(categoryId)).ifPresent(categoryObj -> {
                categoryObj.erase(player);
                categoryObj.lock(player);
            });
        }
    }
}

