/*
 * Decompiled with CFR 0.152.
 */
package artifacts.item.wearable.necklace;

import artifacts.item.wearable.necklace.PendantItem;
import artifacts.registry.ModGameRules;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.EntityEvent;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class ShockPendantItem
extends PendantItem {
    public ShockPendantItem() {
        super(ModGameRules.SHOCK_PENDANT_STRIKE_CHANCE, ModGameRules.SHOCK_PENDANT_COOLDOWN);
        EntityEvent.LIVING_HURT.register(this::onLivingHurt);
    }

    @Override
    public boolean hasNonCosmeticEffects() {
        return super.hasNonCosmeticEffects() || ModGameRules.SHOCK_PENDANT_DO_CANCEL_LIGHTNING_DAMAGE.get() != false;
    }

    @Override
    protected void addEffectsTooltip(ItemStack stack, List<MutableComponent> tooltip) {
        if (ModGameRules.SHOCK_PENDANT_STRIKE_CHANCE.get() > 0.0) {
            tooltip.add(this.tooltipLine("strike_chance", new Object[0]));
        }
        if (ModGameRules.SHOCK_PENDANT_DO_CANCEL_LIGHTNING_DAMAGE.get().booleanValue()) {
            tooltip.add(this.tooltipLine("lightning_damage", new Object[0]));
        }
    }

    @Override
    protected EventResult onLivingHurt(LivingEntity entity, DamageSource damageSource, float amount) {
        if (this.isEquippedBy(entity) && !entity.m_9236_().m_5776_() && ModGameRules.SHOCK_PENDANT_DO_CANCEL_LIGHTNING_DAMAGE.get().booleanValue() && amount > 0.0f && damageSource.m_269533_(DamageTypeTags.f_268725_)) {
            return EventResult.interruptFalse();
        }
        return super.onLivingHurt(entity, damageSource, amount);
    }

    @Override
    protected void applyEffect(LivingEntity target, LivingEntity attacker) {
        LightningBolt lightningBolt;
        if (attacker.m_9236_().m_45527_(BlockPos.m_274446_((Position)attacker.m_20182_())) && (lightningBolt = (LightningBolt)EntityType.f_20465_.m_20615_(attacker.m_9236_())) != null) {
            ServerPlayer player;
            lightningBolt.m_20219_(Vec3.m_82539_((Vec3i)attacker.m_20183_()));
            lightningBolt.m_20879_(attacker instanceof ServerPlayer ? (player = (ServerPlayer)attacker) : null);
            attacker.m_9236_().m_7967_((Entity)lightningBolt);
        }
    }
}

