/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.entity.util;

import com.github.alexthe666.iceandfire.IafConfig;
import com.github.alexthe666.iceandfire.block.IafBlockRegistry;
import com.github.alexthe666.iceandfire.datagen.tags.IafBlockTags;
import com.github.alexthe666.iceandfire.entity.EntityCockatrice;
import com.github.alexthe666.iceandfire.entity.EntityDragonBase;
import com.github.alexthe666.iceandfire.entity.EntityGhost;
import com.github.alexthe666.iceandfire.entity.EntityGorgon;
import com.github.alexthe666.iceandfire.entity.EntityHippogryph;
import com.github.alexthe666.iceandfire.entity.EntityMutlipartPart;
import com.github.alexthe666.iceandfire.entity.EntitySeaSerpent;
import com.github.alexthe666.iceandfire.entity.EntityStymphalianBird;
import com.github.alexthe666.iceandfire.entity.util.IDeadMob;
import com.github.alexthe666.iceandfire.misc.IafTagRegistry;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;

public class DragonUtils {
    public static BlockPos getBlockInViewEscort(EntityDragonBase dragon) {
        BlockPos escortPos = dragon.getEscortPosition();
        BlockPos ground = dragon.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, escortPos);
        int distFromGround = escortPos.m_123342_() - ground.m_123342_();
        for (int i = 0; i < 10; ++i) {
            BlockPos pos = new BlockPos(escortPos.m_123341_() + dragon.m_217043_().m_188503_(IafConfig.dragonWanderFromHomeDistance) - IafConfig.dragonWanderFromHomeDistance / 2, distFromGround > 16 ? escortPos.m_123342_() : escortPos.m_123342_() + 8 + dragon.m_217043_().m_188503_(16), escortPos.m_123343_() + dragon.m_217043_().m_188503_(IafConfig.dragonWanderFromHomeDistance) - IafConfig.dragonWanderFromHomeDistance / 2);
            if (!(dragon.getDistanceSquared(Vec3.m_82512_((Vec3i)pos)) > 6.0f) || dragon.isTargetBlocked(Vec3.m_82512_((Vec3i)pos))) continue;
            return pos;
        }
        return null;
    }

    public static BlockPos getWaterBlockInViewEscort(EntityDragonBase dragon) {
        BlockPos inWaterEscortPos = dragon.getEscortPosition();
        if (Math.abs(dragon.m_20185_() - (double)inWaterEscortPos.m_123341_()) < dragon.m_20191_().m_82362_() && Math.abs(dragon.m_20189_() - (double)inWaterEscortPos.m_123343_()) < dragon.m_20191_().m_82385_()) {
            return dragon.m_20183_();
        }
        if ((double)inWaterEscortPos.m_123342_() - dragon.m_20186_() > (double)(8 + dragon.getYNavSize()) && !dragon.m_9236_().m_6425_(inWaterEscortPos.m_7495_()).m_205070_(FluidTags.f_13131_)) {
            dragon.setHovering(true);
        }
        return inWaterEscortPos;
    }

    public static BlockPos getBlockInView(EntityDragonBase dragon) {
        BlockPos pos;
        float radius = 12.0f * (0.7f * dragon.getRenderSize() / 3.0f);
        float neg = dragon.m_217043_().m_188499_() ? 1.0f : -1.0f;
        float renderYawOffset = dragon.f_20883_;
        if (dragon.hasHomePosition && dragon.homePos != null) {
            BlockPos dragonPos = dragon.m_20183_();
            BlockPos ground = dragon.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, dragonPos);
            int distFromGround = (int)dragon.m_20186_() - ground.m_123342_();
            for (int i = 0; i < 10; ++i) {
                BlockPos homePos = dragon.homePos.getPosition();
                BlockPos pos2 = new BlockPos(homePos.m_123341_() + dragon.m_217043_().m_188503_(IafConfig.dragonWanderFromHomeDistance * 2) - IafConfig.dragonWanderFromHomeDistance, distFromGround > 16 ? (int)Math.min((double)IafConfig.maxDragonFlight, dragon.m_20186_() + (double)dragon.m_217043_().m_188503_(16) - 8.0) : (int)dragon.m_20186_() + dragon.m_217043_().m_188503_(16) + 1, homePos.m_123343_() + dragon.m_217043_().m_188503_(IafConfig.dragonWanderFromHomeDistance * 2) - IafConfig.dragonWanderFromHomeDistance);
                if (!(dragon.getDistanceSquared(Vec3.m_82512_((Vec3i)pos2)) > 6.0f) || dragon.isTargetBlocked(Vec3.m_82512_((Vec3i)pos2))) continue;
                return pos2;
            }
        }
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + dragon.m_217043_().m_188501_() * neg;
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        BlockPos radialPos = BlockPos.m_274561_((double)(dragon.m_20185_() + extraX), (double)0.0, (double)(dragon.m_20189_() + extraZ));
        BlockPos ground = dragon.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, radialPos);
        int distFromGround = (int)dragon.m_20186_() - ground.m_123342_();
        BlockPos newPos = radialPos.m_6630_(distFromGround > 16 ? (int)Math.min((double)IafConfig.maxDragonFlight, dragon.m_20186_() + (double)dragon.m_217043_().m_188503_(16) - 8.0) : (int)dragon.m_20186_() + dragon.m_217043_().m_188503_(16) + 1);
        BlockPos blockPos = pos = dragon.doesWantToLand() ? ground : newPos;
        if (dragon.getDistanceSquared(Vec3.m_82512_((Vec3i)newPos)) > 6.0f && !dragon.isTargetBlocked(Vec3.m_82512_((Vec3i)newPos))) {
            return pos;
        }
        return null;
    }

    public static BlockPos getWaterBlockInView(EntityDragonBase dragon) {
        BlockPos surface;
        float radius = 0.75f * (0.7f * dragon.getRenderSize() / 3.0f) * -7.0f - (float)dragon.m_217043_().m_188503_(dragon.getDragonStage() * 6);
        float neg = dragon.m_217043_().m_188499_() ? 1.0f : -1.0f;
        float angle = (float)Math.PI / 180 * dragon.f_20883_ + 3.15f + dragon.m_217043_().m_188501_() * neg;
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        BlockPos radialPos = BlockPos.m_274561_((double)(dragon.m_20185_() + extraX), (double)0.0, (double)(dragon.m_20189_() + extraZ));
        BlockPos ground = dragon.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, radialPos);
        int distFromGround = (int)dragon.m_20186_() - ground.m_123342_();
        BlockPos newPos = radialPos.m_6630_(distFromGround > 16 ? (int)Math.min((double)IafConfig.maxDragonFlight, dragon.m_20186_() + (double)dragon.m_217043_().m_188503_(16) - 8.0) : (int)dragon.m_20186_() + dragon.m_217043_().m_188503_(16) + 1);
        BlockPos pos = dragon.doesWantToLand() ? ground : newPos;
        BlockPos blockPos = surface = dragon.m_9236_().m_6425_(newPos.m_6625_(2)).m_205070_(FluidTags.f_13131_) ? newPos.m_6625_(dragon.m_217043_().m_188503_(10) + 1) : newPos;
        if (dragon.getDistanceSquared(Vec3.m_82512_((Vec3i)surface)) > 6.0f && dragon.m_9236_().m_6425_(surface).m_205070_(FluidTags.f_13131_)) {
            return surface;
        }
        return null;
    }

    public static LivingEntity riderLookingAtEntity(final LivingEntity dragon, LivingEntity rider, double dist) {
        Vec3 Vector3d = rider.m_20299_(1.0f);
        Vec3 Vector3d1 = rider.m_20252_(1.0f);
        Vec3 Vector3d2 = Vector3d.m_82520_(Vector3d1.f_82479_ * dist, Vector3d1.f_82480_ * dist, Vector3d1.f_82481_ * dist);
        double d1 = dist;
        Entity pointedEntity = null;
        List list = rider.m_9236_().m_6249_((Entity)rider, rider.m_20191_().m_82363_(Vector3d1.f_82479_ * dist, Vector3d1.f_82480_ * dist, Vector3d1.f_82481_ * dist).m_82377_(1.0, 1.0, 1.0), (Predicate)new com.google.common.base.Predicate<Entity>(){

            public boolean apply(@Nullable Entity entity) {
                if (DragonUtils.onSameTeam((Entity)dragon, entity)) {
                    return false;
                }
                return entity != null && entity.m_6087_() && entity instanceof LivingEntity && !entity.m_7306_((Entity)dragon) && !entity.m_7307_((Entity)dragon) && (!(entity instanceof IDeadMob) || !((IDeadMob)entity).isMobDead());
            }
        });
        double d2 = d1;
        for (int j = 0; j < list.size(); ++j) {
            double d3;
            Entity entity1 = (Entity)list.get(j);
            AABB axisalignedbb = entity1.m_20191_().m_82400_((double)entity1.m_6143_() + 2.0);
            Vec3 raytraceresult = axisalignedbb.m_82371_(Vector3d, Vector3d2).orElse(Vec3.f_82478_);
            if (axisalignedbb.m_82390_(Vector3d)) {
                if (!(d2 >= 0.0)) continue;
                pointedEntity = entity1;
                d2 = 0.0;
                continue;
            }
            if (raytraceresult == null || !((d3 = Vector3d.m_82554_(raytraceresult)) < d2) && d2 != 0.0) continue;
            if (entity1.m_20201_() == rider.m_20201_() && !rider.canRiderInteract()) {
                if (d2 != 0.0) continue;
                pointedEntity = entity1;
                continue;
            }
            pointedEntity = entity1;
            d2 = d3;
        }
        return (LivingEntity)pointedEntity;
    }

    public static BlockPos getBlockInViewHippogryph(EntityHippogryph hippo, float yawAddition) {
        BlockPos pos;
        int distFromGround;
        BlockPos ground;
        float radius = -12.599999f - (float)hippo.m_217043_().m_188503_(48);
        float neg = hippo.m_217043_().m_188499_() ? 1.0f : -1.0f;
        float angle = (float)Math.PI / 180 * (hippo.f_20883_ + yawAddition) + 3.15f + hippo.m_217043_().m_188501_() * neg;
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        if (hippo.hasHomePosition && hippo.homePos != null) {
            BlockPos dragonPos = hippo.m_20183_();
            ground = hippo.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, dragonPos);
            distFromGround = (int)hippo.m_20186_() - ground.m_123342_();
            for (int i = 0; i < 10; ++i) {
                pos = BlockPos.m_274561_((double)(hippo.homePos.m_123341_() + hippo.m_217043_().m_188503_(IafConfig.dragonWanderFromHomeDistance) - IafConfig.dragonWanderFromHomeDistance), (double)(distFromGround > 16 ? (int)Math.min((double)IafConfig.maxDragonFlight, hippo.m_20186_() + (double)hippo.m_217043_().m_188503_(16) - 8.0) : (int)hippo.m_20186_() + hippo.m_217043_().m_188503_(16) + 1), (double)(hippo.homePos.m_123343_() + hippo.m_217043_().m_188503_(IafConfig.dragonWanderFromHomeDistance * 2) - IafConfig.dragonWanderFromHomeDistance));
                if (!(hippo.getDistanceSquared(Vec3.m_82512_((Vec3i)pos)) > 6.0f) || hippo.isTargetBlocked(Vec3.m_82512_((Vec3i)pos))) continue;
                return pos;
            }
        }
        BlockPos radialPos = BlockPos.m_274561_((double)(hippo.m_20185_() + extraX), (double)0.0, (double)(hippo.m_20189_() + extraZ));
        ground = hippo.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, radialPos);
        distFromGround = (int)hippo.m_20186_() - ground.m_123342_();
        BlockPos newPos = radialPos.m_6630_(distFromGround > 16 ? (int)Math.min((double)IafConfig.maxDragonFlight, hippo.m_20186_() + (double)hippo.m_217043_().m_188503_(16) - 8.0) : (int)hippo.m_20186_() + hippo.m_217043_().m_188503_(16) + 1);
        BlockPos blockPos = pos = hippo.doesWantToLand() ? ground : newPos;
        if (!hippo.isTargetBlocked(Vec3.m_82512_((Vec3i)newPos)) && hippo.getDistanceSquared(Vec3.m_82512_((Vec3i)newPos)) > 6.0f) {
            return newPos;
        }
        return null;
    }

    public static BlockPos getBlockInViewStymphalian(EntityStymphalianBird bird) {
        float radius = -9.45f - (float)bird.m_217043_().m_188503_(24);
        float neg = bird.m_217043_().m_188499_() ? 1.0f : -1.0f;
        float renderYawOffset = bird.flock != null && !bird.flock.isLeader(bird) ? DragonUtils.getStymphalianFlockDirection(bird) : bird.f_20883_;
        float angle = (float)Math.PI / 180 * renderYawOffset + 3.15f + bird.m_217043_().m_188501_() * neg;
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        BlockPos radialPos = DragonUtils.getStymphalianFearPos(bird, BlockPos.m_274561_((double)(bird.m_20185_() + extraX), (double)0.0, (double)(bird.m_20189_() + extraZ)));
        BlockPos ground = bird.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, radialPos);
        int distFromGround = (int)bird.m_20186_() - ground.m_123342_();
        int flightHeight = Math.min(IafConfig.stymphalianBirdFlightHeight, ground.m_123342_() + bird.m_217043_().m_188503_(16));
        BlockPos newPos = radialPos.m_6630_(distFromGround > 16 ? flightHeight : (int)bird.m_20186_() + bird.m_217043_().m_188503_(16) + 1);
        if (bird.getDistanceSquared(Vec3.m_82512_((Vec3i)newPos)) > 6.0f && !bird.isTargetBlocked(Vec3.m_82512_((Vec3i)newPos))) {
            return newPos;
        }
        return null;
    }

    private static BlockPos getStymphalianFearPos(EntityStymphalianBird bird, BlockPos fallback) {
        Vec3 Vector3d;
        if (bird.getVictor() != null && bird.getVictor() instanceof PathfinderMob && (Vector3d = DefaultRandomPos.m_148407_((PathfinderMob)((PathfinderMob)bird.getVictor()), (int)16, (int)IafConfig.stymphalianBirdFlightHeight, (Vec3)new Vec3(bird.getVictor().m_20185_(), bird.getVictor().m_20186_(), bird.getVictor().m_20189_()))) != null) {
            BlockPos pos = BlockPos.m_274446_((Position)Vector3d);
            return new BlockPos(pos.m_123341_(), 0, pos.m_123343_());
        }
        return fallback;
    }

    private static float getStymphalianFlockDirection(EntityStymphalianBird bird) {
        EntityStymphalianBird leader = bird.flock.getLeader();
        if (bird.m_20280_((Entity)leader) > 2.0) {
            double d0 = leader.m_20185_() - bird.m_20185_();
            double d2 = leader.m_20189_() - bird.m_20189_();
            float f = (float)(Mth.m_14136_((double)d2, (double)d0) * 57.29577951308232) - 90.0f;
            float degrees = Mth.m_14177_((float)(f - bird.m_146908_()));
            return bird.m_146908_() + degrees;
        }
        return leader.f_20883_;
    }

    public static BlockPos getBlockInTargetsViewCockatrice(EntityCockatrice cockatrice, LivingEntity target) {
        float radius = 10 + cockatrice.m_217043_().m_188503_(10);
        float angle = (float)Math.PI / 180 * target.f_20885_;
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        BlockPos radialPos = BlockPos.m_274561_((double)(target.m_20185_() + extraX), (double)0.0, (double)(target.m_20189_() + extraZ));
        BlockPos ground = target.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, radialPos);
        if (cockatrice.m_20238_(Vec3.m_82512_((Vec3i)ground)) > 30.0 && !cockatrice.isTargetBlocked(Vec3.m_82512_((Vec3i)ground))) {
            return ground;
        }
        return target.m_20183_();
    }

    public static BlockPos getBlockInTargetsViewGhost(EntityGhost ghost, LivingEntity target) {
        float radius = 4 + ghost.m_217043_().m_188503_(5);
        float angle = (float)Math.PI / 180 * (target.f_20885_ + 90.0f + (float)ghost.m_217043_().m_188503_(180));
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        BlockPos radialPos = BlockPos.m_274561_((double)(target.m_20185_() + extraX), (double)target.m_20186_(), (double)(target.m_20189_() + extraZ));
        BlockPos ground = radialPos;
        if (ghost.m_20238_(Vec3.m_82512_((Vec3i)ground)) > 30.0) {
            return ground;
        }
        return ghost.m_20183_();
    }

    public static BlockPos getBlockInTargetsViewGorgon(EntityGorgon cockatrice, LivingEntity target) {
        float radius = 6.0f;
        float angle = (float)Math.PI / 180 * target.f_20885_;
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        BlockPos radialPos = BlockPos.m_274561_((double)(target.m_20185_() + extraX), (double)target.m_20186_(), (double)(target.m_20189_() + extraZ));
        if (cockatrice.m_20238_(Vec3.m_82512_((Vec3i)radialPos)) < 300.0 && !cockatrice.isTargetBlocked(Vec3.m_82512_((Vec3i)radialPos).m_82520_(0.0, 0.75, 0.0))) {
            return radialPos;
        }
        return target.m_20183_();
    }

    public static BlockPos getBlockInTargetsViewSeaSerpent(EntitySeaSerpent serpent, LivingEntity target) {
        float radius = 10.0f * serpent.getSeaSerpentScale() + (float)serpent.m_217043_().m_188503_(10);
        float angle = (float)Math.PI / 180 * target.f_20885_;
        double extraX = radius * Mth.m_14031_((float)((float)(Math.PI + (double)angle)));
        double extraZ = radius * Mth.m_14089_((float)angle);
        BlockPos radialPos = BlockPos.m_274561_((double)(target.m_20185_() + extraX), (double)0.0, (double)(target.m_20189_() + extraZ));
        BlockPos ground = target.m_9236_().m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, radialPos);
        if (serpent.m_20238_(Vec3.m_82512_((Vec3i)ground)) > 30.0) {
            return ground;
        }
        return target.m_20183_();
    }

    public static boolean canTameDragonAttack(TamableAnimal dragon, Entity entity) {
        if (DragonUtils.isVillager(entity)) {
            return false;
        }
        if (entity instanceof AbstractVillager || entity instanceof AbstractGolem || entity instanceof Player) {
            return false;
        }
        if (entity instanceof TamableAnimal) {
            return !((TamableAnimal)entity).m_21824_();
        }
        return true;
    }

    public static boolean isVillager(Entity entity) {
        ITagManager tags = ForgeRegistries.ENTITY_TYPES.tags();
        if (tags == null) {
            return false;
        }
        return entity.m_6095_().m_204039_(tags.createTagKey(IafTagRegistry.VILLAGERS));
    }

    public static boolean isAnimaniaMob(Entity entity) {
        return false;
    }

    public static boolean isDragonTargetable(Entity entity, ResourceLocation tag) {
        return entity.m_6095_().m_204039_(ForgeRegistries.ENTITY_TYPES.tags().createTagKey(tag));
    }

    public static String getDimensionName(Level world) {
        return world.m_46472_().m_135782_().toString();
    }

    public static boolean isInHomeDimension(EntityDragonBase dragonBase) {
        return dragonBase.getHomeDimensionName() == null || DragonUtils.getDimensionName(dragonBase.m_9236_()).equals(dragonBase.getHomeDimensionName());
    }

    public static boolean canDragonBreak(BlockState state, Entity entity) {
        if (!ForgeEventFactory.getMobGriefingEvent((Level)entity.m_9236_(), (Entity)entity)) {
            return false;
        }
        Block block = state.m_60734_();
        return block.m_7325_() < 1200.0f && !state.m_204336_(IafBlockTags.DRAGON_BLOCK_BREAK_BLACKLIST);
    }

    public static boolean hasSameOwner(TamableAnimal cockatrice, Entity entity) {
        if (entity instanceof TamableAnimal) {
            TamableAnimal tameable = (TamableAnimal)entity;
            return tameable.m_21805_() != null && cockatrice.m_21805_() != null && tameable.m_21805_().equals(cockatrice.m_21805_());
        }
        return false;
    }

    public static boolean isAlive(LivingEntity entity) {
        IDeadMob deadMob;
        EntityDragonBase dragon;
        if (entity instanceof EntityDragonBase && (dragon = (EntityDragonBase)entity).isMobDead()) {
            return false;
        }
        return (!(entity instanceof IDeadMob) || !(deadMob = (IDeadMob)entity).isMobDead()) && !EntityGorgon.isStoneMob(entity);
    }

    public static boolean canGrief(EntityDragonBase dragon) {
        if (dragon.m_21824_() && !IafConfig.tamedDragonGriefing) {
            return false;
        }
        return IafConfig.dragonGriefing < 2;
    }

    public static boolean canHostilesTarget(Entity entity) {
        if (entity instanceof Player && (entity.m_9236_().m_46791_() == Difficulty.PEACEFUL || ((Player)entity).m_7500_())) {
            return false;
        }
        if (entity instanceof EntityDragonBase && ((EntityDragonBase)entity).isMobDead()) {
            return false;
        }
        return entity instanceof LivingEntity && DragonUtils.isAlive((LivingEntity)entity);
    }

    public static boolean onSameTeam(Entity entity1, Entity entity2) {
        Entity multipart;
        LivingEntity owner1 = null;
        LivingEntity owner2 = null;
        boolean def = entity1.m_7307_(entity2);
        if (entity1 instanceof TamableAnimal) {
            owner1 = ((TamableAnimal)entity1).m_269323_();
        }
        if (entity2 instanceof TamableAnimal) {
            owner2 = ((TamableAnimal)entity2).m_269323_();
        }
        if (entity1 instanceof EntityMutlipartPart && (multipart = ((EntityMutlipartPart)entity1).getParent()) != null && multipart instanceof TamableAnimal) {
            owner1 = ((TamableAnimal)multipart).m_269323_();
        }
        if (entity2 instanceof EntityMutlipartPart && (multipart = ((EntityMutlipartPart)entity2).getParent()) != null && multipart instanceof TamableAnimal) {
            owner2 = ((TamableAnimal)multipart).m_269323_();
        }
        if (owner1 != null && owner2 != null) {
            return owner1.m_7306_((Entity)owner2);
        }
        return def;
    }

    public static boolean isDreadBlock(BlockState state) {
        Block block = state.m_60734_();
        return block == IafBlockRegistry.DREAD_STONE.get() || block == IafBlockRegistry.DREAD_STONE_BRICKS.get() || block == IafBlockRegistry.DREAD_STONE_BRICKS_CHISELED.get() || block == IafBlockRegistry.DREAD_STONE_BRICKS_CRACKED.get() || block == IafBlockRegistry.DREAD_STONE_BRICKS_MOSSY.get() || block == IafBlockRegistry.DREAD_STONE_TILE.get() || block == IafBlockRegistry.DREAD_STONE_FACE.get() || block == IafBlockRegistry.DREAD_TORCH.get() || block == IafBlockRegistry.DREAD_STONE_BRICKS_STAIRS.get() || block == IafBlockRegistry.DREAD_STONE_BRICKS_SLAB.get() || block == IafBlockRegistry.DREADWOOD_LOG.get() || block == IafBlockRegistry.DREADWOOD_PLANKS.get() || block == IafBlockRegistry.DREADWOOD_PLANKS_LOCK.get() || block == IafBlockRegistry.DREAD_PORTAL.get() || block == IafBlockRegistry.DREAD_SPAWNER.get();
    }
}

