/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe666.iceandfire.client.render.entity.layer;

import com.github.alexthe666.iceandfire.client.model.ModelBipedBase;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;

public class LayerBipedArmor<T extends LivingEntity, M extends ModelBipedBase<T>, A extends ModelBipedBase<T>>
extends RenderLayer<T, M> {
    private final A modelLeggings;
    private final A modelArmor;
    private final ResourceLocation defaultLegArmor;
    private final ResourceLocation defaultArmor;

    public LayerBipedArmor(RenderLayerParent<T, M> mobRenderer, A modelLeggings, A modelArmor, ResourceLocation defaultArmor, ResourceLocation defaultLegArmor) {
        super(mobRenderer);
        this.modelLeggings = modelLeggings;
        this.modelArmor = modelArmor;
        this.defaultLegArmor = defaultLegArmor;
        this.defaultArmor = defaultArmor;
    }

    public void render(@NotNull PoseStack matrixStackIn, @NotNull MultiBufferSource bufferIn, int packedLightIn, @NotNull T entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        this.renderEquipment(matrixStackIn, bufferIn, entitylivingbaseIn, EquipmentSlot.CHEST, packedLightIn, this.getSlotModel(EquipmentSlot.CHEST));
        this.renderEquipment(matrixStackIn, bufferIn, entitylivingbaseIn, EquipmentSlot.LEGS, packedLightIn, this.getSlotModel(EquipmentSlot.LEGS));
        this.renderEquipment(matrixStackIn, bufferIn, entitylivingbaseIn, EquipmentSlot.FEET, packedLightIn, this.getSlotModel(EquipmentSlot.FEET));
        this.renderEquipment(matrixStackIn, bufferIn, entitylivingbaseIn, EquipmentSlot.HEAD, packedLightIn, this.getSlotModel(EquipmentSlot.HEAD));
    }

    private void renderEquipment(PoseStack matrixStackIn, MultiBufferSource bufferIn, T entityIn, EquipmentSlot slotType, int packedLightIn, A modelIn) {
        ArmorItem armoritem;
        ItemStack itemstack = entityIn.m_6844_(slotType);
        if (itemstack.m_41720_() instanceof ArmorItem && (armoritem = (ArmorItem)itemstack.m_41720_()).m_40402_() == slotType) {
            ((ModelBipedBase)this.m_117386_()).setModelAttributes(modelIn);
            this.setModelSlotVisible(modelIn, slotType);
            boolean flag1 = itemstack.m_41790_();
            this.renderArmorItem(matrixStackIn, bufferIn, packedLightIn, flag1, modelIn, 1.0f, 1.0f, 1.0f, this.getArmorResource(entityIn, itemstack, slotType, null));
        }
    }

    protected void setModelSlotVisible(A modelIn, EquipmentSlot slotIn) {
        ((ModelBipedBase)modelIn).setVisible(false);
        switch (slotIn) {
            case HEAD: {
                ((ModelBipedBase)modelIn).head.invisible = false;
                ((ModelBipedBase)modelIn).headware.invisible = false;
                break;
            }
            case CHEST: {
                ((ModelBipedBase)modelIn).body.invisible = false;
                ((ModelBipedBase)modelIn).armRight.invisible = false;
                ((ModelBipedBase)modelIn).armLeft.invisible = false;
                break;
            }
            case LEGS: {
                ((ModelBipedBase)modelIn).body.invisible = false;
                ((ModelBipedBase)modelIn).legRight.invisible = false;
                ((ModelBipedBase)modelIn).legLeft.invisible = false;
                break;
            }
            case FEET: {
                ((ModelBipedBase)modelIn).legRight.invisible = false;
                ((ModelBipedBase)modelIn).legLeft.invisible = false;
            }
        }
    }

    private void renderArmorItem(PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn, boolean p_241738_5_, A modelIn, float red, float green, float blue, ResourceLocation armorResource) {
        VertexConsumer ivertexbuilder = ItemRenderer.m_115184_((MultiBufferSource)bufferIn, (RenderType)RenderType.m_110431_((ResourceLocation)armorResource), (boolean)false, (boolean)p_241738_5_);
        modelIn.m_7695_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.f_118083_, red, green, blue, 1.0f);
    }

    private A getSlotModel(EquipmentSlot equipmentSlotType) {
        return this.isLegSlot(equipmentSlotType) ? this.modelLeggings : this.modelArmor;
    }

    protected boolean isLegSlot(EquipmentSlot slotIn) {
        return slotIn == EquipmentSlot.LEGS;
    }

    public ResourceLocation getArmorResource(T entity, ItemStack stack, EquipmentSlot slot, @Nullable String type) {
        if (this.isLegSlot(slot)) {
            return this.defaultLegArmor;
        }
        return this.defaultArmor;
    }
}

