/*
 * Decompiled with CFR 0.152.
 */
package net.spell_power.internals;

import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.enchantment.SpellPowerEnchanting;
import net.spell_power.config.EnchantmentsConfig;
import net.spell_power.internals.AmplifierEnchantment;

public class SchoolFilteredEnchantment
extends AmplifierEnchantment {
    private Set<SpellSchool> schools;

    public Set<SpellSchool> poweredSchools() {
        return this.schools;
    }

    public void setPoweredSchools(Set<SpellSchool> schools) {
        this.schools = schools;
    }

    public SchoolFilteredEnchantment(Enchantment.Rarity weight, AmplifierEnchantment.Operation operation, EnchantmentsConfig.PowerEnchantmentConfig config, Set<SpellSchool> schools, EnchantmentCategory type, EquipmentSlot[] slotTypes) {
        super(weight, operation, config, type, slotTypes);
        this.schools = schools;
    }

    @Override
    public SchoolFilteredEnchantment requireTag(ResourceLocation tagId) {
        this.tagId = tagId;
        return this;
    }

    @Override
    protected boolean m_5975_(Enchantment other) {
        return !(other instanceof SchoolFilteredEnchantment) && super.m_5975_(other);
    }

    public boolean requiresRelatedAttributes() {
        return ((EnchantmentsConfig.PowerEnchantmentConfig)this.config).requires_related_attributes;
    }

    public static boolean schoolsIntersect(Set<SpellSchool> schools, ItemStack stack) {
        Set<SpellSchool> itemStackSchools = SpellPowerEnchanting.relevantSchools(stack);
        for (SpellSchool school : itemStackSchools) {
            if (!schools.contains(school)) continue;
            return true;
        }
        return false;
    }
}

