/*
 * Decompiled with CFR 0.152.
 */
package net.spell_power.api.enchantment;

import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.spell_power.SpellPowerMod;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;
import net.spell_power.config.EnchantmentsConfig;

public class SpellPowerEnchanting {
    private static final ArrayList<ArmorItem> armor = new ArrayList();
    private static final ArrayList<Function<ItemStack, Boolean>> weaponConditions = new ArrayList();

    public static void registerArmor(ArmorItem ... items) {
        for (ArmorItem item : items) {
            SpellPowerEnchanting.registerArmor(item);
        }
    }

    public static void registerArmor(List<ArmorItem> items) {
        for (ArmorItem item : items) {
            SpellPowerEnchanting.registerArmor(item);
        }
    }

    @Deprecated
    public static void registerArmor(ArmorItem item) {
        armor.add(item);
    }

    @Deprecated
    public static boolean isArmorRegistered(Item item) {
        return armor.contains(item);
    }

    @Deprecated
    public static void allowForWeapon(Function<ItemStack, Boolean> condition) {
        weaponConditions.add(condition);
    }

    public static boolean isAllowedForWeapon(ItemStack stack) {
        for (Function<ItemStack, Boolean> condition : weaponConditions) {
            if (!condition.apply(stack).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static Set<SpellSchool> relevantSchools(ItemStack stack) {
        Item item = stack.m_41720_();
        EquipmentSlot slot = EquipmentSlot.MAINHAND;
        if (item instanceof ArmorItem) {
            ArmorItem armor = (ArmorItem)item;
            slot = armor.m_40402_();
        }
        return SpellPowerEnchanting.relevantSchools(stack, slot);
    }

    public static Set<SpellSchool> relevantSchools(ItemStack stack, EquipmentSlot slot) {
        HashSet<SpellSchool> schools = new HashSet<SpellSchool>();
        Multimap attributes = stack.m_41638_(slot);
        for (Map.Entry entry : attributes.entries()) {
            Attribute attribute = (Attribute)entry.getKey();
            for (SpellSchool school : SpellSchools.all()) {
                if (!school.attribute.equals(attribute)) continue;
                schools.add(school);
            }
        }
        return schools;
    }

    public static int getEnchantmentLevel(Enchantment enchantment, LivingEntity entity, ItemStack provisionedWeapon) {
        int level = ((EnchantmentsConfig)((Object)SpellPowerMod.enchantmentConfig.value)).allow_stacking ? SpellPowerEnchanting.getEnchantmentLevelEquipmentSum(enchantment, entity) : EnchantmentHelper.m_44836_((Enchantment)enchantment, (LivingEntity)entity);
        if (provisionedWeapon != null && !provisionedWeapon.m_41619_()) {
            ItemStack mainHandStack = entity.m_21205_();
            if (mainHandStack != null && !mainHandStack.m_41619_()) {
                level -= EnchantmentHelper.m_44843_((Enchantment)enchantment, (ItemStack)mainHandStack);
            }
            level += EnchantmentHelper.m_44843_((Enchantment)enchantment, (ItemStack)provisionedWeapon);
        }
        return level;
    }

    public static int getEnchantmentLevelEquipmentSum(Enchantment enchantment, LivingEntity entity) {
        ItemStack offHandStack;
        int level = 0;
        for (ItemStack itemStack : entity.m_6168_()) {
            level += EnchantmentHelper.m_44843_((Enchantment)enchantment, (ItemStack)itemStack);
        }
        ItemStack mainHandStack = entity.m_21205_();
        if (mainHandStack != null) {
            level += EnchantmentHelper.m_44843_((Enchantment)enchantment, (ItemStack)mainHandStack);
        }
        if ((offHandStack = entity.m_21206_()) != null) {
            level += EnchantmentHelper.m_44843_((Enchantment)enchantment, (ItemStack)offHandStack);
        }
        return level;
    }
}

