/*
 * Decompiled with CFR 0.152.
 */
package net.spell_power.api.enchantment;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.spell_power.SpellPowerMod;
import net.spell_power.api.SpellSchools;
import net.spell_power.api.enchantment.EnchantmentRestriction;
import net.spell_power.config.EnchantmentsConfig;
import net.spell_power.internals.AmplifierEnchantment;
import net.spell_power.internals.SchoolFilteredEnchantment;

public class Enchantments_SpellPower {
    public static final String spellPowerName = "spell_power";
    public static final ResourceLocation spellPowerId = new ResourceLocation("spell_power", "spell_power");
    public static final SchoolFilteredEnchantment SPELL_POWER = new SchoolFilteredEnchantment(Enchantment.Rarity.UNCOMMON, AmplifierEnchantment.Operation.ADD, Enchantments_SpellPower.config().spell_power, Set.of(SpellSchools.ARCANE, SpellSchools.FIRE, SpellSchools.FROST, SpellSchools.HEALING, SpellSchools.LIGHTNING, SpellSchools.SOUL), EnchantmentCategory.BREAKABLE, EquipmentSlot.values()).requireTag(new ResourceLocation("spell_power", "enchant_spell_power_generic"));
    public static final String soulfrostName = "soulfrost";
    public static final ResourceLocation soulfrostId = new ResourceLocation("spell_power", "soulfrost");
    public static final SchoolFilteredEnchantment SOULFROST = new SchoolFilteredEnchantment(Enchantment.Rarity.RARE, AmplifierEnchantment.Operation.ADD, Enchantments_SpellPower.config().soulfrost, Set.of(SpellSchools.SOUL, SpellSchools.FROST), EnchantmentCategory.BREAKABLE, EquipmentSlot.values()).requireTag(new ResourceLocation("spell_power", "enchant_spell_power_soulfrost"));
    public static final String sunfireName = "sunfire";
    public static final ResourceLocation sunfireId = new ResourceLocation("spell_power", "sunfire");
    public static final SchoolFilteredEnchantment SUNFIRE = new SchoolFilteredEnchantment(Enchantment.Rarity.RARE, AmplifierEnchantment.Operation.ADD, Enchantments_SpellPower.config().sunfire, Set.of(SpellSchools.ARCANE, SpellSchools.FIRE), EnchantmentCategory.BREAKABLE, EquipmentSlot.values()).requireTag(new ResourceLocation("spell_power", "enchant_spell_power_sunfire"));
    public static final String energizeName = "energize";
    public static final ResourceLocation energizeId = new ResourceLocation("spell_power", "energize");
    public static final SchoolFilteredEnchantment ENERGIZE = new SchoolFilteredEnchantment(Enchantment.Rarity.RARE, AmplifierEnchantment.Operation.ADD, Enchantments_SpellPower.config().energize, Set.of(SpellSchools.HEALING, SpellSchools.LIGHTNING), EnchantmentCategory.BREAKABLE, EquipmentSlot.values()).requireTag(new ResourceLocation("spell_power", "enchant_spell_power_energize"));
    public static final Map<ResourceLocation, SchoolFilteredEnchantment> all = new HashMap<ResourceLocation, SchoolFilteredEnchantment>();

    private static EnchantmentsConfig config() {
        return (EnchantmentsConfig)((Object)SpellPowerMod.enchantmentConfig.value);
    }

    static {
        all.put(spellPowerId, SPELL_POWER);
        all.put(soulfrostId, SOULFROST);
        all.put(sunfireId, SUNFIRE);
        all.put(energizeId, ENERGIZE);
        for (Map.Entry<ResourceLocation, SchoolFilteredEnchantment> entry : all.entrySet()) {
            SchoolFilteredEnchantment enchantment = entry.getValue();
            EnchantmentRestriction.prohibit(enchantment, itemStack -> {
                boolean typeMatches = enchantment.matchesRequiredTag(itemStack);
                boolean schoolMatches = !enchantment.requiresRelatedAttributes() || SchoolFilteredEnchantment.schoolsIntersect(enchantment.poweredSchools(), itemStack);
                return !typeMatches || !schoolMatches;
            });
        }
    }
}

