/*
 * Decompiled with CFR 0.152.
 */
package net.spell_power.api.enchantment;

import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;

public final class EnchantmentRestriction {
    private static HashMap<Enchantment, ArrayList<Condition>> permissions = new HashMap();
    private static HashMap<Enchantment, ArrayList<Condition>> prohibitions = new HashMap();

    public static void permit(Enchantment enchantment, Condition condition) {
        ArrayList<Condition> conditions = permissions.get(enchantment);
        if (conditions == null) {
            conditions = new ArrayList();
        }
        conditions.add(condition);
        permissions.put(enchantment, conditions);
    }

    public static boolean isPermitted(Enchantment enchantment, ItemStack itemStack) {
        ArrayList<Condition> conditions = permissions.get(enchantment);
        if (conditions != null) {
            for (Condition permittingCondition : conditions) {
                if (!permittingCondition.appliesForItemStack(itemStack)) continue;
                return true;
            }
        }
        return false;
    }

    public static void prohibit(Enchantment enchantment, Condition condition) {
        ArrayList<Condition> conditions = prohibitions.get(enchantment);
        if (conditions == null) {
            conditions = new ArrayList();
        }
        conditions.add(condition);
        prohibitions.put(enchantment, conditions);
    }

    public static boolean isProhibited(Enchantment enchantment, ItemStack itemStack) {
        ArrayList<Condition> conditions = prohibitions.get(enchantment);
        if (conditions != null) {
            for (Condition prohibitingCondition : conditions) {
                if (!prohibitingCondition.appliesForItemStack(itemStack)) continue;
                return true;
            }
        }
        return false;
    }

    public static interface Condition {
        public boolean appliesForItemStack(ItemStack var1);
    }
}

