/*
 * Decompiled with CFR 0.152.
 */
package net.spell_power.api;

import java.util.HashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.spell_power.internals.CustomEntityAttribute;
import net.spell_power.internals.SpellStatusEffect;

public class SpellPowerMechanics {
    public static final float PERCENT_ATTRIBUTE_BASELINE = 100.0f;
    public static final HashMap<String, Entry> all = new HashMap();
    public static final Entry CRITICAL_CHANCE = SpellPowerMechanics.entry("critical_chance", 100.0f, 100.0f, 1000.0f);
    public static final Entry CRITICAL_DAMAGE = SpellPowerMechanics.entry("critical_damage", 100.0f, 100.0f, 1000.0f);
    public static final Entry HASTE = SpellPowerMechanics.entry("haste", 100.0f, 100.0f, 1000.0f);

    public static String translationPrefix() {
        return "attribute.name.spell_power.";
    }

    public static Entry entry(String name, float defaultValue, float min, float max) {
        Entry entry = new Entry(name, defaultValue, min, max);
        all.put(name, entry);
        return entry;
    }

    public static class Entry {
        public final String name;
        public final ResourceLocation id;
        public final float defaultValue;
        public final float min;
        public final float max;
        public final CustomEntityAttribute attribute;
        public final MobEffect boostEffect;

        public Entry(String name, float defaultValue, float min, float max) {
            this.name = name;
            this.id = new ResourceLocation("spell_power", name);
            this.defaultValue = defaultValue;
            this.min = min;
            this.max = max;
            this.attribute = new CustomEntityAttribute(SpellPowerMechanics.translationPrefix() + name, defaultValue, min, max, this.id);
            this.attribute.m_22084_(true);
            this.boostEffect = new SpellStatusEffect(MobEffectCategory.BENEFICIAL, 0x66CCFF);
        }
    }
}

