/*
 * Decompiled with CFR 0.152.
 */
package net.spell_power;

import java.util.List;
import java.util.Map;
import net.fabricmc.api.ModInitializer;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.enchantment.Enchantment;
import net.spell_power.api.SpellPowerMechanics;
import net.spell_power.api.SpellSchool;
import net.spell_power.api.SpellSchools;
import net.spell_power.api.enchantment.Enchantments_SpellPower;
import net.spell_power.api.enchantment.Enchantments_SpellPowerMechanics;
import net.spell_power.api.enchantment.SpellPowerEnchanting;
import net.spell_power.config.AttributesConfig;
import net.spell_power.config.EnchantmentsConfig;
import net.spell_power.internals.SchoolFilteredEnchantment;
import net.spell_power.internals.SpellStatusEffect;
import net.tinyconfig.ConfigManager;

public class SpellPowerMod
implements ModInitializer {
    public static final String ID = "spell_power";
    public static final ConfigManager<AttributesConfig> attributesConfig = new ConfigManager("attributes", (Object)AttributesConfig.defaults()).builder().setDirectory("spell_power").sanitize(true).validate(AttributesConfig::isValid).build();
    public static final ConfigManager<EnchantmentsConfig> enchantmentConfig = new ConfigManager("enchantments", (Object)new EnchantmentsConfig()).builder().setDirectory("spell_power").sanitize(true).schemaVersion(4).build();
    private static int effectRawId = 730;
    public static AttributesConfig.AttributeScope attributeScopeOverride = null;

    public void onInitialize() {
        attributesConfig.refresh();
        enchantmentConfig.refresh();
        effectRawId = ((AttributesConfig)SpellPowerMod.attributesConfig.value).status_effect_raw_id_starts_at;
        for (Map.Entry<String, SpellPowerMechanics.Entry> entry : SpellPowerMechanics.all.entrySet()) {
            SpellPowerMechanics.Entry secondary = entry.getValue();
            ResourceLocation id = secondary.id;
            String uuid = "0e0ddd12-0646-42b7-8daf-36b4ccf524df";
            float bonus_per_stack = 0.1f;
            SpellStatusEffect.Config config = ((AttributesConfig)SpellPowerMod.attributesConfig.value).secondary_effects.get(secondary.name);
            if (config != null) {
                uuid = config.uuid;
                bonus_per_stack = config.bonus_per_stack;
            }
            secondary.boostEffect.m_19472_((Attribute)secondary.attribute, uuid, (double)bonus_per_stack, AttributeModifier.Operation.MULTIPLY_TOTAL);
            Registry.m_122956_((Registry)BuiltInRegistries.f_256974_, (int)effectRawId++, (String)id.toString(), (Object)secondary.boostEffect);
        }
        for (Map.Entry<String, SpellPowerMechanics.Entry> entry : Enchantments_SpellPowerMechanics.all.entrySet()) {
            Registry.m_122965_((Registry)BuiltInRegistries.f_256876_, (ResourceLocation)((ResourceLocation)entry.getKey()), (Object)((Enchantment)entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : Enchantments_SpellPower.all.entrySet()) {
            Registry.m_122965_((Registry)BuiltInRegistries.f_256876_, (ResourceLocation)((ResourceLocation)entry.getKey()), (Object)((Object)((SchoolFilteredEnchantment)((Object)entry.getValue()))));
        }
        ((EnchantmentsConfig)((Object)SpellPowerMod.enchantmentConfig.value)).apply();
        this.attachEnchantmentsToSchools();
    }

    private void attachEnchantmentsToSchools() {
        for (SpellSchool school : SpellSchools.all()) {
            List<SchoolFilteredEnchantment> poweringEnchantments = Enchantments_SpellPower.all.entrySet().stream().filter(entry -> ((SchoolFilteredEnchantment)((Object)((Object)entry.getValue()))).poweredSchools().contains(school)).map(Map.Entry::getValue).toList();
            school.addSource(SpellSchool.Trait.POWER, new SpellSchool.Source(SpellSchool.Apply.MULTIPLY, query -> {
                double value = 0.0;
                for (SchoolFilteredEnchantment enchantment : poweringEnchantments) {
                    int level = SpellPowerEnchanting.getEnchantmentLevel(enchantment, query.entity(), null);
                    value = enchantment.amplified(value, level);
                }
                return value;
            }));
        }
    }

    public static void registerAttributes() {
        for (Map.Entry<String, SpellPowerMechanics.Entry> entry : SpellPowerMechanics.all.entrySet()) {
            SpellPowerMechanics.Entry secondary = entry.getValue();
            Registry.m_122965_((Registry)BuiltInRegistries.f_256951_, (ResourceLocation)secondary.id, (Object)((Object)secondary.attribute));
        }
        for (SpellSchool school : SpellSchools.all()) {
            ResourceLocation id = school.id;
            if (!school.attributeManagement.isInternal() || school.attribute == null) continue;
            Registry.m_122965_((Registry)BuiltInRegistries.f_256951_, (ResourceLocation)id, (Object)school.attribute);
        }
    }

    public static void registerStatusEffects() {
        for (SpellSchool school : SpellSchools.all()) {
            ResourceLocation id = school.id;
            if (!school.powerEffectManagement.isInternal() || school.boostEffect == null || BuiltInRegistries.f_256974_.m_7745_(id) != null) continue;
            SpellStatusEffect.Config config = ((AttributesConfig)SpellPowerMod.attributesConfig.value).spell_power_effect;
            school.boostEffect.m_19472_(school.attribute, config.uuid, (double)config.bonus_per_stack, AttributeModifier.Operation.MULTIPLY_TOTAL);
            Registry.m_122956_((Registry)BuiltInRegistries.f_256974_, (int)effectRawId++, (String)id.toString(), (Object)school.boostEffect);
        }
    }

    public static AttributesConfig.AttributeScope attributeScope() {
        return attributeScopeOverride != null ? attributeScopeOverride : ((AttributesConfig)SpellPowerMod.attributesConfig.value).attributes_container_injection_scope;
    }
}

