/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.data.unlock;

import com.google.common.collect.ImmutableMap;
import com.mrcrayfish.backpacked.Config;
import com.mrcrayfish.backpacked.common.backpack.BackpackManager;
import com.mrcrayfish.backpacked.common.tracker.IProgressTracker;
import com.mrcrayfish.backpacked.util.Serializable;
import com.mrcrayfish.framework.api.sync.IDataSerializer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;

public class UnlockTracker
implements Serializable {
    public static final Serializer SERIALIZER = new Serializer();
    private final Set<ResourceLocation> unlockedBackpacks = new HashSet<ResourceLocation>();
    private final Map<ResourceLocation, IProgressTracker> backpackToProgressTracker;
    private final Map<Class<?>, List<IProgressTracker>> classToProgressTrackers;

    public UnlockTracker() {
        HashMap backpackMap = new HashMap();
        HashMap classMap = new HashMap();
        BackpackManager.instance().getBackpacks().forEach(backpack -> {
            IProgressTracker tracker = backpack.createProgressTracker(backpack.getId());
            if (tracker != null) {
                classMap.computeIfAbsent(tracker.getClass(), c -> new ArrayList()).add(tracker);
                backpackMap.put(backpack.getId(), tracker);
            }
        });
        this.backpackToProgressTracker = ImmutableMap.copyOf(backpackMap);
        this.classToProgressTrackers = ImmutableMap.copyOf(classMap);
    }

    public Set<ResourceLocation> getUnlockedBackpacks() {
        return Collections.unmodifiableSet(this.unlockedBackpacks);
    }

    public Map<ResourceLocation, IProgressTracker> getProgressTrackerMap() {
        return this.backpackToProgressTracker;
    }

    void setUnlockedBackpacks(Set<ResourceLocation> unlockedBackpacks) {
        this.unlockedBackpacks.clear();
        this.unlockedBackpacks.addAll(unlockedBackpacks);
    }

    public boolean isUnlocked(ResourceLocation id) {
        return this.unlockedBackpacks.contains(id);
    }

    public Optional<IProgressTracker> getProgressTracker(ResourceLocation backpackId) {
        if (!((Boolean)Config.SERVER.backpack.unlockAllCosmetics.get()).booleanValue() && !this.unlockedBackpacks.contains(backpackId)) {
            return Optional.ofNullable(this.backpackToProgressTracker.get(backpackId));
        }
        return Optional.empty();
    }

    public <T> List<T> getProgressTrackers(Class<T> trackerClass) {
        if (this.classToProgressTrackers.containsKey(trackerClass)) {
            return this.classToProgressTrackers.get(trackerClass);
        }
        return Collections.emptyList();
    }

    public boolean unlockBackpack(ResourceLocation id) {
        if (BackpackManager.instance().getBackpack(id) != null) {
            return this.unlockedBackpacks.add(id);
        }
        return false;
    }

    @Override
    public CompoundTag serialize() {
        CompoundTag tag = new CompoundTag();
        ListTag unlockedBackpacks = new ListTag();
        this.unlockedBackpacks.forEach(location -> unlockedBackpacks.add((Object)StringTag.m_129297_((String)location.toString())));
        tag.m_128365_("UnlockedBackpacks", (Tag)unlockedBackpacks);
        ListTag progressTrackers = new ListTag();
        this.backpackToProgressTracker.forEach((location, progressTracker) -> {
            CompoundTag progressTag = new CompoundTag();
            progressTag.m_128359_("Id", location.toString());
            CompoundTag dataTag = new CompoundTag();
            progressTracker.write(dataTag);
            progressTag.m_128365_("Data", (Tag)dataTag);
            progressTrackers.add((Object)progressTag);
        });
        tag.m_128365_("ProgressTrackers", (Tag)progressTrackers);
        return tag;
    }

    @Override
    public void deserialize(CompoundTag tag) {
        this.unlockedBackpacks.clear();
        ListTag unlockedBackpacks = tag.m_128437_("UnlockedBackpacks", 8);
        unlockedBackpacks.forEach(t -> this.unlockedBackpacks.add(ResourceLocation.m_135820_((String)t.m_7916_())));
        ListTag progressTrackers = tag.m_128437_("ProgressTrackers", 10);
        progressTrackers.forEach(t -> {
            CompoundTag progressTag = (CompoundTag)t;
            ResourceLocation id = new ResourceLocation(progressTag.m_128461_("Id"));
            IProgressTracker tracker = this.backpackToProgressTracker.get(id);
            if (tracker != null) {
                CompoundTag dataTag = progressTag.m_128469_("Data");
                tracker.read(dataTag);
            }
        });
    }

    public static class Serializer
    implements IDataSerializer<UnlockTracker> {
        public void write(FriendlyByteBuf buf, UnlockTracker value) {
            buf.m_130079_(value.serialize());
        }

        public UnlockTracker read(FriendlyByteBuf buf) {
            UnlockTracker tracker = new UnlockTracker();
            Optional.ofNullable(buf.m_130260_()).ifPresent(tracker::deserialize);
            return tracker;
        }

        public Tag write(UnlockTracker value) {
            return value.serialize();
        }

        public UnlockTracker read(Tag nbt) {
            UnlockTracker tracker = new UnlockTracker();
            if (nbt instanceof CompoundTag) {
                CompoundTag tag = (CompoundTag)nbt;
                tracker.deserialize(tag);
            }
            return tracker;
        }
    }
}

