/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.tracker.impl;

import com.mrcrayfish.backpacked.common.tracker.IProgressTracker;
import com.mrcrayfish.backpacked.common.tracker.ProgressFormatter;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;

public class CountProgressTracker
implements IProgressTracker {
    private final ProgressFormatter formatter;
    private final int maxCount;
    private int count;

    public CountProgressTracker(int maxCount, ProgressFormatter formatter) {
        this.maxCount = maxCount;
        this.formatter = formatter;
    }

    public void increment(ServerPlayer player) {
        ++this.count;
        this.markForCompletionTest(player);
    }

    public void increment(int amount, ServerPlayer player) {
        this.count += amount;
        this.markForCompletionTest(player);
    }

    @Override
    public boolean isComplete() {
        return this.count >= this.maxCount;
    }

    @Override
    public void read(CompoundTag tag) {
        this.count = tag.m_128451_("Count");
    }

    @Override
    public void write(CompoundTag tag) {
        tag.m_128405_("Count", this.count);
    }

    @Override
    public Component getDisplayComponent() {
        return this.formatter.formatter().apply(this.count, this.maxCount);
    }
}

