/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.common.challenge.impl;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.mrcrayfish.backpacked.common.challenge.Challenge;
import com.mrcrayfish.backpacked.common.challenge.ChallengeSerializer;
import com.mrcrayfish.backpacked.common.tracker.IProgressTracker;
import com.mrcrayfish.backpacked.common.tracker.ProgressFormatter;
import com.mrcrayfish.backpacked.data.unlock.UnlockManager;
import com.mrcrayfish.backpacked.event.BackpackedEvents;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.Util;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.biome.Biome;

public class ExploreBiomeChallenge
extends Challenge {
    public static final ResourceLocation ID = new ResourceLocation("backpacked", "explore_biome");
    public static final Serializer SERIALIZER = new Serializer();
    public static final Codec<List<ResourceKey<Biome>>> BIOME_LIST_CODEC = ExtraCodecs.m_264370_((Codec)Codec.either((Codec)ResourceKey.m_195966_((ResourceKey)Registries.f_256952_), (Codec)ResourceKey.m_195966_((ResourceKey)Registries.f_256952_).listOf()).xmap(either -> (List)either.map(List::of, Function.identity()), keys -> keys.size() == 1 ? Either.left((Object)((ResourceKey)keys.get(0))) : Either.right((Object)keys)), keys -> {
        if (keys.isEmpty()) {
            return DataResult.error(() -> "Must specify at least one biome");
        }
        return DataResult.success((Object)keys);
    });
    public static final Codec<ExploreBiomeChallenge> CODEC = RecordCodecBuilder.create(builder -> builder.group((App)ProgressFormatter.CODEC.fieldOf("formatter").orElse((Object)ProgressFormatter.EXPLORED_X_OF_X).forGetter(challenge -> challenge.formatter), (App)BIOME_LIST_CODEC.fieldOf("biome").forGetter(challenge -> challenge.biomes)).apply((Applicative)builder, ExploreBiomeChallenge::new));
    private final ProgressFormatter formatter;
    private final List<ResourceKey<Biome>> biomes;

    public ExploreBiomeChallenge(ProgressFormatter formatter, List<ResourceKey<Biome>> biomes) {
        super(ID);
        this.formatter = formatter;
        this.biomes = biomes;
    }

    @Override
    public ChallengeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    @Override
    public IProgressTracker createProgressTracker(ResourceLocation backpackId) {
        return new Tracker(this.formatter, this.biomes);
    }

    public static class Serializer
    extends ChallengeSerializer<ExploreBiomeChallenge> {
        @Override
        public ExploreBiomeChallenge deserialize(JsonObject object) {
            return (ExploreBiomeChallenge)Util.m_260975_((DataResult)CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)object), JsonParseException::new);
        }
    }

    public static class Tracker
    implements IProgressTracker {
        private final ProgressFormatter formatter;
        private final ImmutableSet<ResourceKey<Biome>> biomes;
        private final Set<ResourceLocation> exploredBiomes = new HashSet<ResourceLocation>();

        private Tracker(ProgressFormatter formatter, List<ResourceKey<Biome>> biomes) {
            this.formatter = formatter;
            this.biomes = ImmutableSet.copyOf(biomes);
        }

        private void explore(ResourceKey<Biome> biome, ServerPlayer player) {
            if (this.biomes.contains(biome)) {
                this.exploredBiomes.add(biome.m_135782_());
                this.markForCompletionTest(player);
            }
        }

        @Override
        public boolean isComplete() {
            return this.exploredBiomes.size() >= this.biomes.size();
        }

        @Override
        public void read(CompoundTag tag) {
            this.exploredBiomes.clear();
            ListTag list = tag.m_128437_("ExploredBiomes", 8);
            list.forEach(nbt -> {
                ResourceLocation id = ResourceLocation.m_135820_((String)nbt.m_7916_());
                if (id != null && this.biomes.stream().anyMatch(key -> key.m_135782_().equals((Object)id))) {
                    this.exploredBiomes.add(id);
                }
            });
        }

        @Override
        public void write(CompoundTag tag) {
            ListTag list = new ListTag();
            this.exploredBiomes.forEach(location -> list.add((Object)StringTag.m_129297_((String)location.toString())));
            tag.m_128365_("ExploredBiomes", (Tag)list);
        }

        @Override
        public Component getDisplayComponent() {
            return this.formatter.formatter().apply(this.exploredBiomes.size(), this.biomes.size());
        }

        public static void registerEvent() {
            BackpackedEvents.EXPLORE_UPDATE.register((key, player) -> {
                if (player.m_9236_().m_5776_()) {
                    return;
                }
                UnlockManager.getTrackers(player, Tracker.class).forEach(tracker -> {
                    if (!tracker.isComplete()) {
                        tracker.explore((ResourceKey<Biome>)key, (ServerPlayer)player);
                    }
                });
            });
        }
    }
}

