/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.backpacked.client.renderer.entity.layers;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.mrcrayfish.backpacked.client.renderer.backpack.BackpackRenderContext;
import com.mrcrayfish.backpacked.common.backpack.Backpack;
import com.mrcrayfish.backpacked.common.backpack.BackpackManager;
import com.mrcrayfish.backpacked.common.backpack.ModelMeta;
import com.mrcrayfish.backpacked.common.backpack.ModelProperty;
import com.mrcrayfish.backpacked.item.BackpackItem;
import com.mrcrayfish.backpacked.platform.ClientServices;
import com.mrcrayfish.backpacked.platform.Services;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class BackpackLayer<T extends Player, M extends PlayerModel<T>>
extends RenderLayer<T, M> {
    private final ItemRenderer itemRenderer;

    public BackpackLayer(RenderLayerParent<T, M> renderer, ItemRenderer itemRenderer) {
        super(renderer);
        this.itemRenderer = itemRenderer;
    }

    public void render(PoseStack pose, MultiBufferSource source, int light, T player, float p_225628_5_, float p_225628_6_, float partialTick, float p_225628_8_, float p_225628_9_, float p_225628_10_) {
        ItemStack stack = Services.BACKPACK.getBackpackStack((Player)player);
        if (stack.m_41720_() instanceof BackpackItem) {
            ItemStack chestStack = player.m_6844_(EquipmentSlot.CHEST);
            if (chestStack.m_41720_() == Items.f_42741_ && !BackpackLayer.canRenderWithElytra(stack)) {
                return;
            }
            if (!Services.BACKPACK.isBackpackVisible((Player)player)) {
                return;
            }
            String modelName = stack.m_41784_().m_128461_("BackpackModel");
            Backpack backpack = BackpackManager.instance().getClientBackpack(modelName);
            if (backpack == null) {
                return;
            }
            pose.m_85836_();
            pose.m_252781_(Axis.f_252436_.m_252977_(180.0f));
            pose.m_85841_(1.05f, -1.05f, -1.05f);
            int offset = !chestStack.m_41619_() ? 3 : 2;
            pose.m_85837_(0.0, -0.06, (double)offset * 0.0625);
            ModelMeta meta = BackpackManager.instance().getModelMeta(backpack);
            meta.renderer().ifPresentOrElse(renderer -> {
                pose.m_85836_();
                BackpackRenderContext context = new BackpackRenderContext(pose, source, light, stack, backpack, (LivingEntity)player, partialTick, player.f_19797_, model -> this.itemRenderer.m_115143_(stack, ItemDisplayContext.NONE, false, pose, source, light, OverlayTexture.f_118083_, model));
                renderer.forEach(function -> function.apply(context));
                pose.m_85849_();
            }, () -> {
                BakedModel model = ClientServices.MODEL.getBakedModel(backpack.getBaseModel());
                this.itemRenderer.m_115143_(stack, ItemDisplayContext.NONE, false, pose, source, light, OverlayTexture.f_118083_, model);
            });
            this.itemRenderer.m_115143_(stack, ItemDisplayContext.NONE, false, pose, source, light, OverlayTexture.f_118083_, this.getModel(backpack.getStrapsModel()));
            pose.m_85849_();
        }
    }

    private BakedModel getModel(ResourceLocation location) {
        BakedModel model = ClientServices.MODEL.getBakedModel(location);
        return model != null ? model : this.itemRenderer.m_115103_().m_109393_().m_119409_();
    }

    public static boolean canRenderWithElytra(ItemStack stack) {
        return stack.m_41784_().m_128471_(ModelProperty.SHOW_WITH_ELYTRA.getTagName());
    }

    public static boolean canShowEnchantmentGlint(ItemStack stack) {
        return stack.m_41784_().m_128471_(ModelProperty.SHOW_GLINT.getTagName());
    }
}

