/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.mixins.client;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.puffish.skillsmod.client.data.ClientCategoryData;
import net.puffish.skillsmod.client.gui.SkillsScreen;
import net.puffish.skillsmod.util.Bounds2i;
import net.sweenus.simplyskills.client.gui.TextureState;
import net.sweenus.simplyskills.mixins.client.SkillsScreenAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={SkillsScreen.class})
public abstract class SkillsScreenMixin {
    @Unique
    Map<class_2960, TextureState> textureStates = new HashMap<class_2960, TextureState>();
    @Unique
    private final class_2960 cloudsTexture1 = new class_2960("simplyskills", "textures/backgrounds/decor/clouds.png");
    @Unique
    private final class_2960 cloudsTexture2 = new class_2960("simplyskills", "textures/backgrounds/decor/clouds_2.png");
    @Unique
    private final class_2960 cloudsTexture3 = new class_2960("simplyskills", "textures/backgrounds/decor/clouds_3.png");
    @Unique
    private float cloudsX = 0.0f;
    @Unique
    private class_2960 selectedCloudsTexture = null;

    @Unique
    private void selectRandomCloudsTexture() {
        Random random = new Random();
        int textureIndex = random.nextInt(3);
        switch (textureIndex) {
            case 0: {
                this.selectedCloudsTexture = this.cloudsTexture1;
                break;
            }
            case 1: {
                this.selectedCloudsTexture = this.cloudsTexture2;
                break;
            }
            case 2: {
                this.selectedCloudsTexture = this.cloudsTexture3;
            }
        }
    }

    @Inject(method={"drawContentWithCategory(Lnet/minecraft/client/gui/DrawContext;DDLnet/puffish/skillsmod/client/data/ClientCategoryData;)V"}, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lnet/puffish/skillsmod/client/gui/SkillsScreen;drawBackground(Lnet/minecraft/client/gui/DrawContext;Lnet/puffish/skillsmod/client/config/ClientBackgroundConfig;)V")})
    private void injectDrawBackground(class_332 context, double mouseX, double mouseY, ClientCategoryData activeCategoryData, CallbackInfo ci) {
        SkillsScreenAccessor accessor = (SkillsScreenAccessor)((Object)this);
        Bounds2i bounds = accessor.getBounds();
        if (!FabricLoader.getInstance().isModLoaded("prominent")) {
            this.drawParallaxTextures(context, bounds);
        }
    }

    @Unique
    private void drawParallaxTextures(class_332 context, Bounds2i bounds) {
        long currentTime = System.currentTimeMillis();
        for (int i = 1; i <= 30; ++i) {
            class_2960 parallaxTexture = new class_2960("simplyskills", String.format("textures/backgrounds/decor/planet_%02d.png", i));
            this.updateAndDrawAnimatedTexture(context, parallaxTexture, bounds, currentTime);
        }
        this.updateAndDrawCloudsTexture(context, bounds);
    }

    @Unique
    private void updateAndDrawAnimatedTexture(class_332 context, class_2960 texture, Bounds2i bounds, long currentTime) {
        int frameCount = 120;
        int spriteSheetWidth = 7680;
        int frameWidth = spriteSheetWidth / frameCount;
        int frameHeight = 64;
        this.textureStates.computeIfAbsent(texture, k -> {
            float initialX = (float)bounds.min().x + (float)Math.random() * (float)(bounds.width() - frameWidth);
            float initialY = (float)bounds.min().y + (float)Math.random() * (float)(bounds.height() - frameHeight);
            float scale = Math.max(0.4f, (float)(Math.random() * 5.0));
            float speed = Math.min(0.04f, (float)(Math.random() * (double)0.08f / (double)scale));
            long animationSpeed = Math.max(240L, (long)(Math.random() * 300.0 + (double)(10.0f * scale)));
            float brightness = Math.min(0.5f, 0.1f + (float)Math.random());
            TextureState newState = new TextureState(initialX, bounds.min().y, speed, scale, animationSpeed, brightness);
            float[] newPosition = this.updatePlanetPosition(initialX, initialY, bounds, speed, scale);
            newState.x = newPosition[0];
            newState.y = newPosition[1];
            return newState;
        });
        TextureState state = this.textureStates.get(texture);
        int currentFrame = (int)(currentTime / state.animationSpeed % (long)frameCount);
        int u = currentFrame * frameWidth;
        float[] newPosition = this.updatePlanetPosition(state.x, state.y, bounds, state.speed, state.scale);
        state.x = newPosition[0];
        state.y = newPosition[1];
        class_4587 matrixStack = context.method_51448();
        matrixStack.method_22903();
        matrixStack.method_22905(state.scale, state.scale, 1.0f);
        int boundsWidth = bounds.width();
        int scaledWidth = (int)((float)frameWidth * state.scale);
        float effectiveXCenter = state.x + (float)scaledWidth / 2.0f;
        float distanceToLeftEdge = effectiveXCenter - (float)bounds.min().x;
        float distanceToRightEdge = (float)bounds.max().x - effectiveXCenter;
        float effectiveEdgeDistance = Math.min(distanceToLeftEdge, distanceToRightEdge);
        float edgeFactor = effectiveEdgeDistance / ((float)boundsWidth / 2.0f);
        float dynamicBrightness = state.brightness * edgeFactor;
        dynamicBrightness = Math.max(dynamicBrightness, 0.0f);
        RenderSystem.setShaderColor((float)dynamicBrightness, (float)dynamicBrightness, (float)dynamicBrightness, (float)1.0f);
        context.method_25290(texture, (int)state.x, (int)state.y, (float)u, 0.0f, frameWidth, frameHeight, spriteSheetWidth, frameHeight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.method_22909();
    }

    @Unique
    private float[] updatePlanetPosition(float x, float y, Bounds2i bounds, float moveSpeed, float scale) {
        boolean outOfBoundsVertically;
        int frameCount = 120;
        int spriteSheetWidth = 7680;
        int frameWidth = spriteSheetWidth / frameCount;
        int frameHeight = 64;
        int scaledWidth = (int)((float)frameWidth * scale);
        int scaledHeight = (int)((float)frameHeight * scale);
        float newX = x - moveSpeed;
        float newY = y + moveSpeed;
        int outOfBoundsMargin = 800;
        boolean outOfBoundsHorizontally = newX + (float)scaledWidth + (float)outOfBoundsMargin < (float)bounds.min().x || newX - (float)outOfBoundsMargin > (float)bounds.max().x;
        boolean bl = outOfBoundsVertically = newY - (float)outOfBoundsMargin > (float)bounds.max().y;
        if (outOfBoundsHorizontally || outOfBoundsVertically) {
            newX = (float)bounds.min().x + (float)Math.random() * (float)(bounds.width() - scaledWidth);
            newY = (float)(bounds.min().y - scaledHeight) - (float)Math.random() * (float)(scaledHeight + outOfBoundsMargin);
        }
        return new float[]{newX, newY};
    }

    @Unique
    private void updateAndDrawCloudsTexture(class_332 context, Bounds2i bounds) {
        float cloudsSpeed;
        float newX;
        if (this.cloudsX == 0.0f) {
            this.cloudsX = -bounds.width();
        }
        if (this.selectedCloudsTexture == null) {
            this.selectRandomCloudsTexture();
        }
        if ((newX = this.cloudsX + (cloudsSpeed = 0.05f)) <= (float)(-bounds.width())) {
            newX = -bounds.width();
        } else if (newX > 0.0f) {
            newX = 0.0f;
        }
        this.cloudsX = newX;
        class_4587 matrixStack = context.method_51448();
        matrixStack.method_22903();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)0.5f);
        int cloudsHeight = 1440;
        context.method_25290(this.selectedCloudsTexture, (int)this.cloudsX, bounds.min().y, 0.0f, 0.0f, bounds.width() + 10240, cloudsHeight, bounds.width() + 10240, cloudsHeight);
        RenderSystem.disableBlend();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        matrixStack.method_22909();
    }
}

