/*
 * Decompiled with CFR 0.152.
 */
package net.sweenus.simplyskills.abilities;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1675;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.spell_engine.api.spell.Spell;
import net.spell_engine.entity.SpellProjectile;
import net.spell_engine.internals.SpellHelper;
import net.sweenus.simplyskills.SimplySkills;
import net.sweenus.simplyskills.abilities.AbilityLogic;
import net.sweenus.simplyskills.abilities.AscendancyAbilities;
import net.sweenus.simplyskills.abilities.SignatureAbilities;
import net.sweenus.simplyskills.effects.StaticChargeEffect;
import net.sweenus.simplyskills.registry.EffectRegistry;
import net.sweenus.simplyskills.util.HelperMethods;
import net.sweenus.simplyskills.util.SkillReferencePosition;

public class WizardAbilities {
    public static void passiveWizardSpellEcho(class_1657 player, List<class_1297> targets) {
        class_1297 target = null;
        if (!targets.isEmpty()) {
            target = targets.get(player.method_6051().method_43048(targets.size()));
        }
        int chance = SimplySkills.wizardConfig.passiveWizardSpellEchoChance;
        if (AscendancyAbilities.magicCircleEffect(player)) {
            chance += 10;
        }
        if (player.method_6051().method_43048(100) < chance) {
            ArrayList<String> list = new ArrayList<String>();
            list.add("simplyskills:frost_arrow");
            list.add("simplyskills:fire_arrow");
            list.add("simplyskills:lightning_arrow");
            list.add("simplyskills:arcane_bolt_lesser");
            list.add("simplyskills:ice_comet");
            list.add("simplyskills:fire_meteor");
            list.add("simplyskills:static_discharge");
            int spellChoice = player.method_6051().method_43048(list.size());
            if (target != null) {
                SignatureAbilities.castSpellEngineIndirectTarget(player, (String)list.get(spellChoice), 120, target, null);
            }
        }
    }

    public static boolean signatureWizardMeteorShower(String wizardSkillTree, class_1657 player) {
        class_243 blockpos = null;
        boolean success = false;
        int meteoricWrathDuration = SimplySkills.wizardConfig.signatureWizardMeteoricWrathDuration;
        int meteoricWrathStacks = SimplySkills.wizardConfig.signatureWizardMeteoricWrathStacks - 1;
        int meteorShowerRange = SimplySkills.wizardConfig.signatureWizardMeteorShowerRange;
        if (HelperMethods.getTargetedEntity((class_1297)player, meteorShowerRange) != null) {
            blockpos = HelperMethods.getTargetedEntity((class_1297)player, meteorShowerRange).method_19538();
        }
        if (blockpos == null) {
            blockpos = HelperMethods.getPositionLookingAt(player, meteorShowerRange);
        }
        if (blockpos != null) {
            int xpos = (int)blockpos.method_10216();
            int ypos = (int)blockpos.method_10214();
            int zpos = (int)blockpos.method_10215();
            class_2338 searchArea = new class_2338(xpos, ypos, zpos);
            class_238 box = HelperMethods.createBoxAtBlock(searchArea, 8);
            for (class_1297 entities : player.method_37908().method_8333((class_1297)player, box, class_1301.field_6157)) {
                class_1309 le;
                if (entities == null || !(entities instanceof class_1309) || !HelperMethods.checkFriendlyFire(le = (class_1309)entities, player)) continue;
                success = true;
                if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationMeteorShowerWrath, (class_1309)player)) {
                    player.method_6092(new class_1293(EffectRegistry.METEORICWRATH, meteoricWrathDuration, meteoricWrathStacks, false, false, true));
                }
                if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationMeteorShowerGreater, (class_1309)player)) {
                    SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:fire_meteor_large", 8, (class_1297)le, searchArea);
                    break;
                }
                SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:fire_meteor", 8, (class_1297)le, searchArea);
                break;
            }
        }
        return success;
    }

    public static boolean signatureWizardIceComet(String wizardSkillTree, class_1657 player) {
        class_243 blockpos = null;
        boolean success = false;
        class_1309 target = null;
        int leapVelocity = SimplySkills.wizardConfig.signatureWizardIceCometLeapVelocity;
        double leapHeight = SimplySkills.wizardConfig.signatureWizardIceCometLeapHeight;
        int leapSlowfallDuration = SimplySkills.wizardConfig.signatureWizardIceCometLeapSlowfallDuration;
        int volleyDuration = SimplySkills.wizardConfig.signatureWizardIceCometVolleyDuration;
        int volleyStacks = SimplySkills.wizardConfig.signatureWizardIceCometVolleyStacks;
        int iceCometRange = SimplySkills.wizardConfig.signatureWizardIceCometRange;
        if (HelperMethods.getTargetedEntity((class_1297)player, iceCometRange) != null) {
            blockpos = HelperMethods.getTargetedEntity((class_1297)player, iceCometRange).method_19538();
        }
        if (blockpos == null) {
            blockpos = HelperMethods.getPositionLookingAt(player, iceCometRange);
        }
        if (blockpos != null) {
            int xpos = (int)blockpos.method_10216();
            int ypos = (int)blockpos.method_10214();
            int zpos = (int)blockpos.method_10215();
            class_2338 searchArea = new class_2338(xpos, ypos, zpos);
            class_238 box = HelperMethods.createBoxAtBlock(searchArea, 3);
            for (class_1297 entities : player.method_37908().method_8333((class_1297)player, box, class_1301.field_6157)) {
                class_1309 le;
                if (!(entities instanceof class_1309) || !HelperMethods.checkFriendlyFire(le = (class_1309)entities, player)) continue;
                target = le;
                break;
            }
            if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationIceCometLeap, (class_1309)player)) {
                player.method_18799(player.method_5720().method_22882().method_1021((double)leapVelocity));
                player.method_18800(player.method_18798().field_1352, leapHeight, player.method_18798().field_1350);
                player.method_6092(new class_1293(class_1294.field_5906, leapSlowfallDuration, 0, false, false, true));
                player.field_6037 = true;
            }
            if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationIceCometVolley, (class_1309)player)) {
                player.method_6092(new class_1293(EffectRegistry.FROSTVOLLEY, volleyDuration, volleyStacks, false, false, true));
            }
            if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationIceCometDamageOne, (class_1309)player)) {
                SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:ice_comet_large", 3, (class_1297)target, searchArea);
            } else if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationIceCometDamageTwo, (class_1309)player)) {
                SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:ice_comet_large_two", 3, (class_1297)target, searchArea);
            } else if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationIceCometDamageThree, (class_1309)player)) {
                SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:ice_comet_large_three", 3, (class_1297)target, searchArea);
            } else {
                SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:ice_comet", 3, (class_1297)target, searchArea);
            }
        }
        if (blockpos != null || target != null) {
            success = true;
        }
        return success;
    }

    public static boolean signatureWizardStaticDischarge(String wizardSkillTree, class_1657 player) {
        class_243 blockpos = null;
        boolean success = false;
        int amplifier = SimplySkills.wizardConfig.signatureWizardStaticDischargeBaseLeaps;
        int leapsPerTier = SimplySkills.wizardConfig.signatureWizardStaticDischargeLeapsPerTier;
        int staticDischargeRange = SimplySkills.wizardConfig.signatureWizardStaticDischargeRange;
        int staticChargeDuration = SimplySkills.wizardConfig.signatureWizardStaticChargeDuration;
        if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationStaticDischargeLeapTwo, (class_1309)player)) {
            amplifier += leapsPerTier;
        } else if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationStaticDischargeLeapThree, (class_1309)player)) {
            amplifier += leapsPerTier * 2;
        }
        if (HelperMethods.getTargetedEntity((class_1297)player, staticDischargeRange) != null) {
            blockpos = HelperMethods.getTargetedEntity((class_1297)player, staticDischargeRange).method_19538();
        }
        if (blockpos == null) {
            blockpos = HelperMethods.getPositionLookingAt(player, staticDischargeRange);
        }
        if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationStaticDischargeLightningBall, (class_1309)player)) {
            SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:lightning_ball", 3, null, null);
            success = true;
        } else if (blockpos != null) {
            int xpos = (int)blockpos.method_10216();
            int ypos = (int)blockpos.method_10214();
            int zpos = (int)blockpos.method_10215();
            class_2338 searchArea = new class_2338(xpos, ypos, zpos);
            class_238 box = HelperMethods.createBoxAtBlock(searchArea, 3);
            for (class_1297 entities : player.method_37908().method_8333((class_1297)player, box, class_1301.field_6157)) {
                class_1309 le;
                if (entities == null || !(entities instanceof class_1309) || !HelperMethods.checkFriendlyFire(le = (class_1309)entities, player)) continue;
                success = true;
                SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:static_discharge", 3, (class_1297)le, searchArea);
                if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationStaticDischargeLeap, (class_1309)player)) {
                    le.method_6092(new class_1293(EffectRegistry.STATICCHARGE, staticChargeDuration, amplifier, false, false, true));
                }
                StaticChargeEffect.onHitEffects(player, StaticChargeEffect.calculateSpeedChance(player), le);
                break;
            }
        }
        return success;
    }

    public static void signatureWizardStaticDischargeBall(class_3222 player, SpellProjectile spellProjectile, class_2960 spellId, SpellHelper.ImpactContext context, Spell.ProjectileData.Perks perks) {
        if (player != null && spellProjectile.field_6012 % 5 == 0 && spellProjectile.field_6012 > 5 && (spellId.toString().contains("lightning_ball") || spellId.toString().contains("lightning_lesser"))) {
            if (HelperMethods.isUnlocked("simplyskills:wizard", SkillReferencePosition.wizardSpecialisationStaticDischargeLightningBall, (class_1309)player)) {
                class_243 position = spellProjectile.method_19538();
                if (!spellId.toString().contains("ball_homing")) {
                    perks.pierce = 132;
                    SpellProjectile projectile = new SpellProjectile(spellProjectile.method_37908(), (class_1309)spellProjectile.method_24921(), position.method_10216(), position.method_10214(), position.method_10215(), spellProjectile.behaviour(), new class_2960("simplyskills:lightning_lesser"), (class_1297)null, context, perks.copy());
                    projectile.method_18799(spellProjectile.method_18798().method_1021(5.0));
                    projectile.range = spellProjectile.range;
                    class_1675.method_7484((class_1297)projectile, (float)0.2f);
                    int radius = 5;
                    ArrayList<class_1297> targets = new ArrayList<class_1297>();
                    class_238 box = new class_238(spellProjectile.method_23317() + (double)radius, spellProjectile.method_23318() + (double)((float)radius / 2.0f), spellProjectile.method_23321() + (double)radius, spellProjectile.method_23317() - (double)radius, spellProjectile.method_23318() - (double)((float)radius / 2.0f), spellProjectile.method_23321() - (double)radius);
                    for (class_1297 entities : player.method_37908().method_8333((class_1297)player, box, class_1301.field_6157)) {
                        class_1309 le;
                        if (entities == null || player.method_6051().method_43048(100) >= 5 || !(entities instanceof class_1309) || !HelperMethods.checkFriendlyFire(le = (class_1309)entities, (class_1657)player)) continue;
                        projectile.setFollowedTarget((class_1297)le);
                        spellProjectile.method_37908().method_8649((class_1297)projectile);
                        targets.add((class_1297)le);
                        AbilityLogic.onSpellCastEffects((class_1657)player, targets, spellId, null);
                        StaticChargeEffect.onHitEffects((class_1657)player, StaticChargeEffect.calculateSpeedChance((class_1657)player), le);
                        targets.clear();
                        break;
                    }
                }
            }
            if (HelperMethods.isUnlocked("simplyskills:wizard", SkillReferencePosition.wizardSpecialisationStaticDischargeLightningOrb, (class_1309)player) && spellId.toString().contains("lightning_ball")) {
                spellProjectile.setFollowedTarget((class_1297)player);
                spellProjectile.range = 512.0f;
                spellProjectile.method_36457(90.0f);
            }
        }
    }

    public static void signatureWizardLightningOrb(SpellProjectile spellProjectile, class_1297 followedTarget, class_2960 spellId) {
        if (spellId != null && spellId.toString().equals("simplyskills:lightning_ball_homing") && spellProjectile.field_6012 % 20 == 0 && followedTarget != null && spellProjectile.method_5739(followedTarget) > 10.0f) {
            spellProjectile.method_20620(followedTarget.method_23317(), followedTarget.method_23318(), followedTarget.method_23321());
            spellProjectile.method_36457(90.0f);
            spellProjectile.field_6037 = true;
        }
    }

    public static void signatureWizardLightningOrbBuff(class_1657 player) {
        int radius = SimplySkills.wizardConfig.signatureWizardLightningOrbBuffRadius;
        int frequency = SimplySkills.wizardConfig.signatureWizardLightningOrbBuffFrequency;
        int count = 0;
        class_238 box = new class_238(player.method_23317() + (double)radius, player.method_23318() + (double)((float)radius * 3.0f), player.method_23321() + (double)radius, player.method_23317() - (double)radius, player.method_23318() - (double)((float)radius * 3.0f), player.method_23321() - (double)radius);
        if (player.field_6012 % frequency == 0) {
            for (class_1297 entities : player.method_37908().method_8333((class_1297)player, box, class_1301.field_6154)) {
                SpellProjectile spe;
                if (entities == null || player.method_6051().method_43048(100) >= SimplySkills.wizardConfig.signatureWizardLightningOrbBuffChance || !(entities instanceof SpellProjectile) || (spe = (SpellProjectile)entities).method_24921() == null || spe.method_24921() != player) continue;
                ++count;
            }
            if (count > 0) {
                HelperMethods.incrementStatusEffect((class_1309)player, EffectRegistry.SOULSHOCK, frequency + 5, count, count);
            }
        }
    }

    public static boolean signatureWizardArcaneBolt(String wizardSkillTree, class_1657 player) {
        class_1309 le;
        boolean success = false;
        class_1297 target = null;
        int volleyDuration = SimplySkills.wizardConfig.signatureWizardArcaneBoltVolleyDuration;
        int volleyStacks = SimplySkills.wizardConfig.signatureWizardArcaneBoltVolleyStacks - 1;
        int arcaneBoltRange = SimplySkills.wizardConfig.signatureWizardArcaneBoltRange;
        int radius = 3;
        if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationArcaneBoltLesser, (class_1309)player)) {
            radius = SimplySkills.wizardConfig.signatureWizardLesserArcaneBoltRadius;
        }
        target = HelperMethods.getTargetedEntity((class_1297)player, arcaneBoltRange);
        class_2338 searchArea = HelperMethods.getBlockLookingAt(player, 512);
        if (target instanceof class_1309 && HelperMethods.checkFriendlyFire(le = (class_1309)target, player) || target == null) {
            if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationArcaneBoltVolley, (class_1309)player)) {
                player.method_6092(new class_1293(EffectRegistry.ARCANEVOLLEY, volleyDuration, volleyStacks, false, false, true));
            }
            if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationArcaneBoltLesser, (class_1309)player)) {
                SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:arcane_bolt_expanding", radius, target, searchArea);
            } else if (HelperMethods.isUnlocked(wizardSkillTree, SkillReferencePosition.wizardSpecialisationArcaneBoltGreater, (class_1309)player)) {
                SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:arcane_bolt_greater", radius, target, searchArea);
            } else {
                SignatureAbilities.castSpellEngineIndirectTarget(player, "simplyskills:arcane_bolt", radius, target, searchArea);
            }
            success = true;
        }
        return success;
    }
}

